/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facility.util;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.facility.beans.FacilityGroupLiteBean;
import com.aimluck.eip.facility.beans.FacilityLiteBean;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class FacilityUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityUtils.class.getName());

    public static List<FacilityLiteBean> getFacilityLiteBeans(RunData rundata) {
        ArrayList<FacilityLiteBean> facilityAllList = new ArrayList<FacilityLiteBean>();
        try {
            SelectQuery query = Database.query(EipMFacility.class);
            query.orderAscending("sort");
            List facility_list = query.orderAscending("facilityName").fetchList();
            for (EipMFacility record : facility_list) {
                FacilityLiteBean bean = new FacilityLiteBean();
                bean.initField();
                bean.setFacilityId(record.getFacilityId().longValue());
                bean.setFacilityName(record.getFacilityName());
                facilityAllList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"FacilityUtils.getFacilityLiteBeans", (Throwable)ex);
        }
        return facilityAllList;
    }

    public static List<FacilityLiteBean> getFacilityFromGroupId(RunData rundata, int groupid) {
        List facility_list;
        ArrayList<FacilityLiteBean> facilityAllList = new ArrayList<FacilityLiteBean>();
        SelectQuery mapquery = Database.query(EipMFacilityGroupMap.class);
        Expression mapexp = ExpressionFactory.matchExp((String)"GroupId", (Object)groupid);
        mapquery.setQualifier(mapexp);
        List FacilityMaps = mapquery.fetchList();
        ArrayList<Integer> facilityIds = new ArrayList<Integer>();
        for (EipMFacilityGroupMap map : FacilityMaps) {
            facilityIds.add(map.getEipMFacilityFacilityId().getFacilityId());
        }
        if (facilityIds.isEmpty()) {
            facility_list = new ArrayList(0);
        } else {
            SelectQuery fquery = Database.query(EipMFacility.class);
            Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
            fquery.setQualifier(fexp);
            fquery.orderAscending("sort");
            facility_list = fquery.fetchList();
        }
        for (EipMFacility record : facility_list) {
            FacilityLiteBean bean = new FacilityLiteBean();
            bean.initField();
            bean.setFacilityId(record.getFacilityId().longValue());
            bean.setFacilityName(record.getFacilityName());
            facilityAllList.add(bean);
        }
        return facilityAllList;
    }

    public static List<FacilityLiteBean> getFacilityFromGroupName(RunData rundata, String groupname) {
        SelectQuery query = Database.query(EipMFacilityGroup.class);
        Expression exp = ExpressionFactory.matchExp((String)"groupName", (Object)groupname);
        query.setQualifier(exp);
        EipMFacilityGroup group = (EipMFacilityGroup)query.fetchSingle();
        return FacilityUtils.getFacilityFromGroupId(rundata, group.getGroupId());
    }

    public static List<FacilityGroupLiteBean> getFacilityGroupLiteBeans() {
        ArrayList<FacilityGroupLiteBean> facilityGroupAllList = new ArrayList<FacilityGroupLiteBean>();
        try {
            SelectQuery query = Database.query(EipMFacilityGroup.class);
            List facility_list = query.orderAscending("groupName").fetchList();
            for (EipMFacilityGroup record : facility_list) {
                FacilityGroupLiteBean bean = new FacilityGroupLiteBean();
                bean.initField();
                bean.setFacilityGroupId(record.getGroupId().longValue());
                bean.setFacilityGroupName(record.getGroupName());
                facilityGroupAllList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"FacilityUtils.getFacilityFromGroupName", (Throwable)ex);
        }
        return facilityGroupAllList;
    }
}

