/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class NumberValidator
extends DefaultValidator {
    private static String INVALID_NUMBER = "Entry was not a valid number";
    private BigDecimal minValue;
    protected String minValueMessage;
    private BigDecimal maxValue;
    protected String maxValueMessage;
    protected String invalidNumberMessage = this.getDefaultInvalidNumberMessage();

    public NumberValidator(Map map) throws ServiceException {
        this();
        this.init(map);
    }

    public NumberValidator() {
    }

    public void init(Map map) throws ServiceException {
        super.init(map);
        this.minValueMessage = null;
        this.maxValueMessage = null;
        this.doInit(map);
        Constraint constraint = (Constraint)map.get("notANumberMessage");
        if (constraint != null) {
            String string = constraint.getValue();
            if (string != null && string.length() != 0) {
                this.invalidNumberMessage = string;
            } else if (constraint.getMessage().length() != 0) {
                this.invalidNumberMessage = constraint.getMessage();
            }
        }
    }

    protected void doInit(Map map) {
        String string;
        this.minValue = null;
        this.maxValue = null;
        Constraint constraint = (Constraint)map.get("minValue");
        if (constraint != null) {
            string = constraint.getValue();
            this.minValue = new BigDecimal(string);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("maxValue")) != null) {
            string = constraint.getValue();
            this.maxValue = new BigDecimal(string);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getDefaultInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String string) throws ValidationException {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (RuntimeException runtimeException) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (this.minValue != null && bigDecimal.compareTo(this.minValue) < 0) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (this.maxValue != null && bigDecimal.compareTo(this.maxValue) > 0) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public BigDecimal getMinValueAsBigDecimal() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal bigDecimal) {
        this.minValue = bigDecimal;
    }

    public String getMinValueMessage() {
        return this.minValueMessage;
    }

    public void setMinValueMessage(String string) {
        this.minValueMessage = string;
    }

    public BigDecimal getMaxValueAsBigDecimal() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal bigDecimal) {
        this.maxValue = bigDecimal;
    }

    public String getMaxValueMessage() {
        return this.maxValueMessage;
    }

    public void setMaxValueMessage(String string) {
        this.maxValueMessage = string;
    }

    public String getInvalidNumberMessage() {
        return this.invalidNumberMessage;
    }

    public void setInvalidNumberMessage(String string) {
        this.invalidNumberMessage = string;
    }
}

