/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.ServiceManager;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.localization.Localization;

public class LocalizationTest
extends TestCase {
    private static final String PREFIX = "services.LocalizationService.";
    static /* synthetic */ Class class$org$apache$fulcrum$localization$LocalizationTest;
    static /* synthetic */ Class class$org$apache$fulcrum$localization$TurbineLocalizationService;

    public LocalizationTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$fulcrum$localization$LocalizationTest == null ? (class$org$apache$fulcrum$localization$LocalizationTest = LocalizationTest.class$("org.apache.fulcrum.localization.LocalizationTest")) : class$org$apache$fulcrum$localization$LocalizationTest);
    }

    public void testLocalization() {
        try {
            ServiceManager serviceManager = TurbineServices.getInstance();
            serviceManager.setApplicationRoot(".");
            BaseConfiguration baseConfiguration = new BaseConfiguration();
            baseConfiguration.setProperty("services.LocalizationService.classname", (Object)(class$org$apache$fulcrum$localization$TurbineLocalizationService == null ? (class$org$apache$fulcrum$localization$TurbineLocalizationService = LocalizationTest.class$("org.apache.fulcrum.localization.TurbineLocalizationService")) : class$org$apache$fulcrum$localization$TurbineLocalizationService).getName());
            baseConfiguration.setProperty("services.LocalizationService.locale.default.bundles", (Object)"FooBundle,MissingBundle,BarBundle");
            baseConfiguration.setProperty("services.LocalizationService.locale.default.language", (Object)"en");
            baseConfiguration.setProperty("services.LocalizationService.locale.default.country", (Object)"US");
            serviceManager.setConfiguration((Configuration)baseConfiguration);
            serviceManager.init();
            String string = Localization.getString(null, null, "key1");
            Assert.assertEquals((String)"Unable to retrieve localized text for locale: default", (Object)string, (Object)"value1");
            string = Localization.getString(null, new Locale("en", "US"), "key2");
            Assert.assertEquals((String)"Unable to retrieve localized text for locale: en-US", (Object)string, (Object)"value2");
            string = Localization.getString(null, new Locale("fr", "US"), "key3");
            Assert.assertEquals((String)"Unable to retrieve localized text for locale: fr", (Object)string, (Object)"[fr] value3");
            string = Localization.getString("BarBundle", new Locale("ko", "KR"), "key3");
            Assert.assertEquals((String)"Unable to retrieve localized text for locale: ko-KR", (Object)string, (Object)"[ko] value3");
            try {
                Localization.getString("DoesNotExist", new Locale("ko", ""), "key1");
                Assert.fail();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            string = Localization.getString(null, new Locale("ko", "KR"), "key3");
            Assert.assertEquals((String)"Unable to retrieve localized text for locale: default", (Object)string, (Object)"value3");
            try {
                Localization.getString(null, null, "NoSuchKey");
                Assert.fail();
            }
            catch (MissingResourceException missingResourceException) {}
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

