/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.util.ArrayList;

public class MimeType
implements Cloneable {
    public static MimeType TEXT_HTML = new MimeType("text/html");
    public static MimeType TEXT_WML = new MimeType("text/vnd.wap.wml");
    public static MimeType TEXT_HDML = new MimeType("text/x-hdml");
    public static MimeType TEXT_CHTML = new MimeType("text/x-chtml");
    public static MimeType TEXT_PLAIN = new MimeType("text/plain");
    public static MimeType MULTIPART = new MimeType("multipart/*");
    public static MimeType MULTIPART_FORM_DATA = new MimeType("multipart/form-data");
    public static MimeType APPLICATION_POSTSCRIPT = new MimeType("application/postscript");
    public static MimeType APPLICATION_OCTET_STREAM = new MimeType("application/octet-stream");
    public static MimeType APPLICATION_X_JAVA_AGENT = new MimeType("application/x-java-agent");
    public static MimeType APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application/x-www-form-urlencoded");
    public static MimeType MESSAGE_HTTP = new MimeType("message/http");
    public static MimeType TEXT_CSS = new MimeType("text/css");
    public static MimeType TEXT = new MimeType("text/*");
    public static MimeType IMAGE_GIF = new MimeType("image/gif");
    public static MimeType IMAGE_JPEG = new MimeType("image/jpeg");
    public static MimeType IMAGE_WBMP = new MimeType("image/vnd.wap.wbmp");
    public static final int NO_MATCH = 0;
    public static final int MATCH_TYPE = 1;
    public static final int MATCH_SUBTYPE = 2;
    public static final int MATCH_SPECIFIC_SUBTYPE = 3;
    private String mimeType;
    private String mimeSubtype;
    private String[] parameterNames;
    private String[] parameterValues;
    private String mimeTypeString;

    public MimeType(String string) {
        this(string, true);
    }

    /*
     * Unable to fully structure code
     */
    public MimeType(String var1_1, boolean var2_2) {
        block16: {
            super();
            var3_3 = 0;
            var4_4 = '\u0000';
            var5_5 = var1_1.length();
            while (var3_3 < var5_5 && Character.isWhitespace(var1_1.charAt(var3_3))) {
                ++var3_3;
            }
            while (var5_5 > var3_3 && Character.isWhitespace(var1_1.charAt(var5_5 - 1))) {
                --var5_5;
            }
            var6_6 = new StringBuffer();
            if (true) ** GOTO lbl17
            do {
                var6_6.append(var4_4);
                ++var3_3;
lbl17:
                // 2 sources

                if (var3_3 >= var5_5) break;
                v0 = var1_1.charAt(var3_3);
                var4_4 = v0;
            } while (v0 != '/');
            if (var4_4 != '/') {
                throw new IllegalArgumentException("Syntax error in MIME type " + var1_1);
            }
            this.mimeType = var6_6.toString();
            ++var3_3;
            var6_6.setLength(0);
            while (var3_3 < var5_5 && (var4_4 = var1_1.charAt(var3_3)) != ';' && !Character.isWhitespace(var4_4)) {
                var6_6.append(var4_4);
                ++var3_3;
            }
            this.mimeSubtype = var6_6.toString();
            if (!var2_2) break block16;
            while (var3_3 < var5_5 && Character.isWhitespace(var1_1.charAt(var3_3))) {
                ++var3_3;
            }
            if (var3_3 >= var5_5) break block16;
            if (var1_1.charAt(var3_3) != ';') {
                throw new IllegalArgumentException("Syntax error in MIME type parameters " + var1_1);
            }
            ++var3_3;
            var7_7 = new ArrayList<String>(4);
            var8_8 = new ArrayList<String>(4);
            ** GOTO lbl81
            {
                ++var3_3;
                do {
                    if (var3_3 < var5_5 && Character.isWhitespace(var1_1.charAt(var3_3))) continue block5;
                    var6_6.setLength(0);
                    while (var3_3 < var5_5 && (var4_4 = var1_1.charAt(var3_3)) != '=' && !Character.isWhitespace(var4_4)) {
                        var6_6.append(Character.toLowerCase(var4_4));
                        ++var3_3;
                    }
                    var9_9 = var6_6.toString();
                    while (var3_3 < var5_5 && Character.isWhitespace(var1_1.charAt(var3_3))) {
                        ++var3_3;
                    }
                    if (var1_1.charAt(var3_3) != '=') {
                        throw new IllegalArgumentException("Syntax error in MIME type parameters " + var1_1);
                    }
                    ++var3_3;
                    while (var3_3 < var5_5 && Character.isWhitespace(var1_1.charAt(var3_3))) {
                        ++var3_3;
                    }
                    var6_6.setLength(0);
                    var10_10 = 59;
                    if (var1_1.charAt(var3_3) == '\"') {
                        ++var3_3;
                        var10_10 = 34;
                    }
                    while (!(var3_3 >= var5_5 || (var4_4 = var1_1.charAt(var3_3)) == var10_10 || var10_10 != 34 && Character.isWhitespace(var4_4))) {
                        var6_6.append(var4_4);
                        ++var3_3;
                    }
                    while (var3_3 < var5_5 && var1_1.charAt(var3_3) != ';') {
                        ++var3_3;
                    }
                    ++var3_3;
                    var11_11 = var6_6.toString();
                    var7_7.add(var9_9);
                    var8_8.add(var11_11);
lbl81:
                    // 2 sources

                } while (var3_3 < var5_5);
            }
            this.parameterNames = var7_7.toArray(new String[var7_7.size()]);
            this.parameterValues = var8_8.toArray(new String[var8_8.size()]);
        }
    }

    public MimeType(String string, String string2) {
        this(string, string2, null, null);
    }

    public MimeType(String string, String string2, String[] stringArray, String[] stringArray2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("MIME type or subtype missing");
        }
        this.mimeType = string.trim();
        this.mimeSubtype = string2.trim();
        this.parameterNames = stringArray;
        this.parameterValues = stringArray2;
    }

    public int match(MimeType mimeType) {
        if (this.mimeType.equals("*") || mimeType.mimeType.equals("*")) {
            return 1;
        }
        if (!this.mimeType.equalsIgnoreCase(mimeType.mimeType)) {
            return 0;
        }
        if (this.mimeSubtype.equals("*") || mimeType.mimeSubtype.equals("*")) {
            return 2;
        }
        if (!this.mimeSubtype.equalsIgnoreCase(mimeType.mimeSubtype)) {
            return 0;
        }
        return 3;
    }

    public String getType() {
        return this.mimeType;
    }

    public String getSubtype() {
        return this.mimeSubtype;
    }

    public String getTypes() {
        return this.mimeType + '/' + this.mimeSubtype;
    }

    public boolean hasParameter(String string) {
        String[] stringArray = this.parameterNames;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public String getParameter(String string) {
        String[] stringArray = this.parameterNames;
        if (stringArray != null) {
            String[] stringArray2 = this.parameterValues;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return stringArray2[n];
                }
                ++n;
            }
        }
        return null;
    }

    public synchronized void setParameter(String string, String string2) {
        if (this.parameterNames != null) {
            int n = 0;
            while (n < this.parameterNames.length) {
                if (this.parameterNames[n].equalsIgnoreCase(string)) {
                    this.parameterValues[n] = string2;
                    this.mimeTypeString = null;
                    return;
                }
                ++n;
            }
        }
        this.addParameter(string, string2);
    }

    public void addParameter(String string, String string2) {
        this.addParameters(new String[]{string}, new String[]{string2});
    }

    public synchronized void addParameters(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Incorrect MIME type parameters");
        }
        if (this.parameterNames != null) {
            String[] stringArray3 = new String[this.parameterNames.length + stringArray.length];
            String[] stringArray4 = new String[this.parameterValues.length + stringArray2.length];
            System.arraycopy(this.parameterNames, 0, stringArray3, 0, this.parameterNames.length);
            System.arraycopy(stringArray, 0, stringArray3, this.parameterNames.length, stringArray.length);
            System.arraycopy(this.parameterValues, 0, stringArray4, 0, this.parameterValues.length);
            System.arraycopy(stringArray2, 0, stringArray4, this.parameterValues.length, stringArray2.length);
            this.parameterNames = stringArray3;
            this.parameterValues = stringArray4;
        } else {
            this.parameterNames = stringArray;
            this.parameterValues = stringArray2;
        }
        this.mimeTypeString = null;
    }

    public String toString() {
        if (this.mimeTypeString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.mimeType);
            stringBuffer.append('/');
            stringBuffer.append(this.mimeSubtype);
            String[] stringArray = this.parameterNames;
            if (stringArray != null) {
                String[] stringArray2 = this.parameterValues;
                int n = 0;
                while (n < stringArray2.length) {
                    stringBuffer.append(';');
                    stringBuffer.append(stringArray[n]);
                    if (stringArray2[n] != null) {
                        stringBuffer.append('=');
                        stringBuffer.append(stringArray2[n]);
                    }
                    ++n;
                }
            }
            this.mimeTypeString = stringBuffer.toString();
        }
        return this.mimeTypeString;
    }
}

