/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fulcrum.mimetype.util.MimeType;
import org.apache.fulcrum.mimetype.util.MimeTypeMapper;

public class MimeTypeMap {
    public static final MimeType DEFAULT_MIMETYPE = MimeType.APPLICATION_OCTET_STREAM;
    public static final String DEFAULT_TYPE = DEFAULT_MIMETYPE.toString();
    public static final String MIMETYPE_RESOURCE = "mime.types";
    public static final String EXT_HTML = "html";
    public static final String EXT_HTM = "htm";
    public static final String EXT_WML = "wml";
    public static final String EXT_HDML = "hdml";
    public static final String EXT_HDM = "hdm";
    public static final String EXT_CHTML = "chtml";
    public static final String EXT_TEXT = "txt";
    public static final String EXT_GIF = "gif";
    public static final String EXT_JPEG = "jpeg";
    public static final String EXT_JPG = "jpg";
    public static final String EXT_WBMP = "wbmp";
    private static final int MAP_PROG = 0;
    private static final int MAP_HOME = 1;
    private static final int MAP_SYS = 2;
    private static final int MAP_JAR = 3;
    private static final int MAP_COM = 4;
    private static MimeTypeMapper commonMapper = new MimeTypeMapper();
    private MimeTypeMapper[] mappers = new MimeTypeMapper[5];
    static /* synthetic */ Class class$org$apache$fulcrum$mimetype$util$MimeTypeMap;

    protected static MimeTypeMapper loadPath(String string) throws IOException {
        return new MimeTypeMapper(string);
    }

    protected static MimeTypeMapper loadResource(String string) {
        InputStream inputStream = (class$org$apache$fulcrum$mimetype$util$MimeTypeMap == null ? (class$org$apache$fulcrum$mimetype$util$MimeTypeMap = MimeTypeMap.class$("org.apache.fulcrum.mimetype.util.MimeTypeMap")) : class$org$apache$fulcrum$mimetype$util$MimeTypeMap).getResourceAsStream(string);
        if (inputStream != null) {
            try {
                return new MimeTypeMapper(inputStream);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public MimeTypeMap() {
        String string;
        try {
            string = System.getProperty("user.home");
            if (string != null) {
                string = string + File.separator + MIMETYPE_RESOURCE;
                this.mappers[1] = MimeTypeMap.loadPath(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = System.getProperty("java.home") + File.separator + "lib" + File.separator + MIMETYPE_RESOURCE;
            this.mappers[2] = MimeTypeMap.loadPath(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mappers[3] = MimeTypeMap.loadResource("/META-INF/mime.types");
        this.mappers[4] = commonMapper;
    }

    public MimeTypeMap(InputStream inputStream) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(inputStream);
    }

    public MimeTypeMap(File file) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(file);
    }

    public MimeTypeMap(String string) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(string);
    }

    public synchronized void setContentType(String string) {
        if (this.mappers[0] == null) {
            this.mappers[0] = new MimeTypeMapper();
        }
        this.mappers[0].setContentType(string);
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public String getContentType(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(n + 1);
            return string2.length() > 0 ? this.getContentType(string2, DEFAULT_TYPE) : DEFAULT_TYPE;
        }
        return DEFAULT_TYPE;
    }

    public String getContentType(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        n = 0;
        while (n < this.mappers.length) {
            String string3;
            MimeTypeMapper mimeTypeMapper = this.mappers[n];
            if (mimeTypeMapper != null && (string3 = mimeTypeMapper.getContentType(string)) != null) {
                return string3;
            }
            ++n;
        }
        return string2;
    }

    public MimeType getMimeContentType(File file) {
        try {
            return new MimeType(this.getContentType(file));
        }
        catch (Exception exception) {
            return DEFAULT_MIMETYPE;
        }
    }

    public MimeType getMimeContentType(String string) {
        try {
            return new MimeType(this.getContentType(string));
        }
        catch (Exception exception) {
            return DEFAULT_MIMETYPE;
        }
    }

    public MimeType getMimeContentType(String string, String string2) {
        try {
            return new MimeType(this.getContentType(string, string2));
        }
        catch (Exception exception) {
            return DEFAULT_MIMETYPE;
        }
    }

    public String getDefaultExtension(String string) {
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        string = string.trim();
        n = this.mappers.length - 1;
        while (n >= 0) {
            String string2;
            MimeTypeMapper mimeTypeMapper = this.mappers[n];
            if (mimeTypeMapper != null && (string2 = mimeTypeMapper.getExtension(string)) != null) {
                return string2;
            }
            --n;
        }
        return null;
    }

    public String getDefaultExtension(MimeType mimeType) {
        return this.getDefaultExtension(mimeType.getTypes());
    }

    protected synchronized void setCommonContentType(String string) {
        this.mappers[4].setContentType(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        commonMapper.setContentType(MimeType.TEXT_HTML.toString() + " " + EXT_HTML + " " + EXT_HTM);
        commonMapper.setContentType(MimeType.TEXT_WML.toString() + " " + EXT_WML);
        commonMapper.setContentType(MimeType.TEXT_HDML.toString() + " " + EXT_HDML + " " + EXT_HDM);
        commonMapper.setContentType(MimeType.TEXT_CHTML.toString() + " " + EXT_CHTML);
        commonMapper.setContentType(MimeType.TEXT_PLAIN.toString() + " " + EXT_TEXT);
        commonMapper.setContentType(MimeType.IMAGE_GIF.toString() + " " + EXT_GIF);
        commonMapper.setContentType(MimeType.IMAGE_JPEG.toString() + " " + EXT_JPEG + " " + EXT_JPG);
        commonMapper.setContentType(MimeType.IMAGE_WBMP.toString() + " " + EXT_WBMP);
    }
}

