/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import java.util.Calendar;
import java.util.Date;
import org.apache.fulcrum.schedule.BaseJobEntry;
import org.apache.torque.om.Persistent;

public class JobEntry
extends BaseJobEntry
implements Persistent,
Comparable {
    private boolean jobIsActive = false;
    private long runtime = 0L;
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int WEEK_DAY = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int DAILY = 4;

    public JobEntry() {
    }

    public JobEntry(int n, int n2, int n3, int n4, int n5, String string) throws Exception {
        if (string == null || string.length() == 0) {
            throw new Exception("Error in JobEntry. Bad Job parameter. Task not set.");
        }
        this.setSecond(n);
        this.setMinute(n2);
        this.setHour(n3);
        this.setWeekDay(n4);
        this.setDayOfMonth(n5);
        this.setTask(string);
        this.calcRunTime();
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof JobEntry) {
            n = this.getJobId().getBigDecimal().compareTo(((JobEntry)object).getJobId().getBigDecimal());
        }
        return n;
    }

    public void setActive(boolean bl) {
        this.jobIsActive = bl;
    }

    public boolean isActive() {
        return this.jobIsActive;
    }

    public long getNextRuntime() {
        return this.runtime;
    }

    public String getNextRunAsString() {
        return new Date(this.runtime).toString();
    }

    public void calcRunTime() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        switch (this.evaluateJobType()) {
            case 0: {
                calendar.add(13, this.getSecond());
                this.runtime = calendar.getTime().getTime();
                break;
            }
            case 1: {
                calendar.add(13, this.getSecond());
                calendar.add(12, this.getMinute());
                this.runtime = calendar.getTime().getTime();
                break;
            }
            case 2: {
                calendar.set(13, this.getSecond());
                calendar.set(12, this.getMinute());
                calendar.set(11, this.getHour());
                calendar.set(7, this.getWeekDay());
                if (calendar2.before(calendar)) {
                    this.runtime = calendar.getTime().getTime();
                    break;
                }
                calendar.add(7, 7);
                this.runtime = calendar.getTime().getTime();
                break;
            }
            case 3: {
                calendar.set(13, this.getSecond());
                calendar.set(12, this.getMinute());
                calendar.set(11, this.getHour());
                calendar.set(5, this.getDayOfMonth());
                if (calendar2.before(calendar)) {
                    this.runtime = calendar.getTime().getTime();
                    break;
                }
                calendar.add(2, 1);
                this.runtime = calendar.getTime().getTime();
                break;
            }
            case 4: {
                calendar.set(13, this.getSecond());
                calendar.set(12, this.getMinute());
                calendar.set(11, this.getHour());
                if (calendar2.before(calendar)) {
                    this.runtime = calendar.getTime().getTime();
                    break;
                }
                calendar.add(11, 24);
                this.runtime = calendar.getTime().getTime();
                break;
            }
        }
    }

    private int evaluateJobType() throws Exception {
        if (this.getDayOfMonth() < 0) {
            if (this.getWeekDay() < 0) {
                if (this.getHour() < 0) {
                    if (this.getMinute() < 0) {
                        if (this.getSecond() < 0) {
                            throw new Exception("Error in JobEntry. Bad Job parameter.");
                        }
                        return 0;
                    }
                    if (this.getMinute() < 0 || this.getSecond() < 0) {
                        throw new Exception("Error in JobEntry. Bad Job parameter.");
                    }
                    return 1;
                }
                if (this.getMinute() < 0 || this.getHour() < 0 || this.getSecond() < 0) {
                    throw new Exception("Error in JobEntry. Bad Job parameter.");
                }
                return 4;
            }
            if (this.getMinute() < 0 || this.getHour() < 0 || this.getSecond() < 0) {
                throw new Exception("Error in JobEntry. Bad Job parameter.");
            }
            return 2;
        }
        if (this.getMinute() < 0 || this.getHour() < 0) {
            throw new Exception("Error in JobEntry. Bad Job parameter.");
        }
        return 3;
    }
}

