/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.schedule.BaseJobEntryPeer;
import org.apache.fulcrum.schedule.JobEntry;
import org.apache.fulcrum.schedule.JobQueue;
import org.apache.fulcrum.schedule.ScheduleService;
import org.apache.fulcrum.schedule.WorkerThread;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.Criteria;

public class TurbineSchedulerService
extends BaseService
implements ScheduleService {
    protected JobQueue scheduleQueue = null;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;

    public void init() throws InitializationException {
        try {
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new MainLoop();
            Vector vector = BaseJobEntryPeer.doSelect(new Criteria());
            if (vector != null && vector.size() > 0) {
                Iterator iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    ((JobEntry)iterator.next()).calcRunTime();
                }
                this.scheduleQueue.batchLoad(vector);
                this.restart();
            }
            this.setInit(true);
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to start the scheduler service: ", exception);
        }
    }

    public void shutdown() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    public JobEntry getJob(int n) throws Exception {
        JobEntry jobEntry = BaseJobEntryPeer.retrieveByPK((ObjectKey)new NumberKey(n));
        return this.scheduleQueue.getJob(jobEntry);
    }

    public void addJob(JobEntry jobEntry) throws Exception {
        try {
            jobEntry.calcRunTime();
            jobEntry.save();
        }
        catch (Exception exception) {
            this.getCategory().error((Object)("Problem saving new Scheduled Job: " + exception));
        }
        this.scheduleQueue.add(jobEntry);
        this.restart();
    }

    public void removeJob(JobEntry jobEntry) throws Exception {
        try {
            Criteria criteria = new Criteria().add(BaseJobEntryPeer.JOB_ID, (Object)jobEntry.getPrimaryKey());
            BaseJobEntryPeer.doDelete(criteria);
        }
        catch (Exception exception) {
            this.getCategory().error((Object)("Problem removing Scheduled Job: " + exception));
        }
        this.scheduleQueue.remove(jobEntry);
        this.restart();
    }

    public void updateJob(JobEntry jobEntry) throws Exception {
        try {
            jobEntry.calcRunTime();
            jobEntry.save();
        }
        catch (Exception exception) {
            this.getCategory().error((Object)("Problem updating Scheduled Job: " + exception));
        }
        this.scheduleQueue.modify(jobEntry);
        this.restart();
    }

    public Vector listJobs() {
        return this.scheduleQueue.list();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    private synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.mainLoop, "SchedulerService");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    private synchronized JobEntry nextJob() throws Exception {
        try {
            while (!Thread.interrupted()) {
                JobEntry jobEntry = this.scheduleQueue.getNext();
                if (jobEntry == null) {
                    this.wait();
                    continue;
                }
                long l = System.currentTimeMillis();
                long l2 = jobEntry.getNextRuntime();
                if (l2 > l) {
                    this.wait(l2 - l);
                    continue;
                }
                this.scheduleQueue.updateQueue(jobEntry);
                return jobEntry;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    JobEntry jobEntry;
                    while ((jobEntry = TurbineSchedulerService.this.nextJob()) != null) {
                        WorkerThread workerThread = new WorkerThread(jobEntry);
                        Thread thread = new Thread(workerThread);
                        thread.start();
                    }
                    Object var5_5 = null;
                }
                catch (Exception exception) {
                    TurbineSchedulerService.this.getCategory().error((Object)("Error running a Scheduled Job: " + exception));
                    Object var5_6 = null;
                    TurbineSchedulerService.this.clearThread();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                TurbineSchedulerService.this.clearThread();
                throw throwable;
            }
            TurbineSchedulerService.this.clearThread();
        }
    }
}

