/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbinePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineRole;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.torque.om.BaseObject;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class TurbinePermissionPeer
extends BaseTurbinePermissionPeer {
    public static final String NAME = BaseTurbinePermissionPeer.PERMISSION_NAME;

    public static boolean checkExists(Permission permission) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(BaseTurbinePermissionPeer.PERMISSION_ID);
        criteria.add(NAME, (Object)permission.getName());
        Vector vector = BasePeer.doSelect((Criteria)criteria);
        if (vector.size() > 1) {
            throw new DataBackendException("Multiple permissions named '" + permission.getName() + "' exist!");
        }
        return vector.size() == 1;
    }

    public static String getColumnName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TURBINE_PERMISSION");
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getTableName() {
        return "TURBINE_PERMISSION";
    }

    public static PermissionSet retrieveSet(Criteria criteria) throws Exception {
        Vector vector = BaseTurbinePermissionPeer.doSelect(criteria);
        PermissionSet permissionSet = new PermissionSet();
        int n = 0;
        while (n < vector.size()) {
            permissionSet.add((Permission)vector.elementAt(n));
            ++n;
        }
        return permissionSet;
    }

    public static PermissionSet retrieveSet(Role role) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(BaseTurbineRolePermissionPeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
        criteria.addJoin(BaseTurbineRolePermissionPeer.PERMISSION_ID, BaseTurbinePermissionPeer.PERMISSION_ID);
        return TurbinePermissionPeer.retrieveSet(criteria);
    }

    public static final Vector getDifference(Vector vector, Vector vector2) {
        Vector vector3 = (Vector)vector2.clone();
        Enumeration enumeration = vector.elements();
        block0: while (enumeration.hasMoreElements()) {
            Permission permission = (Permission)enumeration.nextElement();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                Permission permission2 = (Permission)enumeration2.nextElement();
                if (((BaseObject)permission).getPrimaryKey() != ((BaseObject)permission2).getPrimaryKey()) continue;
                vector3.removeElement(permission2);
                continue block0;
            }
        }
        return vector3;
    }
}

