/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import java.net.URLDecoder;
import java.util.AbstractList;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.upload.TurbineUpload;
import org.apache.fulcrum.util.parser.BaseValueParser;
import org.apache.fulcrum.util.parser.ParameterParser;
import org.apache.log4j.Category;

public class DefaultParameterParser
extends BaseValueParser
implements ParameterParser,
Recyclable {
    private HttpServletRequest request = null;
    private byte[] uploadData = null;
    Category category = Category.getInstance((String)this.getClass().getName());

    public DefaultParameterParser() {
    }

    public DefaultParameterParser(String string) {
        super(string);
    }

    public void dispose() {
        this.request = null;
        this.uploadData = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        Object object;
        Object object2;
        this.clear();
        this.uploadData = null;
        String string = httpServletRequest.getCharacterEncoding();
        this.setCharacterEncoding(string != null ? string : "US-ASCII");
        String string2 = null;
        string2 = httpServletRequest.getHeader("Content-type");
        if (TurbineUpload.getAutomatic() && string2 != null && string2.startsWith("multipart/form-data")) {
            try {
                object2 = TurbineUpload.parseRequest(httpServletRequest);
                object = ((AbstractList)object2).iterator();
                while (object.hasNext()) {
                    FileItem fileItem = (FileItem)object.next();
                    if (fileItem.isFormField()) {
                        this.append(fileItem.getFieldName(), new String(fileItem.get()));
                        continue;
                    }
                    this.append(fileItem.getFieldName(), fileItem);
                }
            }
            catch (ServiceException serviceException) {
                this.category.error((Object)new ServiceException("File upload failed", (Throwable)((Object)serviceException)));
            }
        }
        if ((object2 = httpServletRequest.getParameterNames()) != null) {
            while (object2.hasMoreElements()) {
                string2 = (String)object2.nextElement();
                this.parameters.put(this.convert(string2), httpServletRequest.getParameterValues(string2));
            }
        }
        try {
            object = new StringTokenizer(httpServletRequest.getPathInfo(), "/");
            boolean bl = true;
            String string3 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                if (bl) {
                    string2 = URLDecoder.decode(((StringTokenizer)object).nextToken());
                    bl = false;
                    continue;
                }
                string3 = URLDecoder.decode(((StringTokenizer)object).nextToken());
                if (string2.length() > 0) {
                    this.add(this.convert(string2), string3);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.request = httpServletRequest;
    }

    public void setUploadData(byte[] byArray) {
        this.uploadData = byArray;
    }

    public byte[] setUploadData() {
        return this.uploadData;
    }

    public void append(String string, FileItem fileItem) {
        FileItem[] fileItemArray = this.getFileItems(string);
        if (fileItemArray == null) {
            fileItemArray = new FileItem[]{fileItem};
            this.parameters.put(this.convert(string), fileItemArray);
        } else {
            FileItem[] fileItemArray2 = new FileItem[fileItemArray.length + 1];
            System.arraycopy(fileItemArray, 0, fileItemArray2, 0, fileItemArray.length);
            fileItemArray2[fileItemArray.length] = fileItem;
            this.parameters.put(this.convert(string), fileItemArray2);
        }
    }

    public FileItem getFileItem(String string) {
        try {
            FileItem fileItem = null;
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                fileItem = ((FileItem[])v)[0];
            }
            return fileItem;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public FileItem[] getFileItems(String string) {
        try {
            return (FileItem[])this.parameters.get(this.convert(string));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

