/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.velocity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.template.BaseTemplateEngineService;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.velocity.ContextAdapter;
import org.apache.fulcrum.velocity.VelocityService;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.NullSetEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;

public class TurbineVelocityService
extends BaseTemplateEngineService
implements VelocityService {
    private static final String RESOURCE_LOADER_PATH = ".resource.loader.path";
    private static final String DEFAULT_CHAR_SET = "ISO-8859-1";
    private static final String JAR_PREFIX = "jar:";
    private static final String ABSOLUTE_PREFIX = "file://";
    private EventCartridge eventCartridge;
    private boolean eventCartridgeEnabled = true;

    public void init() throws InitializationException {
        try {
            this.initVelocity();
            this.initEventCartridges();
            this.registerConfiguration("vm");
            this.setInit(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InitializationException("Failed to initialize TurbineVelocityService", exception);
        }
    }

    public String handleRequest(TemplateContext templateContext, String string) throws ServiceException {
        return this.handleRequest(new ContextAdapter(templateContext), string);
    }

    public String handleRequest(Context context, String string) throws ServiceException {
        return this.handleRequest(context, string, (String)null, null);
    }

    /*
     * Loose catch block
     */
    public String handleRequest(Context context, String string, String string2, String string3) throws ServiceException {
        String string4;
        block11: {
            string4 = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            string2 = this.decodeRequest(context, string, byteArrayOutputStream, string2, string3);
            string4 = byteArrayOutputStream.toString(string2);
            Object var9_7 = null;
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (Exception exception) {
                    this.renderingError(string, exception);
                    Object var9_8 = null;
                    try {
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string4;
    }

    public void handleRequest(TemplateContext templateContext, String string, OutputStream outputStream) throws ServiceException {
        this.handleRequest((Context)new ContextAdapter(templateContext), string, outputStream);
    }

    public void handleRequest(Context context, String string, OutputStream outputStream) throws ServiceException {
        this.handleRequest(context, string, outputStream, null, null);
    }

    public void handleRequest(Context context, String string, OutputStream outputStream, String string2, String string3) throws ServiceException {
        this.decodeRequest(context, string, outputStream, string2, string3);
    }

    public void handleRequest(TemplateContext templateContext, String string, Writer writer) throws ServiceException {
        this.handleRequest((Context)new ContextAdapter(templateContext), string, writer);
    }

    public void handleRequest(Context context, String string, Writer writer) throws ServiceException {
        this.handleRequest(context, string, writer, null);
    }

    public void handleRequest(Context context, String string, Writer writer, String string2) throws ServiceException {
        try {
            VelocityContext velocityContext = new VelocityContext(context);
            EventCartridge eventCartridge = this.getEventCartridge();
            if (eventCartridge != null && this.eventCartridgeEnabled) {
                eventCartridge.attachToContext((Context)velocityContext);
            }
            if (string2 != null) {
                Velocity.mergeTemplate((String)string, (String)string2, (Context)velocityContext, (Writer)writer);
            } else {
                Velocity.mergeTemplate((String)string, (Context)velocityContext, (Writer)writer);
            }
        }
        catch (Exception exception) {
            this.renderingError(string, exception);
        }
    }

    public void setEventCartridgeEnabled(boolean bl) {
        this.eventCartridgeEnabled = bl;
    }

    public EventCartridge getEventCartridge() {
        return this.eventCartridge;
    }

    private String decodeRequest(Context context, String string, OutputStream outputStream, String string2, String string3) throws ServiceException {
        if (string2 == null) {
            string2 = DEFAULT_CHAR_SET;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string2);
            }
            catch (Exception exception) {
                this.renderingError(string, exception);
            }
            this.handleRequest(context, string, outputStreamWriter, string3);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (outputStreamWriter != null) {
                outputStreamWriter.flush();
            }
        }
        catch (Exception exception) {}
        return string2;
    }

    private final void renderingError(String string, Throwable throwable) throws ServiceException {
        String string2 = "Error rendering Velocity template: " + string;
        this.getCategory().error((Object)(string2 + ": " + throwable.getMessage()));
        if (throwable instanceof MethodInvocationException) {
            throwable = ((MethodInvocationException)throwable).getWrappedThrowable();
        }
        throw new ServiceException(string2, throwable);
    }

    private void initEventCartridges() throws InitializationException {
        this.eventCartridge = new EventCartridge();
        Vector vector = this.getConfiguration().getVector("eventCartridge.classes", null);
        if (vector == null) {
            this.getCategory().info((Object)"No Velocity EventCartridges configured.");
            return;
        }
        Object object = null;
        String string = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            try {
                boolean bl = false;
                object = Class.forName(string).newInstance();
                if (object instanceof ReferenceInsertionEventHandler) {
                    bl = this.getEventCartridge().addEventHandler((EventHandler)((ReferenceInsertionEventHandler)object));
                } else if (object instanceof NullSetEventHandler) {
                    bl = this.getEventCartridge().addEventHandler((EventHandler)((NullSetEventHandler)object));
                } else if (object instanceof MethodExceptionEventHandler) {
                    bl = this.getEventCartridge().addEventHandler((EventHandler)((MethodExceptionEventHandler)object));
                }
                this.getCategory().info((Object)("Added EventCartridge: " + object.getClass().getName() + " : " + bl));
            }
            catch (Exception exception) {
                throw new InitializationException("Could not initialize EventCartridge: " + string, exception);
            }
        }
    }

    private void initVelocity() throws InitializationException {
        String string;
        String string2 = this.getRealPath(this.getConfiguration().getString("runtime.log", null));
        if (string2 == null || string2.length() <= 0) {
            String string3 = "VelocityService runtime log file is misconfigured: '" + string2 + "' is not a valid log file";
            throw new Error(string3);
        }
        this.getConfiguration().setProperty("runtime.log", (Object)string2);
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.getConfiguration().getKeys();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.endsWith(RESOURCE_LOADER_PATH)) continue;
            vector.add(string);
        }
        Iterator iterator2 = ((AbstractList)vector).iterator();
        while (iterator2.hasNext()) {
            string = (String)iterator2.next();
            Vector vector2 = this.getConfiguration().getVector(string, null);
            if (vector2 == null) continue;
            Velocity.clearProperty((String)string);
            this.getConfiguration().clearProperty(string);
            Iterator iterator3 = ((AbstractList)vector2).iterator();
            while (iterator3.hasNext()) {
                string2 = (String)iterator3.next();
                if (string2.startsWith("jar:file")) {
                    String string4;
                    int n = string2.indexOf("!/");
                    if (n >= 0) {
                        string4 = string2.substring(n);
                        string2 = string2.substring(9, n);
                    } else {
                        string4 = "!/";
                        string2 = string2.substring(9);
                    }
                    string2 = "jar:file:" + this.getRealPath(string2) + string4;
                } else if (string2.startsWith(ABSOLUTE_PREFIX)) {
                    string2 = string2.substring(ABSOLUTE_PREFIX.length(), string2.length());
                } else if (!string2.startsWith(JAR_PREFIX)) {
                    string2 = this.getRealPath(string2);
                }
                this.getConfiguration().addProperty(string, (Object)string2);
            }
        }
        try {
            Velocity.setExtendedProperties((ExtendedProperties)ConfigurationConverter.getExtendedProperties((Configuration)this.getConfiguration()));
            Velocity.init();
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to set up TurbineVelocityService", exception);
        }
    }

    public boolean templateExists(String string) {
        return Velocity.templateExists((String)string);
    }
}

