/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.userlist;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.account.AccountResultData;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.orm.query.Where;
import com.aimluck.eip.userlist.utils.UserListUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class UserSelectData
extends ALAbstractSelectData<TurbineUser, TurbineUser> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)UserSelectData.class.getName());
    private String currentPost;
    private ALStringField searchWord;
    private int registeredUserNum = 0;
    private boolean adminFilter;
    private List<ALEipGroup> postList;
    private List<Object> list;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.searchWord = new ALStringField();
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"userposition");
        this.postList = ALEipUtils.getMyGroups((RunData)rundata);
        super.init(action, rundata, context);
    }

    protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<TurbineUser> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.registeredUserNum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"userlist", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<TurbineUser> getSelectQuery(RunData rundata, Context context) {
        String filter;
        ObjectId oid = new ObjectId("TurbineUser", "USER_ID", 3);
        Expression exp1 = ExpressionFactory.matchAllDbExp((Map)oid.getIdSnapshot(), (int)6);
        Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        SelectQuery query = Database.query(TurbineUser.class);
        query.setQualifier(exp1.andExp(exp2));
        this.adminFilter = rundata.getParameters().getBoolean("adminfiltered");
        if (this.adminFilter) {
            try {
                Group group = JetspeedSecurity.getGroup((String)"LoginUser");
                Role adminrole = JetspeedSecurity.getRole((String)"admin");
                List admins = Database.query(TurbineUserGroupRole.class).where(new Where[]{Operations.eq((String)"turbineRole", (Object)adminrole.getId()), Operations.eq((String)"turbineGroup", (Object)group.getId()), Operations.ne((String)"turbineUser", (Object)1)}).distinct(true).fetchList();
                ArrayList<Integer> admin_ids = new ArrayList<Integer>();
                admin_ids.add(1);
                for (TurbineUserGroupRole tugr : admins) {
                    admin_ids.add(tugr.getTurbineUser().getUserId());
                }
                query.andQualifier(ExpressionFactory.inDbExp((String)"USER_ID", admin_ids));
            }
            catch (Exception ex) {
                logger.error((Object)"userlist", (Throwable)ex);
            }
        }
        this.current_filter = filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        if (filter != null && !"".equals(filter)) {
            query.where(Operations.eq((String)"turbineUserGroupRole.turbineGroup.groupName", (Object)filter));
        }
        this.searchWord.setValue(UserListUtils.getKeyword(rundata, context));
        String searchWordValue = this.searchWord.getValue();
        if (searchWordValue != null && searchWordValue.length() > 0) {
            String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)searchWordValue));
            transWord = transWord.replace("\u3000", "").replace(" ", "");
            String[] transWords = transWord.split("");
            for (int i = 0; i < transWords.length; ++i) {
                Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + searchWordValue + "%"));
                Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + searchWordValue + "%"));
                Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + searchWordValue + "%"));
                Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + searchWordValue + "%"));
                Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + searchWordValue + "%"));
                Expression exp16 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + this.searchWord + "%"));
                Expression exp21 = ExpressionFactory.likeExp((String)"outTelephone", (Object)("%" + searchWordValue + "%"));
                Expression exp22 = ExpressionFactory.likeExp((String)"inTelephone", (Object)("%" + searchWordValue + "%"));
                Expression exp23 = ExpressionFactory.likeExp((String)"cellularPhone", (Object)("%" + searchWordValue + "%"));
                Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWords[i] + "%"));
                Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWords[i] + "%"));
                Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWords[i] + "%"));
                Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWords[i] + "%"));
                Expression exp35 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + transWords[i] + "%"));
                query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp21).orExp(exp22).orExp(exp23).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35));
                query.distinct();
            }
        }
        return query;
    }

    protected SelectQuery<TurbineUser> buildSelectQueryForFilter(SelectQuery<TurbineUser> query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        Map gMap = ALEipManager.getInstance().getPostMap();
        if (filter != null && filter.trim().length() != 0 && !gMap.containsKey(Integer.valueOf(filter))) {
            filter = null;
        }
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchDbExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    private String getPostName(int id) {
        if (ALEipManager.getInstance().getPostMap().containsKey(id)) {
            return ((ALEipPost)ALEipManager.getInstance().getPostMap().get(id)).getPostName().getValue();
        }
        return null;
    }

    private String getPositionName(int id) {
        if (ALEipManager.getInstance().getPositionMap().containsKey(id)) {
            return ((ALEipPosition)ALEipManager.getInstance().getPositionMap().get(id)).getPositionName().getValue();
        }
        return null;
    }

    protected TurbineUser selectDetail(RunData rundata, Context context) {
        String userid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (userid == null) {
            return null;
        }
        return (TurbineUser)Database.get(TurbineUser.class, (Object)Integer.parseInt(userid));
    }

    protected Object getResultData(TurbineUser record) {
        AccountResultData rd = new AccountResultData();
        rd.initField();
        this.setResultData(record, rd);
        return rd;
    }

    protected Object getResultDataDetail(TurbineUser record) {
        try {
            AccountResultData rd = new AccountResultData();
            rd.initField();
            this.setResultData(record, rd);
            rd.setIsAdmin(ALEipUtils.isAdmin((int)record.getUserId()));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"userlist", (Throwable)ex);
            return null;
        }
    }

    private void setResultData(TurbineUser model, AccountResultData data) {
        data.setUserId(model.getUserId().intValue());
        data.setUserName(model.getLoginName());
        data.setName(this.getAliasName(model.getFirstName(), model.getLastName()));
        data.setNameKana(this.getAliasName(model.getFirstNameKana(), model.getLastNameKana()));
        data.setEmail(model.getEmail());
        data.setOutTelephone(model.getOutTelephone());
        data.setInTelephone(model.getInTelephone());
        data.setCellularPhone(model.getCellularPhone());
        data.setCellularMail(model.getCellularMail());
        data.setPostNameList(ALEipUtils.getPostNameList((int)model.getUserId()));
        data.setPositionName(ALEipUtils.getPositionName((int)model.getPositionId()));
        data.setDisabled(model.getDisabled());
        data.setHasPhoto("T".equals(model.getHasPhoto()));
        data.setPhotoModified(model.getPhotoModified().getTime());
    }

    private String getAliasName(String firstName, String lastName) {
        return new StringBuffer().append(lastName).append(" ").append(firstName).toString();
    }

    public boolean doSelectList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            ResultList<TurbineUser> resultList = this.selectList(rundata, context);
            if (resultList != null) {
                if (resultList.getTotalCount() > 0) {
                    this.setPageParam(resultList.getTotalCount());
                }
                Map<Integer, Boolean> map = this.getAdminInfo(resultList);
                this.list = new ArrayList<Object>();
                for (TurbineUser model : resultList) {
                    Object object = this.getResultData(model);
                    this.setAdminInfo(object, map);
                    if (object == null) continue;
                    this.list.add(object);
                }
            }
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    private Map<Integer, Boolean> getAdminInfo(ResultList<TurbineUser> list) {
        if (list == null || list.isEmpty()) {
            return new HashMap<Integer, Boolean>();
        }
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        for (TurbineUser user : list) {
            userIds.add(user.getUserId());
        }
        Role adminrole = null;
        try {
            adminrole = JetspeedSecurity.getRole((String)"admin");
        }
        catch (JetspeedSecurityException e) {
            logger.error((Object)"[UserSelectData]", (Throwable)e);
            return new HashMap<Integer, Boolean>();
        }
        List roleList = Database.query(TurbineUserGroupRole.class).where(new Where[]{Operations.eq((String)"turbineRole", (Object)adminrole.getId()), Operations.in((String)"turbineUser", userIds)}).fetchList();
        if (roleList == null) {
            return new HashMap<Integer, Boolean>();
        }
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        for (TurbineUserGroupRole role : roleList) {
            map.put(role.getTurbineUser().getUserId(), Boolean.TRUE);
        }
        return map;
    }

    private void setAdminInfo(Object obj, Map<Integer, Boolean> map) {
        AccountResultData data;
        Boolean bool = map.get((int)(data = (AccountResultData)obj).getUserId().getValue());
        data.setIsAdmin(bool == null ? false : bool);
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("post", "POST_ID");
        map.putValue("login_name", "loginName");
        map.putValue("name_kana", "lastNameKana");
        map.putValue("userposition", "eipMUserPosition.position");
        return map;
    }

    public String getCurrentPost() {
        return this.currentPost;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public List<ALEipGroup> getPostList() {
        return this.postList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public int getRegisteredUserNum() {
        return this.registeredUserNum;
    }

    public int getRandomNum() {
        SecureRandom random = new SecureRandom();
        return random.nextInt() * 100;
    }

    public boolean isAdminFiltered() {
        return this.adminFilter;
    }

    public String getAclPortletFeature() {
        return "addressbook_address_inside";
    }
}

