/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoStateUpdateData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoStateUpdateData.class.getName());
    private ALNumberField state;
    private String aclPortletFeature;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTTodo todo;
        super.init(action, rundata, context);
        int login_user_id = ALEipUtils.getUserId((RunData)rundata);
        String todoId = rundata.getParameters().getString("entityid");
        String userId = rundata.getParameters().getString("user_id");
        this.aclPortletFeature = todoId == null || todoId.equals("new") ? (userId != null && !userId.equals(String.valueOf(login_user_id)) ? "todo_todo_other" : "todo_todo_self") : ((todo = ToDoUtils.getEipTTodo(rundata, context, true)) != null && todo.getTurbineUser().getUserId() != login_user_id ? "todo_todo_other" : "todo_todo_self");
    }

    public void initField() {
        this.state = new ALNumberField();
        this.state.setFieldName("\u9032\u6357");
    }

    protected void setValidator() {
        this.state.limitValue(0L, 100L);
        this.state.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        int value = (int)this.state.getValue();
        return value % 10 == 0 && this.state.validate(msgList);
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            this.doCheckAclPermission(rundata, context, 8);
            EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, false);
            if (todo == null) {
                return false;
            }
            todo.setState(Short.valueOf((short)this.state.getValue()));
            todo.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            try {
                ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
                memberList.add(ALEipUtils.getALEipUser((int)todo.getUserId()));
                int msgType = ALMailUtils.getSendDestType((int)25);
                if (msgType > 0) {
                    List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                    String subject = "[" + ALOrgUtilsService.getAlias() + "]ToDo";
                    String orgId = Database.getDomainName();
                    ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                    for (ALEipUserAddr destMember : destMemberList) {
                        ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                        message.setPcSubject(subject);
                        message.setCellularSubject(subject);
                        message.setPcBody(ToDoUtils.createMsgForPc(rundata, todo, memberList, false));
                        message.setCellularBody(ToDoUtils.createMsgForPc(rundata, todo, memberList, false));
                        messageList.add(message);
                    }
                    ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)25)));
                }
            }
            catch (Exception ex) {
                msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                logger.error((Object)"todo", (Throwable)ex);
                return false;
            }
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[ToDoStateUpdateData]", t);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public ALNumberField getState() {
        return this.state;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

