/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo.util;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.util.ALEipUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ToDoUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoUtils.class.getName());
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final String TARGET_KEYWORD = "keyword";
    private static final String RESET_KEYWORD_FLAG = "reset_keyword_params";
    private static final String RESET_TARGET_FLAG = "reset_target_params";
    private static final String RESET_FLAG = "reset_params";
    public static final int LIMIT_STATE_BEFORE = -1;
    public static final int LIMIT_STATE_TODAY = 0;
    public static final int LIMIT_STATE_AFTER = 1;
    public static final String TODO_PORTLET_NAME = "ToDo";

    public static EipTTodo getEipTTodo(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException {
        String todoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            if (todoid == null || Integer.valueOf(todoid) == null) {
                logger.debug((Object)"[Todo] Empty ID...");
                throw new ALPageNotFoundException();
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"TODO_ID", (Object)todoid);
            exp.andExp(ExpressionFactory.matchDbExp((String)"turbineUser.USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata)));
            List todoList = Database.query(EipTTodo.class, (Expression)exp).fetchList();
            if (todoList == null || todoList.size() == 0) {
                logger.debug((Object)"[Todo] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTTodo todo = (EipTTodo)todoList.get(0);
            if (uid != todo.getUserId() && "F".equals(todo.getPublicFlag())) {
                logger.debug((Object)"[Todo] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            return todo;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    public static EipTTodo getEipTPublicTodo(RunData rundata, Context context, boolean isJoin) {
        String todoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (todoid == null || Integer.valueOf(todoid) == null) {
                logger.debug((Object)"[Todo] Empty ID...");
                return null;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"TODO_ID", (Object)todoid);
            exp.andExp(ExpressionFactory.matchExp((String)"publicFlag", (Object)"T"));
            List todoList = Database.query(EipTTodo.class, (Expression)exp).fetchList();
            if (todoList == null || todoList.size() == 0) {
                logger.debug((Object)"[Todo] Not found ID...");
                return null;
            }
            return (EipTTodo)todoList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    public static EipTTodoCategory getEipTTodoCategory(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (categoryid == null || Integer.valueOf(categoryid) == null) {
            logger.debug((Object)"[Todo] Empty ID...");
            throw new ALPageNotFoundException();
        }
        try {
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)categoryid);
            List categoryList = Database.query(EipTTodoCategory.class, (Expression)exp1).fetchList();
            if (categoryList == null || categoryList.size() == 0) {
                logger.debug((Object)"[Todo] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTTodoCategory)categoryList.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTTodoCategory getEipTTodoCategory(Long category_id) {
        try {
            return (EipTTodoCategory)Database.get(EipTTodoCategory.class, (Object)category_id);
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    public static Date getEmptyDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        return cal.getTime();
    }

    public static boolean isEmptyDate(Date date) {
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) == 9999;
    }

    public static String getPriorityImage(int i) {
        String[] temp = new String[]{"priority_high.gif", "priority_middle_high.gif", "priority_middle.gif", "priority_middle_low.gif", "priority_low.gif"};
        String image = null;
        try {
            image = temp[i - 1];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static String getPriorityString(int i) {
        String[] temp = new String[]{"\u9ad8\u3044", "\u3084\u3084\u9ad8\u3044", "\u666e\u901a", "\u3084\u3084\u4f4e\u3044", "\u4f4e\u3044"};
        String string = null;
        try {
            string = temp[i - 1];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public static String getStateImage(int i) {
        String[] temp = new String[]{"state_000.gif", "state_010.gif", "state_020.gif", "state_030.gif", "state_040.gif", "state_050.gif", "state_060.gif", "state_070.gif", "state_080.gif", "state_090.gif", "state_100.gif"};
        String image = null;
        try {
            image = temp[i / 10];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static String getStateString(int i) {
        if (i == 0) {
            return "\u672a\u7740\u624b";
        }
        if (i == 100) {
            return "\u5b8c\u4e86";
        }
        return new StringBuffer().append(i).append("%").toString();
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = rundata.getParameters().getString(TARGET_USER_ID);
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID);
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
            target_user_id = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)idParam);
            target_user_id = idParam;
        }
        return target_user_id;
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static int getViewId(RunData rundata, Context context, int uid) throws ALDBErrorException, ALPageNotFoundException {
        EipTTodo record;
        int view_uid = -1;
        try {
            record = ToDoUtils.getEipTTodo(rundata, context, false);
        }
        catch (ALPageNotFoundException ex) {
            record = null;
        }
        view_uid = record != null ? record.getUserId() : (rundata.getParameters().containsKey((Object)"view_uid") ? Integer.parseInt(rundata.getParameters().getString("view_uid")) : uid);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_uid", (String)String.valueOf(view_uid));
        return view_uid;
    }

    public static boolean hasResetKeywordFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_KEYWORD_FLAG);
        return resetflag != null;
    }

    public static void resetKeyword(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static boolean hasResetTargetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_TARGET_FLAG);
        return resetflag != null;
    }

    public static void resetTarget(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(className).append("filter").toString());
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(className).append("filtertype").toString());
    }

    public static int getLimitState(Date endDate) {
        if (endDate == null) {
            return -1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date nowDate = calendar.getTime();
        calendar.setTime(endDate);
        Date endDate1 = calendar.getTime();
        if (calendar.get(1) == 9999 && calendar.get(2) == 11 && calendar.get(5) == 31) {
            return -1;
        }
        int result = nowDate.compareTo(endDate1);
        result = result < 0 ? -1 : (result == 0 ? 0 : 1);
        return result;
    }

    public static ArrayList<ToDoCategoryResultData> getCategoryList(RunData rundata) {
        ToDoCategoryResultData rd;
        ArrayList<ToDoCategoryResultData> categoryList = new ArrayList<ToDoCategoryResultData>();
        try {
            List categoryList2 = Database.query(EipTTodoCategory.class).orderAscending("categoryName").fetchList();
            for (EipTTodoCategory record : categoryList2) {
                ALEipUser user = ALEipUtils.getALEipUser((int)record.getUserId());
                if (user == null) continue;
                rd = new ToDoCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                StringBuffer title = new StringBuffer(record.getCategoryName());
                rd.setCategoryName(title.toString());
                categoryList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
        }
        EipTTodoCategory unCategorized = (EipTTodoCategory)Database.query(EipTTodoCategory.class).where(Operations.eq((String)"turbineUser", (Object)0)).fetchSingle();
        rd = new ToDoCategoryResultData();
        rd.initField();
        rd.setCategoryId(unCategorized.getCategoryId().intValue());
        rd.setCategoryName(unCategorized.getCategoryName());
        categoryList.add(rd);
        return categoryList;
    }

    public static void createToDoActivity(EipTTodo todo, String loginName, List<String> recipients, boolean isNew, int operationUserId) {
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)"Todo", (int)todo.getTodoId(), (float)1.0f);
        boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        String title = "ToDo\u300c" + todo.getTodoName() + (isNew ? "\u300d\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002" : "\u300d\u3092\u7de8\u96c6\u3057\u307e\u3057\u305f\u3002");
        String portletParams = "?template=ToDoDetailScreen" + "&entityid=" + todo.getTodoId();
        if (recipients != null && recipients.size() > 0) {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(TODO_PORTLET_NAME).withLoginName(loginName).withUserId(operationUserId).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(1.0f).withExternalId(String.valueOf(todo.getTodoId())));
        }
        if (todo.getPublicFlag().equals("T")) {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(TODO_PORTLET_NAME).withUserId(operationUserId).withLoginName(loginName).withPortletParams(portletParams).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(todo.getTodoId())));
        }
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static String createMsgForPc(RunData rundata, EipTTodo todo, List<ALEipUser> memberList, boolean isNew) throws ALDBErrorException {
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer("");
        body.append(loginUser.getAliasName().toString());
        if (!"".equals(user.getEmail())) {
            body.append("(").append(user.getEmail()).append(")");
        }
        if (isNew) {
            body.append("\u3055\u3093\u304cToDo\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002").append(CR).append(CR);
        } else {
            body.append("\u3055\u3093\u304cToDo\u3092\u7de8\u96c6\u3057\u307e\u3057\u305f\u3002").append(CR).append(CR);
        }
        body.append("[ToDo\u8a73\u7d30]").append(CR).append(todo.getTodoName().toString()).append(CR);
        body.append("[\u62c5\u5f53\u8005]").append(CR).append(ALEipUtils.getALEipUser((int)todo.getTurbineUser().getUserId()).getAliasName()).append(CR);
        if (!ToDoUtils.isEmptyDate(todo.getStartDate())) {
            body.append("[\u958b\u59cb\u65e5] ").append(CR).append(ALDateUtil.format((Date)todo.getStartDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)")).append(CR);
        }
        if (!ToDoUtils.isEmptyDate(todo.getEndDate())) {
            body.append("[\u7de0\u5207\u65e5] ").append(CR).append(ALDateUtil.format((Date)todo.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)")).append(CR);
        }
        body.append("[\u9032\u6357]").append(CR).append(todo.getState().toString()).append("%").append(CR);
        body.append("[\u512a\u5148\u5ea6]").append(CR).append(ToDoUtils.getPriorityString(todo.getPriority().shortValue())).append(CR);
        if (todo.getNote().toString().length() > 0) {
            body.append("[\u30e1\u30e2]").append(CR).append(todo.getNote().toString()).append(CR);
        }
        body.append(CR);
        body.append("[").append(ALOrgUtilsService.getAlias()).append("\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        if (enableAsp) {
            body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        } else {
            body.append("\u30fb\u793e\u5916").append(CR);
            body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
            body.append("\u30fb\u793e\u5185").append(CR);
            body.append("\u3000").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
        }
        body.append("---------------------").append(CR);
        body.append(ALOrgUtilsService.getAlias()).append(CR);
        return body.toString();
    }

    public static String createMsgForPcTmpl(RunData rundata, EipTTodo todo, List<ALEipUser> memberList, boolean isNew) throws ALDBErrorException {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        context.put("loginUser", (Object)loginUser.getAliasName().toString());
        context.put("hasEmail", (Object)(!user.getEmail().equals("") ? 1 : 0));
        context.put("email", (Object)user.getEmail());
        context.put("isNew", (Object)isNew);
        context.put("todoName", (Object)todo.getTodoName().toString());
        context.put("turbineUser", (Object)ALEipUtils.getALEipUser((int)todo.getTurbineUser().getUserId()).getAliasName());
        context.put("hasStartDate", (Object)(!ToDoUtils.isEmptyDate(todo.getStartDate()) ? 1 : 0));
        context.put("startDate", (Object)ALDateUtil.format((Date)todo.getStartDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
        context.put("hasEndDate", (Object)(!ToDoUtils.isEmptyDate(todo.getEndDate()) ? 1 : 0));
        context.put("endDate", (Object)ALDateUtil.format((Date)todo.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
        context.put("state", (Object)todo.getState().toString());
        context.put("priority", (Object)todo.getPriority());
        context.put("hasNote", (Object)(todo.getNote().toString().length() > 0 ? 1 : 0));
        context.put("note", (Object)todo.getNote().toString());
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/todo-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/todo-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static String passPSML(RunData rundata, Context context, String key, String value) {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        PortletConfig config = portlet.getPortletConfig();
        if (value == null || "".equals(value)) {
            value = config != null ? config.getInitParameter(key) : "";
        } else {
            ALEipUtils.setPsmlParameters((RunData)rundata, (Context)context, (String)key, (String)value);
        }
        return value;
    }
}

