/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timeline;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineFile;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineUrl;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.timeline.TimelineLikeResultData;
import com.aimluck.eip.timeline.TimelineLikeSelectData;
import com.aimluck.eip.timeline.TimelineResultData;
import com.aimluck.eip.timeline.TimelineUrlResultData;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimelineSelectData
extends ALAbstractSelectData<EipTTimeline, EipTTimeline>
implements ALData {
    private final String TARGET_GROUP_NAME = "target_group_name";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimelineSelectData.class.getName());
    private int topicSum;
    private int contentHeight;
    private int contentHeightMax;
    private int scrollTop;
    private int uid;
    private ALBaseUser baseuser;
    private ALEipUser user;
    private final boolean showReplyForm = false;
    private boolean hasAclUpdateTopicOthers;
    private boolean hasAclDeleteTopicOthers;
    private ALStringField target_keyword;
    private List<Object> list;
    private final List<Integer> users = new ArrayList<Integer>();
    private List<ALEipUser> userList = null;
    private String userid;
    private final List<Integer> useridList = new ArrayList<Integer>();
    protected String target_group_name;
    private List<ALEipGroup> myGroupList = null;
    private boolean isAdmin = false;
    private boolean isFileUploadable;
    private HashMap<String, String> portletIdFromAppId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.portletIdFromAppId = ALEipUtils.getPortletFromAppIdMap((RunData)rundata);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"update_date");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.baseuser = (ALBaseUser)rundata.getUser();
        this.user = ALEipUtils.getALEipUser((int)this.uid);
        this.isAdmin = ALEipUtils.isAdmin((int)this.uid);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList<ALEipGroup>();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add((ALEipGroup)myGroups.get(i));
        }
        this.isFileUploadable = ALEipUtils.isFileUploadable((RunData)rundata);
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public ResultList<EipTTimeline> selectList(RunData rundata, Context context) {
        try {
            this.setupLists(rundata, context);
            ResultList<EipTTimeline> list = new ResultList<EipTTimeline>();
            if (this.useridList != null && this.useridList.size() > 0) {
                list = TimelineUtils.getTimelineList(this.uid, Arrays.asList(0), null, this.current_page, this.getRowsNum(), 0, this.useridList);
            }
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"timeline", (Throwable)ex);
            return null;
        }
    }

    public ResultList<EipTTimeline> selectListNew(RunData rundata, Context context) {
        try {
            int minId = Integer.valueOf(ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"lastTimelineId"));
            ResultList<EipTTimeline> list = TimelineUtils.getTimelineList(this.uid, Arrays.asList(0), null, 0, 0, minId, this.useridList);
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"timeline", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<EipTTimeline> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTTimeline.class);
        query.where(Operations.eq((String)"parentId", (Object)0));
        return query;
    }

    protected Object getResultData(EipTTimeline record) {
        try {
            TimelineResultData rd = new TimelineResultData();
            rd.initField();
            rd.setTimelineId(record.getTimelineId().longValue());
            rd.setNote(record.getNote());
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            rd.setTimelineType(record.getTimelineType());
            rd.setAppId(record.getAppId());
            rd.setParams(record.getParams());
            rd.setLike(record.isLike());
            rd.setLikeCount(record.getLikeCount());
            String AppId = record.getAppId();
            if ("todo".equals(AppId)) {
                AppId = "ToDo";
            }
            if ("blog".equals(AppId)) {
                AppId = "Blog";
            }
            rd.setPortletId(this.portletIdFromAppId.get(AppId));
            if (!this.users.contains(record.getOwnerId())) {
                this.users.add(record.getOwnerId());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"timeline", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipTTimeline record) throws ALPageNotFoundException, ALDBErrorException {
        TimelineResultData rd = (TimelineResultData)this.getResultData(record);
        Integer id = record.getTimelineId();
        TimelineLikeSelectData ls = new TimelineLikeSelectData();
        List<TimelineLikeResultData> likeList = ls.getLikeList(record.getTimelineId());
        rd.setLikeList(likeList);
        rd.setLikeCount(likeList.size());
        for (TimelineLikeResultData lrd : likeList) {
            int value = (int)lrd.getUserId().getValue();
            if (value != this.uid) continue;
            rd.setLike(true);
            break;
        }
        Map<Integer, List<TimelineResultData>> activitiesMap = this.getActivities(Arrays.asList(id));
        Map<Integer, List<TimelineResultData>> commentsMap = this.getComments(Arrays.asList(id));
        Map<Integer, List<TimelineUrlResultData>> urlsMap = this.getUrls(Arrays.asList(id));
        Map<Integer, List<FileuploadBean>> filesMap = this.getFiles(Arrays.asList(id));
        rd.setCoTopicList(commentsMap.get(id));
        rd.setCoActivityList(activitiesMap.get(id));
        rd.setUrlList(urlsMap.get(id));
        rd.setAttachmentFileList(filesMap.get(id));
        rd.setReplyCount(rd.getCoTopicList().size());
        rd.setParentId(record.getParentId().longValue());
        rd.setTimelineType(record.getTimelineType());
        this.loadAggregateUsers();
        return rd;
    }

    public EipTTimeline selectDetail(RunData rundata, Context context) throws ALDBErrorException, ALPageNotFoundException {
        EipTTimeline timeline = TimelineUtils.getEipTTimelineParentEntry(rundata, context);
        return timeline;
    }

    protected Map<Integer, List<TimelineResultData>> getComments(List<Integer> parentIds) {
        ResultList<EipTTimeline> list = TimelineUtils.getTimelineList(this.uid, parentIds, "T", -1, -1, 0, null);
        HashMap<Integer, List<TimelineResultData>> result = new HashMap<Integer, List<TimelineResultData>>(parentIds.size());
        for (EipTTimeline model : list) {
            Integer id = model.getParentId();
            ArrayList<TimelineResultData> rdList = (ArrayList<TimelineResultData>)result.get(id);
            if (rdList == null) {
                rdList = new ArrayList<TimelineResultData>();
            }
            rdList.add((TimelineResultData)this.getResultData(model));
            result.put(id, rdList);
        }
        return result;
    }

    protected Map<Integer, List<TimelineResultData>> getActivities(List<Integer> parentIds) {
        ResultList<EipTTimeline> list = TimelineUtils.getTimelineList(this.uid, parentIds, "A", -1, -1, 0, this.useridList);
        HashMap<Integer, List<TimelineResultData>> result = new HashMap<Integer, List<TimelineResultData>>(parentIds.size());
        for (EipTTimeline model : list) {
            Integer id = model.getParentId();
            ArrayList<TimelineResultData> rdList = (ArrayList<TimelineResultData>)result.get(id);
            if (rdList == null) {
                rdList = new ArrayList<TimelineResultData>();
            }
            rdList.add((TimelineResultData)this.getResultData(model));
            result.put(id, rdList);
        }
        return result;
    }

    protected Map<Integer, List<TimelineUrlResultData>> getUrls(List<Integer> parentIds) {
        if (parentIds == null || parentIds.size() == 0) {
            return new HashMap<Integer, List<TimelineUrlResultData>>();
        }
        SelectQuery query = Database.query(EipTTimelineUrl.class);
        query.where(Operations.in((String)"timelineId", parentIds));
        List list = query.fetchList();
        HashMap<Integer, List<TimelineUrlResultData>> result = new HashMap<Integer, List<TimelineUrlResultData>>(parentIds.size());
        for (EipTTimelineUrl model : list) {
            Integer id = model.getTimelineId();
            ArrayList<TimelineUrlResultData> rdList = (ArrayList<TimelineUrlResultData>)result.get(id);
            if (rdList == null) {
                rdList = new ArrayList<TimelineUrlResultData>();
            }
            TimelineUrlResultData rd = new TimelineUrlResultData();
            rd.initField();
            rd.setTimelineUrlId(model.getTimelineUrlId().longValue());
            rd.setTimelineId(model.getTimelineId().longValue());
            rd.setThumbnail(model.getThumbnail());
            rd.setTitle(model.getTitle());
            rd.setUrl(model.getUrl());
            rd.setBody(model.getBody());
            boolean flag = false;
            if (model.getThumbnail() != null) {
                flag = true;
            }
            rd.setThumbnailFlag(flag);
            String url = model.getUrl();
            if (TimelineUtils.isYoutubeUrl(url)) {
                rd.setYoutubeId(TimelineUtils.getYoutubeId(url));
                rd.setYoutubeFlag(true);
            }
            rdList.add(rd);
            result.put(id, rdList);
        }
        return result;
    }

    protected Map<Integer, List<FileuploadBean>> getFiles(List<Integer> parentIds) {
        if (parentIds == null || parentIds.size() == 0) {
            return new HashMap<Integer, List<FileuploadBean>>();
        }
        SelectQuery query = Database.query(EipTTimelineFile.class);
        query.where(Operations.in((String)"timelineId", parentIds));
        query.orderAscending("updateDate");
        query.orderAscending("filePath");
        List list = query.fetchList();
        HashMap<Integer, List<FileuploadBean>> result = new HashMap<Integer, List<FileuploadBean>>(parentIds.size());
        for (EipTTimelineFile model : list) {
            Integer id = model.getTimelineId();
            ArrayList<FileuploadBean> rdList = (ArrayList<FileuploadBean>)result.get(id);
            if (rdList == null) {
                rdList = new ArrayList<FileuploadBean>();
            }
            String realname = model.getFileName();
            DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
            FileuploadBean filebean = new FileuploadBean();
            filebean.setFileId(model.getFileId().intValue());
            filebean.setFileName(realname);
            if (hData != null) {
                filebean.setContentType(hData.getContentType());
            }
            filebean.setIsImage(FileuploadUtils.isImage((String)realname));
            rdList.add(filebean);
            result.put(id, rdList);
        }
        return result;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            action.setMode("list");
            ResultList<EipTTimeline> resultList = this.selectList(rundata, context);
            if (resultList == null) {
                return false;
            }
            ArrayList<Integer> parentIds = new ArrayList<Integer>(resultList.size());
            for (EipTTimeline model : resultList) {
                parentIds.add(model.getTimelineId());
            }
            Map<Integer, List<TimelineResultData>> activitiesMap = this.getActivities(parentIds);
            ArrayList<Integer> commentIds = new ArrayList<Integer>();
            commentIds.addAll(parentIds);
            for (List<TimelineResultData> next : activitiesMap.values()) {
                for (TimelineResultData rd : next) {
                    commentIds.add((int)rd.getTimelineId().getValue());
                }
            }
            Map<Integer, List<TimelineResultData>> commentsMap = this.getComments(commentIds);
            Map<Integer, List<TimelineUrlResultData>> urlsMap = this.getUrls(parentIds);
            Map<Integer, List<FileuploadBean>> filesMap = this.getFiles(parentIds);
            if (resultList.getTotalCount() > 0) {
                this.setPageParam(resultList.getTotalCount());
            }
            this.list = new ArrayList<Object>();
            for (EipTTimeline model : resultList) {
                Object object = this.getResultData(model);
                TimelineResultData rd = (TimelineResultData)object;
                rd.setCoTopicList(commentsMap.get(model.getTimelineId()));
                rd.setCoActivityList(activitiesMap.get(model.getTimelineId()));
                rd.setUrlList(urlsMap.get(model.getTimelineId()));
                rd.setAttachmentFileList(filesMap.get(model.getTimelineId()));
                rd.setReplyCount(rd.getCoTopicList().size());
                List<TimelineResultData> coac = rd.getCoActivityList();
                Iterator<TimelineResultData> iter = coac.iterator();
                while (iter.hasNext()) {
                    TimelineResultData coac_item = iter.next();
                    coac_item.setCoTopicList(commentsMap.get((int)coac_item.getTimelineId().getValue()));
                    coac_item.setReplyCount(coac_item.getCoTopicList().size());
                    SelectQuery query_map = Database.query(EipTTimelineMap.class);
                    Expression exp1 = ExpressionFactory.matchExp((String)"eipTTimeline", (Object)coac_item.getTimelineId().getValue());
                    query_map.setQualifier(exp1);
                    List data_map = query_map.fetchList();
                    ArrayList<String> userlist = new ArrayList<String>();
                    for (int j = 0; j < data_map.size(); ++j) {
                        userlist.add(((EipTTimelineMap)data_map.get(j)).getLoginName());
                    }
                    if (this.user.getUserId().toString().equals(coac_item.getOwnerId().toString()) || userlist.contains(this.user.getName().toString()) || userlist.contains("-1")) continue;
                    iter.remove();
                }
                if (rd.getCoActivityList().size() == 0 && rd.getCoTopicList().size() == 0 && rd.getNote().equals("")) continue;
                this.list.add(rd);
            }
            this.loadAggregateUsers();
            action.setResultData((Object)this);
            action.putData(rundata, context);
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doViewListNew(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 1);
            action.setMode("list");
            ResultList<EipTTimeline> resultList = this.selectListNew(rundata, context);
            if (resultList == null) {
                return false;
            }
            ArrayList<Integer> parentIds = new ArrayList<Integer>(resultList.size());
            for (EipTTimeline model : resultList) {
                parentIds.add(model.getTimelineId());
            }
            Map<Integer, List<TimelineResultData>> activitiesMap = this.getActivities(parentIds);
            ArrayList<Integer> commentIds = new ArrayList<Integer>();
            commentIds.addAll(parentIds);
            for (List<TimelineResultData> next : activitiesMap.values()) {
                for (TimelineResultData rd : next) {
                    commentIds.add((int)rd.getTimelineId().getValue());
                }
            }
            Map<Integer, List<TimelineResultData>> commentsMap = this.getComments(commentIds);
            Map<Integer, List<TimelineUrlResultData>> urlsMap = this.getUrls(parentIds);
            Map<Integer, List<FileuploadBean>> filesMap = this.getFiles(parentIds);
            if (resultList.getTotalCount() > 0) {
                this.setPageParam(resultList.getTotalCount());
            }
            this.list = new ArrayList<Object>();
            for (EipTTimeline model : resultList) {
                Object object = this.getResultData(model);
                TimelineResultData rd = (TimelineResultData)object;
                rd.setCoTopicList(commentsMap.get(model.getTimelineId()));
                rd.setCoActivityList(activitiesMap.get(model.getTimelineId()));
                rd.setUrlList(urlsMap.get(model.getTimelineId()));
                rd.setAttachmentFileList(filesMap.get(model.getTimelineId()));
                rd.setReplyCount(rd.getCoTopicList().size());
                List<TimelineResultData> coac = rd.getCoActivityList();
                Iterator<TimelineResultData> iter = coac.iterator();
                while (iter.hasNext()) {
                    TimelineResultData coac_item = iter.next();
                    coac_item.setCoTopicList(commentsMap.get((int)coac_item.getTimelineId().getValue()));
                    coac_item.setReplyCount(coac_item.getCoTopicList().size());
                    SelectQuery query_map = Database.query(EipTTimelineMap.class);
                    Expression exp1 = ExpressionFactory.matchExp((String)"eipTTimeline", (Object)coac_item.getTimelineId().getValue());
                    query_map.setQualifier(exp1);
                    List data_map = query_map.fetchList();
                    ArrayList<String> userlist = new ArrayList<String>();
                    for (int j = 0; j < data_map.size(); ++j) {
                        userlist.add(((EipTTimelineMap)data_map.get(j)).getLoginName());
                    }
                    if (this.user.getUserId().toString().equals(coac_item.getOwnerId().toString()) || userlist.contains(this.user.getName().toString()) || userlist.contains("-1")) continue;
                    iter.remove();
                }
                if (rd.getCoActivityList().size() == 0 && rd.getCoTopicList().size() == 0 && rd.getNote().equals("")) continue;
                this.list.add(rd);
            }
            this.loadAggregateUsers();
            action.setResultData((Object)this);
            action.putData(rundata, context);
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
            return this.list != null;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public int getTopicSum() {
        return this.topicSum;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getContentHeightMax() {
        return this.contentHeightMax;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("update_date", "updateDate");
        map.putValue("owner_name", "ownerId");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean showReplyForm() {
        return false;
    }

    public boolean hasAclUpdateTopicOthers() {
        return this.hasAclUpdateTopicOthers;
    }

    public boolean hasAclDeleteTopicOthers() {
        return this.hasAclDeleteTopicOthers;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public String getCurrentSearchWithSanitize() {
        return ALStringUtil.sanitizing((String)this.getCurrentSearch());
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public int getScrollTop() {
        return this.scrollTop;
    }

    public void setScrollTop(int scrollTop) {
        this.scrollTop = scrollTop;
    }

    public boolean hasMyPhoto() {
        if (this.baseuser == null) {
            return false;
        }
        return this.baseuser.getPhoto() != null;
    }

    public ALEipUser getMyUser() {
        return this.user;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public List<Object> getList() {
        return this.list;
    }

    protected void loadAggregateUsers() {
        ALEipManager.getInstance().getUsers(this.users);
    }

    protected void setupLists(RunData rundata, Context context) {
        this.current_filter = this.target_group_name = this.getTargetGroupName(rundata, context);
        if (!this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            boolean existPost = false;
            for (int i = 0; i < this.myGroupList.size(); ++i) {
                String pid = this.myGroupList.get(i).getName().toString();
                if (!pid.equals(this.target_group_name)) continue;
                existPost = true;
                break;
            }
            Map map = ALEipManager.getInstance().getPostMap();
            for (Map.Entry item : map.entrySet()) {
                String pid = ((ALEipPost)item.getValue()).getGroupName().toString();
                if (!pid.equals(this.target_group_name)) continue;
                existPost = true;
                break;
            }
            if (existPost) {
                this.userList = ALEipUtils.getUsers((String)this.target_group_name);
            } else {
                this.target_group_name = "all";
                this.userList = ALEipUtils.getUsers((String)"LoginUser");
            }
        } else {
            this.userList = ALEipUtils.getUsers((String)"LoginUser");
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            this.useridList.add((int)this.userList.get(i).getUserId().getValue());
        }
        this.useridList.add(2);
    }

    protected String getTargetGroupName(RunData rundata, Context context) {
        return this.getTargetGroupName(rundata, context, "target_group_name");
    }

    protected String getTargetGroupName(RunData rundata, Context context, String target_key) {
        String target_group_name = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString(target_key);
        }
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)target_key);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)target_key, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public boolean isFileUploadable() {
        return this.isFileUploadable;
    }

    public void setContentHeightMax(int height) {
        this.contentHeight = height;
        this.contentHeightMax = height;
    }
}

