/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timeline.util;

import com.aimluck.commons.utils.ALDeleteFileUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineFile;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineLike;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineUrl;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.services.timeline.ALTimelineFactoryService;
import com.aimluck.eip.services.timeline.ALTimelineHandler;
import com.aimluck.eip.timeline.TimelineUrlBeans;
import com.aimluck.eip.timeline.TimelineUserResultData;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALURLConnectionUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TimelineUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimelineUtils.class.getName());
    public static final String OWNER_ID = "ownerid";
    public static final String FOLDER_FILEDIR_TIMELIME = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.timeline.categorykey", (String)"");
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final int ACCESS_PUBLIC_ALL = 0;
    public static final int ACCESS_PUBLIC_MEMBER = 1;
    public static final int ACCESS_SEACRET_MEMBER = 2;
    public static final int ACCESS_SEACRET_SELF = 3;
    public static final String PUBLIC_FLG_VALUE_PUBLIC = "T";
    public static final String PUBLIC_FLG_VALUE_NONPUBLIC = "F";
    public static final String STAT_VALUE_OWNER = "O";
    public static final String STAT_VALUE_SHARE = "S";
    public static final String STAT_VALUE_ALL = "A";
    public static final String TIMELIME_PORTLET_NAME = "Timeline";
    public static final String TARGET_KEYWORD = "keyword";

    @Deprecated
    public static Integer countReply(Integer timeline_id) {
        SelectQuery query = Database.query(EipTTimeline.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)timeline_id);
        Expression exp2 = ExpressionFactory.matchExp((String)"timelineType", (Object)PUBLIC_FLG_VALUE_PUBLIC);
        query.setQualifier(exp1.andExp(exp2));
        return query.getCount();
    }

    public static List<EipTTimeline> getEipTTimelineListToDeleteAllUserTopic(RunData rundata, Context context, boolean isSuperUser, int topicid) throws ALPageNotFoundException, ALDBErrorException {
        try {
            SelectQuery query = Database.query(EipTTimeline.class);
            Expression exp02 = ExpressionFactory.matchDbExp((String)"TIMELINE_ID", (Object)topicid);
            Expression exp03 = ExpressionFactory.matchExp((String)"parentId", (Object)topicid);
            query.andQualifier(exp02.orExp(exp03));
            List topics = query.fetchList();
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[Timeline] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[TimelineUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTTimeline> getEipTTimelineListToDeleteTopic(RunData rundata, Context context, boolean isSuperUser, int topicid) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List topics;
            int userid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTTimeline.class);
            Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)userid);
            Expression exp02 = ExpressionFactory.matchDbExp((String)"TIMELINE_ID", (Object)topicid);
            Expression exp03 = ExpressionFactory.matchExp((String)"parentId", (Object)topicid);
            String del_member_value = null;
            if (rundata.getParameters().containsKey((Object)"del_member_flag")) {
                del_member_value = rundata.getParameters().getString("del_member_flag");
            }
            if (del_member_value != null) {
                if (del_member_value.equals("0") || del_member_value.equals("1")) {
                    query.andQualifier(exp02.orExp(exp03));
                }
            } else if (isSuperUser) {
                query.andQualifier(exp02.orExp(exp03));
            } else {
                query.andQualifier(exp01.andExp(exp02).orExp(exp03));
            }
            if ((topics = query.fetchList()) == null || topics.size() == 0) {
                logger.debug((Object)"[Timeline] Not found ID...");
                throw new ALPageNotFoundException();
            }
            boolean isdelete = false;
            int size = topics.size();
            for (int i = 0; i < size; ++i) {
                EipTTimeline topic = (EipTTimeline)topics.get(i);
                if (del_member_value != null) {
                    if (!del_member_value.equals("0") && !del_member_value.equals("1")) continue;
                    isdelete = true;
                    break;
                }
                if (topic.getOwnerId() != userid && !isSuperUser) continue;
                isdelete = true;
                break;
            }
            if (!isdelete) {
                logger.debug((Object)"[Timeline] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[TimelineUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTTimelineLike> getEipTTimelineLikeListToDeleteTopic(RunData rundata, Context context, boolean isSuperUser) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[Timeline] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery query = Database.query(EipTTimelineLike.class);
            Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)userid);
            Expression exp02 = ExpressionFactory.matchDbExp((String)"TIMELINE_ID", (Object)Integer.valueOf(topicid));
            if (isSuperUser) {
                query.andQualifier(exp02);
            } else {
                query.andQualifier(exp01.andExp(exp02));
            }
            List topics = query.fetchList();
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[Timeline] Not found ID...");
                throw new ALPageNotFoundException();
            }
            boolean isdelete = false;
            int size = topics.size();
            for (int i = 0; i < size; ++i) {
                EipTTimelineLike topic = (EipTTimelineLike)topics.get(i);
                if (topic.getOwnerId() != userid && !isSuperUser) continue;
                isdelete = true;
                break;
            }
            if (!isdelete) {
                logger.debug((Object)"[Timeline] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[TimelineUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<TimelineUserResultData> getTimelineUserResultDataList(String groupname) {
        ArrayList<TimelineUserResultData> list = new ArrayList<TimelineUserResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.HAS_PHOTO, B.PHOTO_MODIFIED, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        try {
            List ulist = Database.sql(TurbineUser.class, (String)query).param("groupname", (Object)groupname).fetchListAsDataRow();
            int recNum = ulist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)ulist.get(j);
                TimelineUserResultData user = new TimelineUserResultData();
                user.initField();
                user.setUserId((Integer)Database.getFromDataRow((DataRow)dataRow, (Object)"USER_ID"));
                user.setName((String)Database.getFromDataRow((DataRow)dataRow, (Object)"LOGIN_NAME"));
                user.setAliasName((String)Database.getFromDataRow((DataRow)dataRow, (Object)"FIRST_NAME"), (String)Database.getFromDataRow((DataRow)dataRow, (Object)"LAST_NAME"));
                user.setHasPhoto(PUBLIC_FLG_VALUE_PUBLIC.equals(Database.getFromDataRow((DataRow)dataRow, (Object)"HAS_PHOTO")));
                Object photoModified = Database.getFromDataRow((DataRow)dataRow, (Object)"PHOTO_MODIFIED");
                Date date = new Date();
                try {
                    date = (Date)photoModified;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                user.setPhotoModified(date.getTime());
                list.add(user);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[timelineUtils]", (Throwable)ex);
        }
        return list;
    }

    public static List<Integer> getTimelineOtherCommentUserList(int parent_id) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        try {
            String query = "SELECT DISTINCT OWNER_ID FROM eip_t_timeline WHERE PARENT_ID = #bind($parent_id)";
            List list = Database.sql(EipTTimeline.class, (String)query).param("parent_id", (Object)parent_id).fetchList();
            int recordNum = list.size();
            for (int i = 0; i < recordNum; ++i) {
                Integer ownerId = ((EipTTimeline)list.get(i)).getOwnerId();
                resultList.add(ownerId);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[timelineUtils]", (Throwable)ex);
        }
        return resultList;
    }

    public static void createNewCommentActivity(EipTTimeline timeline, String loginName, String targetLoginName) {
        if (loginName.equals(targetLoginName)) {
            return;
        }
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(targetLoginName);
        String title = "\u3042\u306a\u305f\u306e\u6295\u7a3f\u306b\u30b3\u30e1\u30f3\u30c8\u3057\u307e\u3057\u305f\u3002";
        String portletParams = "?template=TimelineDetailScreen" + "&entityid=" + timeline.getTimelineId();
        ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId("timeline").withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(1.0f).withExternalId(String.valueOf(timeline.getTimelineId())));
    }

    public static void createNewOtherCommentActivity(EipTTimeline timeline, String loginName, String otherLoginName, String targetUserName) {
        if (loginName.equals(otherLoginName)) {
            return;
        }
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(otherLoginName);
        String title = targetUserName + "\u3055\u3093\u306e\u6295\u7a3f\u306b\u30b3\u30e1\u30f3\u30c8\u3057\u307e\u3057\u305f\u3002";
        String portletParams = "?template=TimelineDetailScreen" + "&entityid=" + timeline.getTimelineId();
        ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId("timeline").withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(1.0f).withExternalId(String.valueOf(timeline.getTimelineId())));
    }

    public static void createNewLikeActivity(EipTTimeline timeline, String loginName, String targetLoginName) {
        if (loginName.equals(targetLoginName)) {
            return;
        }
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(targetLoginName);
        String title = "\u3042\u306a\u305f\u306e\u6295\u7a3f\u306b\u300c\u3044\u3044\u306d\uff01\u300d\u304c\u62bc\u3055\u308c\u307e\u3057\u305f\u3002";
        String portletParams = "?template=TimelineDetailScreen" + "&entityid=" + timeline.getTimelineId();
        ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId("timeline").withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(1.0f).withExternalId(String.valueOf(timeline.getTimelineId())));
    }

    public static EipTTimeline getEipTTimelineParentEntry(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String entryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (entryid == null || Integer.valueOf(entryid) == null) {
                logger.debug((Object)"[TimelineUtil] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTTimeline.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"TIMELINE_ID", (Object)Integer.valueOf(entryid));
            query.setQualifier(exp);
            List entrys = query.fetchList();
            if (entrys == null || entrys.size() == 0) {
                logger.debug((Object)"[TimelineUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTTimeline entry = (EipTTimeline)entrys.get(0);
            return entry;
        }
        catch (ALPageNotFoundException ex) {
            logger.debug((Object)"[TimelineUtils] Not found ID...");
            throw new ALDBErrorException();
        }
        catch (Exception ex) {
            logger.error((Object)"[EntryUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileuploadLiteBean> getFileuploadList(RunData rundata) {
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        int fileid = 0;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            int length = newfileids.size();
            for (int i = 0; i < length; ++i) {
                if (newfileids.get(i) == null || ((String)newfileids.get(i)).equals("")) continue;
                try {
                    fileid = Integer.parseInt((String)newfileids.get(i));
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getTmpFile((int)ALEipUtils.getUserId((RunData)rundata), (String)folderName, (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(fileids[i]);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"timeline", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"timeline", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (int k = 0; k < hadfileids.size(); ++k) {
                try {
                    fileid = Integer.parseInt((String)hadfileids.get(k));
                    hadfileidsValue.add(fileid);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                SelectQuery reqquery = Database.query(EipTTimelineFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                int requestssize = requests.size();
                for (int i = 0; i < requestssize; ++i) {
                    EipTTimelineFile file = (EipTTimelineFile)requests.get(i);
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[BlogUtils] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static EipTTimelineFile getEipTTimelineFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[TimelineUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTTimelineFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[TimelineUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTTimelineFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[TimelineUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTTimelineUrl getEipTTimelineUrl(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[TimelineUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTTimelineUrl.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"URL_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List urls = query.fetchList();
            if (urls == null || urls.size() == 0) {
                logger.debug((Object)"[TimelineUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTTimelineUrl)urls.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[TimelineUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_TIMELIME, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    @Deprecated
    public static SelectQuery<EipTTimelineFile> getSelectQueryForFiles(int requestid) {
        SelectQuery query = Database.query(EipTTimelineFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"TIMELINE_ID", (Object)requestid);
        query.setQualifier(exp);
        return query;
    }

    public static void deleteFiles(int timelineId, String orgId, int uid, List<String> fpaths) throws ALFileNotRemovedException {
        ALDeleteFileUtil.deleteFiles((int)timelineId, (String)"eipTTimeline", (String)TimelineUtils.getSaveDirPath(orgId, uid), fpaths, EipTTimelineFile.class);
    }

    public static void deleteLikes(int timelineId) {
        SelectQuery query = Database.query(EipTTimelineLike.class);
        query.andQualifier(ExpressionFactory.matchDbExp((String)"eipTTimeline", (Object)timelineId));
        List likes = query.fetchList();
        Database.deleteAll((List)likes);
        Database.commit();
    }

    public static Document getDocument(String string) {
        return TimelineUtils.getDocument(string, "JISAutoDetect");
    }

    public static Document getDocument(String string, String defaultCharset) {
        DOMParser parser = new DOMParser();
        try {
            String metaTagCharset;
            URL url = new URL(string);
            HttpURLConnection con = ALURLConnectionUtils.openUrlConnection((URL)url);
            con.setConnectTimeout(10000);
            con.setUseCaches(false);
            con.addRequestProperty("_", UUID.randomUUID().toString());
            con.addRequestProperty("User-Agent", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; Avant Browser)");
            con.addRequestProperty("Accept-Encoding", "identity");
            String contentType = con.getContentType();
            if (contentType == null) {
                return null;
            }
            String charsetSearch = contentType.replaceFirst("(?i).*charset=(.*)", "$1");
            String contentTypeCharset = con.getContentEncoding();
            BufferedReader reader = null;
            if (!contentType.equals(charsetSearch)) {
                contentTypeCharset = charsetSearch;
            }
            reader = contentTypeCharset == null ? new BufferedReader(new InputStreamReader(con.getInputStream(), defaultCharset)) : new BufferedReader(new InputStreamReader(con.getInputStream(), contentTypeCharset));
            InputSource source = new InputSource(reader);
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.parse(source);
            Document document = parser.getDocument();
            if (document == null) {
                logger.error((Object)"[TimelineUtils] parser.getDocument() is Null");
            }
            if ((metaTagCharset = TimelineUtils.getMetaTagCharset(document)) != null && !metaTagCharset.equals(contentTypeCharset)) {
                HttpURLConnection reconnection = ALURLConnectionUtils.openUrlConnection((URL)url);
                reconnection.setConnectTimeout(10000);
                reconnection.setUseCaches(false);
                reconnection.addRequestProperty("_", UUID.randomUUID().toString());
                reconnection.addRequestProperty("User-Agent", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0; Avant Browser)");
                reconnection.addRequestProperty("Accept-Encoding", "identity");
                reader = new BufferedReader(new InputStreamReader(reconnection.getInputStream(), metaTagCharset));
                source = new InputSource(reader);
                parser.setFeature("http://xml.org/sax/features/namespaces", false);
                parser.parse(source);
                document = parser.getDocument();
                if (document == null) {
                    logger.error((Object)"[TimelineUtils] parser.getDocument() is Null");
                }
            }
            reader.close();
            return document;
        }
        catch (DOMException e) {
            if (!"UTF-8".equals(defaultCharset)) {
                return TimelineUtils.getDocument(string, "UTF-8");
            }
            logger.error((Object)"[TimelineUtils]", (Throwable)e);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"[TimelineUtils]", (Throwable)ex);
            return null;
        }
    }

    public static String getMetaTagCharset(Document document) {
        String charset = null;
        NodeList metaList = document.getElementsByTagName("meta");
        for (int i = 0; i < metaList.getLength(); ++i) {
            Element element = (Element)metaList.item(i);
            String src = element.getAttribute("content");
            if (src != null && src.contains("charset=")) {
                charset = src.replaceFirst("(?i).*charset=(.*)", "$1");
                break;
            }
            src = element.getAttribute("charset");
            if (src == null || src.equals("")) continue;
            charset = src;
            break;
        }
        return charset;
    }

    public static boolean isYoutubeUrl(String url) {
        return url.startsWith("http://www.youtube.com") || url.startsWith("https://www.youtube.com");
    }

    public static String getYoutubeId(String url) {
        int startpoint = url.indexOf("v=");
        int endpoint = url.indexOf("&", startpoint);
        if (endpoint == -1) {
            endpoint = url.length();
        }
        return url.substring(startpoint + 2, endpoint);
    }

    public static TimelineUrlBeans perseFromUrl(String url_str) throws Exception {
        Document document = TimelineUtils.getDocument(url_str);
        if (document != null) {
            TimelineUrlBeans tub = new TimelineUrlBeans();
            String pagePath = url_str.substring(0, url_str.lastIndexOf(47) + 1);
            String basePath = url_str.substring(0, url_str.indexOf(47, url_str.indexOf("//") + 2) + 1);
            if (pagePath.endsWith("//")) {
                pagePath = basePath = url_str + "/";
            }
            if (TimelineUtils.isYoutubeUrl(pagePath)) {
                tub.setYoutubeId(TimelineUtils.getYoutubeId(url_str));
                tub.setYoutubeFlag(true);
            }
            String protocolString = url_str.substring(0, url_str.lastIndexOf(58) + 1);
            NodeList nodeListImage = document.getElementsByTagName("img");
            ArrayList<String> images = new ArrayList<String>();
            for (int i = 0; i < nodeListImage.getLength(); ++i) {
                Element element = (Element)nodeListImage.item(i);
                String src = element.getAttribute("src");
                if (src.startsWith("//")) {
                    src = protocolString + src;
                } else if (src.startsWith("/")) {
                    src = basePath + src.substring(1);
                } else if (!src.startsWith("http")) {
                    src = pagePath + src;
                }
                src = src.replaceAll("\n", "");
                src = src.replaceAll("\t", "");
                if (src == null) continue;
                images.add(src);
            }
            tub.setImages(images);
            NodeList nodeListTitle = document.getElementsByTagName("title");
            for (int i = 0; i < nodeListTitle.getLength(); ++i) {
                Element element = (Element)nodeListTitle.item(i);
                String title = element.getFirstChild() != null ? element.getFirstChild().getNodeValue() : url_str;
                if (title == null) continue;
                tub.setTitle(title);
                break;
            }
            NodeList nodeListBody = document.getElementsByTagName("meta");
            for (int i = 0; i < nodeListBody.getLength(); ++i) {
                String body;
                Element element = (Element)nodeListBody.item(i);
                String name = element.getAttribute("name");
                if (!name.equals("description") || (body = element.getAttribute("content")) == null) continue;
                tub.setBody(body);
                break;
            }
            tub.setUrl(url_str);
            return tub;
        }
        return null;
    }

    public static ResultList<EipTTimeline> getTimelineList(Integer userId, List<Integer> parentIds, String type, int page, int limit, int minId, List<Integer> userIds) {
        if (parentIds == null || parentIds.size() == 0) {
            return new ResultList(new ArrayList(0), -1, -1, 0);
        }
        StringBuilder select = new StringBuilder();
        select.append("SELECT");
        select.append(" eip_t_timeline.app_id,");
        select.append(" eip_t_timeline.create_date,");
        select.append(" eip_t_timeline.external_id,");
        select.append(" eip_t_timeline.note,");
        select.append(" eip_t_timeline.owner_id,");
        select.append(" eip_t_timeline.params,");
        select.append(" eip_t_timeline.parent_id,");
        select.append(" eip_t_timeline.timeline_type,");
        select.append(" eip_t_timeline.update_date,");
        select.append(" eip_t_timeline.timeline_id,");
        select.append(" (SELECT COUNT(*) FROM eip_t_timeline_like t0 WHERE (t0.timeline_id = eip_t_timeline.timeline_id) AND (t0.owner_id = #bind($user_id))) AS is_like,");
        select.append(" (SELECT COUNT(*) FROM eip_t_timeline_like t1 WHERE t1.timeline_id = eip_t_timeline.timeline_id) AS l_count");
        StringBuilder count = new StringBuilder();
        count.append("SELECT count(eip_t_timeline.timeline_id) AS c ");
        StringBuilder body = new StringBuilder();
        body.append(" FROM eip_t_timeline WHERE ");
        if (type != null) {
            body.append(" eip_t_timeline.timeline_type = #bind($type) AND ");
        }
        body.append(" eip_t_timeline.parent_id IN (");
        boolean isFirst = true;
        for (Integer n : parentIds) {
            if (!isFirst) {
                body.append(",");
            }
            body.append(n);
            isFirst = false;
        }
        body.append(")");
        if (minId > 0) {
            body.append(" AND eip_t_timeline.timeline_id > " + minId);
        }
        if (userIds != null && userIds.size() > 0) {
            body.append(" AND (");
            body.append("eip_t_timeline.owner_id IN (");
            boolean isFirstusers = true;
            for (Integer num : userIds) {
                if (!isFirstusers) {
                    body.append(",");
                }
                body.append(num);
                isFirstusers = false;
            }
            body.append(")");
            body.append(")");
        }
        StringBuilder last = new StringBuilder();
        if (PUBLIC_FLG_VALUE_PUBLIC.equals(type)) {
            last.append(" ORDER BY eip_t_timeline.create_date ASC");
        } else {
            last.append(" ORDER BY eip_t_timeline.update_date DESC");
        }
        SQLTemplate sQLTemplate = Database.sql(EipTTimeline.class, (String)(count.toString() + body.toString())).param("user_id", (Object)userId);
        if (type != null) {
            sQLTemplate.param("type", (Object)type);
        }
        int countValue = 0;
        if (page > 0 && limit > 0) {
            List fetchCount = sQLTemplate.fetchListAsDataRow();
            for (DataRow row : fetchCount) {
                countValue = ((Long)row.get((Object)"c")).intValue();
            }
            int offset = 0;
            if (limit > 0) {
                int num = (int)Math.ceil((double)countValue / (double)limit);
                if (num > 0 && num < page) {
                    page = num;
                }
                offset = limit * (page - 1);
            } else {
                page = 1;
            }
            last.append(" LIMIT ");
            last.append(limit);
            last.append(" OFFSET ");
            last.append(offset);
        }
        SQLTemplate query = Database.sql(EipTTimeline.class, (String)(select.toString() + body.toString() + last.toString())).param("user_id", (Object)userId);
        if (type != null) {
            query.param("type", (Object)type);
        }
        List fetchList = query.fetchListAsDataRow();
        ArrayList<EipTTimeline> list = new ArrayList<EipTTimeline>();
        for (DataRow row : fetchList) {
            Long is_like = (Long)row.get((Object)"is_like");
            Long l_count = (Long)row.get((Object)"l_count");
            EipTTimeline object = (EipTTimeline)Database.objectFromRowData((DataRow)row, EipTTimeline.class);
            object.setLike(is_like.intValue() > 0);
            object.setLikeCount(l_count.intValue());
            list.add(object);
        }
        if (page > 0 && limit > 0) {
            return new ResultList(list, page, limit, countValue);
        }
        return new ResultList(list, -1, -1, list.size());
    }

    public static void deleteTimelineActivity(RunData rundata, Context context, String appId, String ExternalId) throws ALFileNotRemovedException {
        SelectQuery query = Database.query(EipTTimeline.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"appId", (Object)appId);
        Expression exp2 = ExpressionFactory.matchExp((String)"externalId", (Object)ExternalId);
        query.setQualifier(exp1.andExp(exp2));
        EipTTimeline parent = (EipTTimeline)query.fetchSingle();
        try {
            if (parent != null) {
                TimelineUtils.deleteTimelineFromParent(rundata, context, appId, parent);
            }
        }
        catch (ALDBErrorException e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteTimelineFromParent(RunData rundata, Context context, String appId, EipTTimeline parent) throws ALDBErrorException, ALFileNotRemovedException {
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            String orgId = Database.getDomainName();
            List<EipTTimeline> list = appId.equals("Cabinet") ? TimelineUtils.getEipTTimelineListToDeleteAllUserTopic(rundata, context, ALEipUtils.isAdmin((RunData)rundata), parent.getTimelineId()) : TimelineUtils.getEipTTimelineListToDeleteTopic(rundata, context, ALEipUtils.isAdmin((RunData)rundata), parent.getTimelineId());
            if (list == null) {
                logger.debug((Object)"[TimelineFormData] Not found List...");
                throw new ALPageNotFoundException();
            }
            ArrayList<Integer> topicIdList = new ArrayList<Integer>();
            ArrayList<Integer> topicParentIdList = new ArrayList<Integer>();
            ArrayList<String> topicTypeList = new ArrayList<String>();
            EipTTimeline topic = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                topic = list.get(i);
                topicIdList.add(topic.getTimelineId());
                topicTypeList.add(topic.getTimelineType());
                topicParentIdList.add(topic.getParentId());
            }
            SelectQuery query = Database.query(EipTTimeline.class);
            Expression exp = ExpressionFactory.inDbExp((String)"TIMELINE_ID", topicIdList);
            query.setQualifier(exp);
            List topics = query.fetchList();
            ArrayList<String> fpaths = new ArrayList<String>();
            if (topics.size() > 0) {
                int tsize = topics.size();
                for (int i = 0; i < tsize; ++i) {
                    EipTTimeline item = (EipTTimeline)topics.get(i);
                    List files = item.getEipTTimelineFile();
                    if (files != null && files.size() > 0) {
                        int fsize = files.size();
                        for (int j = 0; j < fsize; ++j) {
                            fpaths.add(((EipTTimelineFile)files.get(j)).getFilePath());
                        }
                    }
                    TimelineUtils.deleteFiles(item.getTimelineId(), orgId, item.getTurbineUser().getUserId(), fpaths);
                    TimelineUtils.deleteLikes(((EipTTimeline)topics.get(i)).getTimelineId());
                }
            }
            if (((String)topicTypeList.get(0)).equals(STAT_VALUE_ALL)) {
                TimelineUtils.deleteParent(list, topicParentIdList, orgId, uid);
            }
            Database.deleteAll((List)topics);
            Database.commit();
            ALTimelineFactoryService tlservice = (ALTimelineFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALTimelineFactoryService");
            ALTimelineHandler timelinehandler = tlservice.getTimelineHandler();
            timelinehandler.pushToken(rundata, String.valueOf(uid));
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(parent.getTimelineId().intValue(), 330, TimelineUtils.compressString(parent.getNote()));
        }
        catch (ALFileNotRemovedException e) {
            Database.rollback();
            logger.error((Object)"[TimelineSelectData]", (Throwable)e);
            throw new ALFileNotRemovedException();
        }
        catch (RuntimeException e) {
            Database.rollback();
            logger.error((Object)"[TimelineSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[TimelineSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    public static void deleteParent(List<EipTTimeline> list, List<Integer> topicParentIdList, String orgId, int uid) throws Exception {
        int topicparent = 0;
        topicparent = topicParentIdList.get(0);
        SelectQuery dQuery = Database.query(EipTTimeline.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)topicparent);
        dQuery.andQualifier(exp1);
        dQuery.distinct(true);
        List tList = dQuery.fetchList();
        if (tList.size() == 1) {
            SelectQuery ddQuery = Database.query(EipTTimeline.class);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"TIMELINE_ID", (Object)topicparent);
            ddQuery.setQualifier(exp2);
            List tParent = ddQuery.fetchList();
            ArrayList<String> fpaths = new ArrayList<String>();
            if (tParent.size() > 0) {
                int tsize = tParent.size();
                for (int i = 0; i < tsize; ++i) {
                    EipTTimeline item = (EipTTimeline)tParent.get(i);
                    List files = item.getEipTTimelineFile();
                    TimelineUtils.deleteFiles(item.getTimelineId(), orgId, item.getTurbineUser().getUserId(), fpaths);
                    TimelineUtils.deleteLikes(((EipTTimeline)tParent.get(i)).getTimelineId());
                    if (files == null || files.size() <= 0) continue;
                    int fsize = files.size();
                    for (int j = 0; j < fsize; ++j) {
                        fpaths.add(((EipTTimelineFile)files.get(j)).getFilePath());
                    }
                }
            }
            Database.deleteAll((List)tParent);
            Database.commit();
        }
    }

    public static String compressString(String src) {
        return ALCommonUtils.compressString((String)src, (int)50);
    }
}

