/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.timecard.TimecardResultData;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class TimecardListResultData
implements ALData {
    private ALDateField date = null;
    private List<TimecardResultData> list = null;

    public void initField() {
        this.date = new ALDateField();
        this.date.setValue(new Date());
        this.list = new ArrayList<TimecardResultData>();
    }

    public void setDate(Date date) {
        this.date.setValue(date);
    }

    public ALDateField getDate() {
        return this.date;
    }

    public String getDateStr() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE)");
            return sdf.format(this.date.getValue().getDate());
        }
        catch (Exception e) {
            return "";
        }
    }

    public List<TimecardResultData> getList() {
        return this.list;
    }

    public List<TimecardResultData> getViewList() {
        ArrayList<TimecardResultData> viewlist = new ArrayList<TimecardResultData>();
        TimecardResultData rd = null;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            rd = this.list.get(i);
            if ("-1".equals(rd.getWorkFlag().getValue())) continue;
            viewlist.add(rd);
        }
        return viewlist;
    }

    public void addTimecardResultData(TimecardResultData rd) {
        this.list.add(rd);
    }

    public String getSummayTimes() {
        double millisecond = 0.0;
        Date workOnDate = null;
        Date workOffDate = null;
        TimecardResultData rd = null;
        int size = this.list.size();
        if (size < 1) {
            return "0";
        }
        if (size == 1) {
            rd = this.list.get(size - 1);
            if ("1".equals(rd.getWorkFlag().getValue())) {
                workOnDate = rd.getWorkDate().getValue();
                Calendar cal = Calendar.getInstance();
                millisecond += (double)(cal.getTime().getTime() - workOnDate.getTime());
            } else {
                workOffDate = rd.getWorkDate().getValue();
                Calendar cal = Calendar.getInstance();
                cal.setTime(workOffDate);
                cal.set(11, 0);
                cal.set(12, 0);
                millisecond += (double)(workOffDate.getTime() - cal.getTime().getTime());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                rd = this.list.get(i);
                if ("1".equals(rd.getWorkFlag().getValue())) {
                    workOnDate = rd.getWorkDate().getValue();
                    continue;
                }
                workOffDate = rd.getWorkDate().getValue();
                if (workOnDate == null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(workOffDate);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    millisecond += (double)(workOffDate.getTime() - cal.getTime().getTime());
                    continue;
                }
                millisecond += (double)(workOffDate.getTime() - workOnDate.getTime());
            }
        }
        BigDecimal decimal = new BigDecimal(millisecond / 1000.0 / 60.0 / 60.0);
        DecimalFormat dformat = new DecimalFormat("##.#");
        return dformat.format(decimal.setScale(1, 3).doubleValue());
    }
}

