/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.common.ALData;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimecardResultData
implements ALData {
    private ALStringField now_time;
    private ALStringField work_flag;
    private ALDateTimeField work_date;
    private ALStringField refix_flag;
    private ALStringField list_date;
    private ALStringField reason;
    private ALStringField timecard_id;
    private ALNumberField sum_work_date;
    private ALDateTimeField start_work_date;

    public void initField() {
        this.work_flag = new ALStringField();
        this.now_time = new ALStringField();
        this.work_date = new ALDateTimeField();
        this.refix_flag = new ALStringField();
        this.list_date = new ALStringField();
        this.timecard_id = new ALStringField();
        this.reason = new ALStringField();
        this.sum_work_date = new ALNumberField();
        this.start_work_date = new ALDateTimeField("yyyy-MM-dd");
    }

    public void setWorkFlag(String flag) {
        this.work_flag.setValue(flag);
    }

    public void setNowTime(String time) {
        this.now_time.setValue(time);
    }

    public void setWorkDate(Date date) {
        this.work_date.setValue(date);
        this.list_date.setValue(ALDateUtil.format((Date)date, (String)"MM\u6708dd\u65e5"));
    }

    public void setRefixFlag(Date create_date, Date update_date) {
        if (this.equalsToDate(create_date, update_date, true)) {
            this.refix_flag.setValue("0");
        } else {
            this.refix_flag.setValue("1");
        }
    }

    public void setTimecardId(long i) {
        this.timecard_id.setValue(Long.valueOf(i).toString());
    }

    public void setReason(String str_reason) {
        this.reason.setValue(str_reason);
    }

    public void setStartWorkDate(Date date_start_work_date) {
        this.start_work_date.setValue(date_start_work_date);
    }

    public void addSumWorkDate() {
        long count = this.sum_work_date.getValue();
        this.sum_work_date.setValue(count + 1L);
    }

    public ALNumberField getSumWorkDate() {
        return this.sum_work_date;
    }

    public ALDateTimeField getStartWorkDate() {
        return this.start_work_date;
    }

    public ALStringField getWorkFlag() {
        return this.work_flag;
    }

    public ALStringField getNowTime() {
        return this.now_time;
    }

    public ALDateTimeField getWorkDate() {
        return this.work_date;
    }

    public String getWorkDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH\u6642mm\u5206");
        return sdf.format(this.work_date.getValue());
    }

    public ALStringField getRefixFlag() {
        return this.refix_flag;
    }

    public ALStringField getListDate() {
        return this.list_date;
    }

    public ALStringField getTimecardId() {
        return this.timecard_id;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    private boolean equalsToDate(Date date1, Date date2, boolean checkTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Year = cal.get(1);
        int date1Month = cal.get(2) + 1;
        int date1Day = cal.get(5);
        int date1Hour = cal.get(10);
        int date1Minute = cal.get(12);
        int date1Second = cal.get(13);
        cal.setTime(date2);
        int date2Year = cal.get(1);
        int date2Month = cal.get(2) + 1;
        int date2Day = cal.get(5);
        int date2Hour = cal.get(10);
        int date2Minute = cal.get(12);
        int date2Second = cal.get(13);
        return checkTime ? date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute && date1Second == date2Second : date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }
}

