/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.sound;

import com.sk_jp.sound.SKClip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;

public class SKSoundClip
implements SKClip {
    private String name;
    private byte[] bytes;
    private Clip clip;
    private BooleanControl muteControl;
    private FloatControl panControl;
    private FloatControl sampleRateControl;
    private FloatControl volumeControl;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public SKSoundClip(URL uRL) throws IOException {
        this(uRL.openStream(), uRL.toString());
    }

    public SKSoundClip(InputStream inputStream, String string) throws IOException {
        int n;
        this.name = string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.bytes = byteArrayOutputStream.toByteArray();
        try {
            this.init();
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new IOException(lineUnavailableException.toString());
        }
    }

    public SKSoundClip(byte[] byArray, String string) {
        this.bytes = byArray;
        this.name = string;
        try {
            this.init();
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new RuntimeException(lineUnavailableException.toString());
        }
    }

    public SKSoundClip(SKClip sKClip) {
        this.name = sKClip.getName();
        this.bytes = ((SKSoundClip)sKClip).bytes;
        try {
            this.init();
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new RuntimeException(lineUnavailableException.toString());
        }
    }

    private void init() throws LineUnavailableException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.bytes));
            this.clip = (Clip)AudioSystem.getLine(new Line.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = SKSoundClip.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip));
            this.clip.open(audioInputStream);
            this.muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
            this.panControl = (FloatControl)this.clip.getControl(FloatControl.Type.PAN);
            this.sampleRateControl = (FloatControl)this.clip.getControl(FloatControl.Type.SAMPLE_RATE);
            this.volumeControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw lineUnavailableException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.clip.stop();
        this.clip.close();
    }

    public void setMute(boolean bl) {
        this.muteControl.setValue(bl);
    }

    public void setPan(float f) {
        this.panControl.setValue(f);
    }

    public void setSampleRate(float f) {
        this.sampleRateControl.setValue(f);
    }

    public void setVolume(float f) {
        this.volumeControl.setValue(f);
    }

    public void play(int n) {
        if (Boolean.getBoolean("sound.mute")) {
            return;
        }
        if (this.clip == null) {
            return;
        }
        this.clip.setFramePosition(n);
        this.clip.start();
    }

    public void play() {
        this.play(0);
    }

    public void loop() {
        if (Boolean.getBoolean("sound.mute")) {
            return;
        }
        if (this.clip == null) {
            return;
        }
        this.clip.loop(-1);
    }

    public void stop() {
        if (this.clip == null) {
            return;
        }
        this.clip.stop();
    }

    public Clip getClip() {
        return this.clip;
    }

    protected void finalize() {
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

