/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class IdentityKeyGenerator
implements KeyGenerator {
    private final int _sqlType;
    private final String _fName;

    public IdentityKeyGenerator(PersistenceFactory persistenceFactory, int n) throws MappingException {
        String string = persistenceFactory.getFactoryName();
        if (!(string.equals("sybase") || string.equals("sql-server") || string.equals("hsql") || string.equals("mysql") || string.equals("informix"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), string));
        }
        this._fName = string;
        this._sqlType = n;
        if (n != 4 && n != 2 && n != 3 && n != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
        if (n != 4 && this._fName.equals("hsql")) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection connection, String string, String string2, Properties properties) throws PersistenceException {
        BigDecimal bigDecimal;
        Statement statement;
        block19: {
            Long l;
            block18: {
                Integer n;
                block17: {
                    statement = null;
                    try {
                        try {
                            ResultSet resultSet;
                            if (this._fName.equals("hsql")) {
                                CallableStatement callableStatement = connection.prepareCall("{call IDENTITY()}");
                                statement = callableStatement;
                                callableStatement.execute();
                                resultSet = callableStatement.getResultSet();
                            } else if (this._fName.equals("mysql")) {
                                statement = connection.prepareStatement("SELECT LAST_INSERT_ID()");
                                resultSet = statement.executeQuery();
                            } else if (this._fName.equals("informix")) {
                                statement = connection.prepareStatement("select dbinfo('sqlca.sqlerrd1') from systables where tabid = 1");
                                resultSet = statement.executeQuery();
                            } else {
                                statement = connection.prepareStatement("SELECT @@identity");
                                resultSet = statement.executeQuery();
                            }
                            if (!resultSet.next()) throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                            int n2 = resultSet.getInt(1);
                            if (this._sqlType == 4) {
                                n = new Integer(n2);
                                Object var9_13 = null;
                                if (statement == null) return n;
                                break block17;
                            }
                            if (this._sqlType == -5) {
                                l = new Long(n2);
                                break block18;
                            }
                            bigDecimal = new BigDecimal((double)n2);
                            break block19;
                        }
                        catch (SQLException sQLException) {
                            throw new PersistenceException(Messages.format("persist.keyGenSQL", sQLException.toString()));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        if (statement == null) throw throwable;
                        try {
                            statement.close();
                            throw throwable;
                        }
                        catch (SQLException sQLException) {
                            throw throwable;
                        }
                    }
                }
                try {}
                catch (SQLException sQLException) {}
                statement.close();
                return n;
            }
            Object var9_14 = null;
            if (statement == null) return l;
            try {}
            catch (SQLException sQLException) {}
            statement.close();
            return l;
        }
        Object var9_15 = null;
        if (statement == null) return bigDecimal;
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return bigDecimal;
    }

    public final byte getStyle() {
        return 1;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public final String patchSQL(String string, String string2) throws MappingException {
        return string;
    }
}

