/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.DefaultNaming;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class Configuration {
    private static final String TRUE_VALUE = "true";
    private static final String ON_VALUE = "on";
    private static Properties _default;
    private static boolean _debug;
    private static boolean _MarshallingValidation;
    private static XMLNaming _naming;
    private static NodeType _primitiveNodeType;
    static /* synthetic */ Class class$org$exolab$castor$util$Configuration;

    static {
        _MarshallingValidation = true;
        _naming = null;
        _primitiveNodeType = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static boolean debug() {
        Configuration.getDefault();
        return _debug;
    }

    public static synchronized Properties getDefault() {
        if (_default == null) {
            Configuration.load();
        }
        return _default;
    }

    public static OutputFormat getOutputFormat() {
        boolean bl = false;
        String string = Configuration.getDefault().getProperty("org.exolab.castor.indent", "");
        bl = string.equalsIgnoreCase(TRUE_VALUE) || string.equalsIgnoreCase(ON_VALUE);
        OutputFormat outputFormat = new OutputFormat("xml", null, bl);
        if (!bl) {
            outputFormat.setPreserveSpace(true);
        }
        return outputFormat;
    }

    public static Parser getParser() {
        return Configuration.getParser(null);
    }

    public static Parser getParser(String string) {
        Parser parser;
        Object object;
        String string2 = Configuration.getDefault().getProperty("org.exolab.castor.parser");
        if (string2 == null || string2.equalsIgnoreCase("xerces")) {
            string2 = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            object = Class.forName(string2);
            parser = (Parser)((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateParser", string2, exception));
        }
        if (parser instanceof XMLReader) {
            string2 = Configuration.getDefault().getProperty("org.exolab.castor.parser.validation", "false");
            boolean bl = string2.equalsIgnoreCase(TRUE_VALUE) || string2.equalsIgnoreCase(ON_VALUE);
            try {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/validation", bl);
            }
            catch (SAXException sAXException) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", sAXException));
            }
            string2 = Configuration.getDefault().getProperty("org.exolab.castor.parser.namespaces", "false");
            bl = string2.equalsIgnoreCase(TRUE_VALUE) || string2.equalsIgnoreCase(ON_VALUE);
            try {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/namespaces", bl);
            }
            catch (SAXException sAXException) {
                Logger.getSystemLogger().println(Messages.format("conf.configurationError", sAXException));
            }
            string = Configuration.getDefault().getProperty("org.exolab.castor.sax.features", string);
            if (string != null) {
                object = new StringTokenizer(string, ", ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        ((XMLReader)((Object)parser)).setFeature(((StringTokenizer)object).nextToken(), true);
                    }
                    catch (SAXException sAXException) {
                        Logger.getSystemLogger().println(Messages.format("conf.configurationError", sAXException));
                    }
                }
            }
        }
        return parser;
    }

    public static NodeType getPrimitiveNodeType() {
        if (_primitiveNodeType != null) {
            return _primitiveNodeType;
        }
        String string = Configuration.getProperty("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (string == null) {
            return null;
        }
        _primitiveNodeType = NodeType.getNodeType(string);
        return _primitiveNodeType;
    }

    public static String getProperty(String string, String string2) {
        return Configuration.getDefault().getProperty(string, string2);
    }

    public static RegExpEvaluator getRegExpEvaluator() {
        String string = Configuration.getDefault().getProperty("org.exolab.castor.regexp");
        RegExpEvaluator regExpEvaluator = null;
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            regExpEvaluator = (RegExpEvaluator)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", string, exception));
        }
        return regExpEvaluator;
    }

    public static Serializer getSerializer() {
        XMLSerializer xMLSerializer;
        String string = Configuration.getDefault().getProperty("org.exolab.castor.serializer");
        if (string == null || string.equalsIgnoreCase("xerces")) {
            xMLSerializer = new XMLSerializer();
        } else {
            try {
                xMLSerializer = (Serializer)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateSerializer", string, exception));
            }
        }
        xMLSerializer.setOutputFormat(Configuration.getOutputFormat());
        return xMLSerializer;
    }

    public static DocumentHandler getSerializer(OutputStream outputStream) throws IOException {
        Serializer serializer = Configuration.getSerializer();
        serializer.setOutputByteStream(outputStream);
        DocumentHandler documentHandler = serializer.asDocumentHandler();
        if (documentHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return documentHandler;
    }

    public static DocumentHandler getSerializer(Writer writer) throws IOException {
        Serializer serializer = Configuration.getSerializer();
        serializer.setOutputCharStream(writer);
        DocumentHandler documentHandler = serializer.asDocumentHandler();
        if (documentHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return documentHandler;
    }

    public static XMLNaming getXMLNaming() {
        if (_naming != null) {
            return _naming;
        }
        String string = Configuration.getProperty("org.exolab.castor.xml.naming", null);
        if (string == null || string.equalsIgnoreCase("lower")) {
            _naming = new DefaultNaming();
        } else if (string.equalsIgnoreCase("mixed")) {
            DefaultNaming defaultNaming = new DefaultNaming();
            defaultNaming.setStyle((short)1);
            _naming = defaultNaming;
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                _naming = (XMLNaming)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to load XMLNaming: " + exception);
            }
        }
        return _naming;
    }

    protected static void load() {
        _default = Configuration.loadProperties("/org/exolab/castor/castor.properties", "castor.properties");
        String string = _default.getProperty("org.exolab.castor.debug", "");
        if (string.equalsIgnoreCase(TRUE_VALUE) || string.equalsIgnoreCase(ON_VALUE)) {
            _debug = true;
        }
        if ((string = _default.getProperty("org.exolab.castor.marshalling.validation", "")).equalsIgnoreCase("false") || string.equalsIgnoreCase("off")) {
            _MarshallingValidation = false;
        }
        string = null;
    }

    public static Properties loadProperties(String string, String string2) {
        Properties properties = new Properties();
        try {
            properties.load((class$org$exolab$castor$util$Configuration != null ? class$org$exolab$castor$util$Configuration : (class$org$exolab$castor$util$Configuration = Configuration.class$("org.exolab.castor.util.Configuration"))).getResourceAsStream(string));
        }
        catch (Exception exception) {
            throw new RuntimeException(Messages.format("conf.noDefaultConfigurationFile", string2));
        }
        try {
            File file = new File(System.getProperty("java.home"), "lib");
            file = new File(file, string2);
            if (file.exists()) {
                properties = new Properties(properties);
                properties.load(new FileInputStream(file));
            }
        }
        catch (IOException iOException) {}
        try {
            InputStream inputStream = (class$org$exolab$castor$util$Configuration != null ? class$org$exolab$castor$util$Configuration : (class$org$exolab$castor$util$Configuration = Configuration.class$("org.exolab.castor.util.Configuration"))).getResourceAsStream("/" + string2);
            if (inputStream != null) {
                properties = new Properties(properties);
                properties.load(inputStream);
            }
        }
        catch (Exception exception) {}
        return properties;
    }

    public static boolean marshallingValidation() {
        Configuration.getDefault();
        return _MarshallingValidation;
    }

    public static class Property {
        public static final String Serializer = "org.exolab.castor.serializer";
        public static final String PrimitiveNodeType = "org.exolab.castor.xml.introspector.primitive.nodetype";
        public static final String Parser = "org.exolab.castor.parser";
        public static final String ParserValidation = "org.exolab.castor.parser.validation";
        public static final String Namespaces = "org.exolab.castor.parser.namespaces";
        public static final String Naming = "org.exolab.castor.xml.naming";
        public static final String MarshallingValidation = "org.exolab.castor.marshalling.validation";
        public static final String Indent = "org.exolab.castor.indent";
        public static final String ParserFeatures = "org.exolab.castor.sax.features";
        public static final String ParserFeatureSeparator = ",";
        public static final String RegExp = "org.exolab.castor.regexp";
        public static final String Debug = "org.exolab.castor.debug";
        public static final String FileName = "castor.properties";
        static final String ResourceName = "/org/exolab/castor/castor.properties";
    }

    private static class Features {
        public static final String Validation = "http://xml.org/sax/features/validation";
        public static final String Namespaces = "http://xml.org/sax/features/namespaces";

        Features() {
        }
    }
}

