/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALEipHolidaysManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ScheduleSearchResultData
extends ScheduleResultData {
    private ALEipUser createUser;
    private ALDateTimeField DateDay;
    private ALStringField note;

    @Override
    public void initField() {
        super.initField();
        this.note = new ALStringField();
    }

    public String getDateFull() {
        SimpleDateFormat sdf = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"SCHEDULE_SIMPLE_DATE_FORMAT"));
        StringBuilder b = new StringBuilder();
        if ("S".equals(this.getPattern())) {
            b.append(sdf.format(this.getStartDate().getValue()));
        } else {
            b.append(sdf.format(this.getStartDate().getValue())).append(" ").append(this.getDate2());
        }
        return b.toString();
    }

    public String getDateFullOnlyDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"SCHEDULE_SIMPLE_DATE_FORMAT"));
        StringBuilder b = new StringBuilder();
        b.append(sdf.format(this.getStartDate().getValue()));
        return b.toString();
    }

    public String getDateShort() {
        SimpleDateFormat sdf = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"SCHEDULE_SIMPLE_DATE_FORMAT_SHORT"));
        StringBuilder b = new StringBuilder();
        b.append(sdf.format(this.getStartDate().getValue()));
        return b.toString();
    }

    public String getPatternTime() {
        StringBuilder b = new StringBuilder();
        if ("S".equals(this.getPattern())) {
            if (this.isTerm()) {
                b.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_TERM"));
            } else {
                b.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_ALL_DAY"));
            }
        } else {
            b.append(this.getDate());
        }
        return b.toString();
    }

    public ALDateTimeField getDateDay() {
        this.DateDay = new ALDateTimeField("yyyy-MM-dd");
        this.DateDay.setValue(this.getViewDate());
        return this.DateDay;
    }

    public boolean isStartDayEqualsEndDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String startDate = sdf.format(this.getStartDate().getValue());
        String endDate = sdf.format(this.getEndDate().getValue());
        return startDate.equals(endDate);
    }

    public boolean isStartDayEqualsToday() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String startDate = sdf.format(this.getStartDate().getValue());
        String toDay = sdf.format(new Date());
        return startDate.equals(toDay);
    }

    public boolean isStartDateHoliday() {
        return ALEipHolidaysManager.getInstance().isHoliday(this.getStartDate().getValue()) != null;
    }

    public String getDateDetail() {
        SimpleDateFormat sdf = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"SCHEDULE_SIMPLE_DATE_FORMAT"));
        StringBuilder b = new StringBuilder();
        if ("S".equals(this.getPattern())) {
            b.append(sdf.format(this.getStartDate().getValue()));
            if (!this.isStartDayEqualsEndDay()) {
                b.append("&nbsp;");
                b.append("-");
                b.append("&nbsp;");
                b.append(sdf.format(this.getEndDate().getValue()));
            }
        } else {
            b.append(sdf.format(this.getStartDate().getValue())).append(" ").append(this.getDate());
        }
        return b.toString();
    }

    public String getViewDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.format(this.getStartDate().getValue());
        return sdf.format(this.getStartDate().getValue());
    }

    public ALEipUser getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(ALEipUser createUser) {
        this.createUser = createUser;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note.setValue(note);
    }

    public ALStringField getNoteShort() {
        ALStringField field = new ALStringField();
        String str = this.note.getValue().replaceAll("\r", "").replaceAll("\n", " ");
        field.setValue(ALCommonUtils.compressString((String)str, (int)30));
        return field;
    }
}

