/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.util;

import com.aimluck.eip.cayenne.om.account.VEipMUserGroupList;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facility.beans.FacilityLiteBean;
import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.cayenne.DataRow;

public class ScheduleAclUtils {
    public static final String ACL_CACHE_KEY = "com.aimluck.eip.schedule.util.ScheduleAclUtils.cache";
    public static int ACL_READONLY = 1;
    public static int ACL_EDITABLE = 1;

    public static boolean hasAclAcceptUser(int targetId, int userId, int level) {
        return ScheduleAclUtils.hasAclAccept(targetId, userId, level, false);
    }

    public static boolean hasAclAcceptFacility(int targetId, int userId, int level) {
        return ScheduleAclUtils.hasAclAccept(targetId, userId, level, true);
    }

    public static boolean hasAclAccept(int targetId, int userId, int level, boolean isFacility) {
        List<Integer> list = null;
        list = isFacility ? ScheduleAclUtils.getAclAcceptFacilityFilter(Arrays.asList(targetId), userId, level) : ScheduleAclUtils.getAclAcceptUserFilter(Arrays.asList(targetId), userId, level);
        return list != null && list.size() > 0;
    }

    public static List<Integer> getAclAcceptUserList(int userId, int level) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        String key = "com.aimluck.eip.schedule.util.ScheduleAclUtils.cacheusers:" + userId + ":" + level;
        List cache = null;
        if (request != null) {
            try {
                cache = (List)request.getAttribute(key);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (cache != null) {
            return cache;
        }
        StringBuilder sql = new StringBuilder("SELECT target_id as uid FROM eip_t_acl_map where level >= #bind($level) AND feature = 'schedule' AND target_type = 'u' AND ((type = 'ug' and id IN (select group_id from turbine_user_group_role where user_id = #bind($user_id) and role_id = 1)) OR (type = 'u' and id = #bind($user_id)))");
        sql.append(" UNION ");
        sql.append(" SELECT user_id as uid FROM turbine_user_group_role WHERE role_id = 1 and group_id IN (SELECT DISTINCT target_id from eip_t_acl_map where level >= #bind($level) AND feature = 'schedule' AND target_type = 'ug' AND ((type = 'ug' and id IN (select group_id from turbine_user_group_role where user_id = #bind($user_id) and role_id = 1)) OR (type = 'u' and id = #bind($user_id))))");
        SQLTemplate query = Database.sql(VEipMUserGroupList.class, (String)sql.toString()).param("user_id", (Object)userId).param("level", (Object)level);
        List fetchCount = query.fetchListAsDataRow();
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (DataRow row : fetchCount) {
            results.add((Integer)row.get((Object)"uid"));
        }
        if (request != null) {
            request.setAttribute(key, results);
        }
        return results;
    }

    public static List<Integer> getAclAcceptFacilityList(int userId, int level) {
        HttpServletRequest request = HttpServletRequestLocator.get();
        String key = "com.aimluck.eip.schedule.util.ScheduleAclUtils.cachefacilities:" + userId + ":" + level;
        List cache = null;
        if (request != null) {
            try {
                cache = (List)request.getAttribute(key);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (cache != null) {
            return cache;
        }
        StringBuilder sql = new StringBuilder("SELECT target_id as uid FROM eip_t_acl_map where level >= #bind($level) AND feature = 'schedule' AND target_type = 'f' AND ((type = 'ug' and id IN (select group_id from turbine_user_group_role where user_id = #bind($user_id) and role_id = 1)) OR (type = 'u' and id = #bind($user_id)))");
        sql.append(" UNION ");
        sql.append(" SELECT facility_id as uid FROM eip_m_facility_group_map WHERE group_id IN (SELECT DISTINCT target_id from eip_t_acl_map where level >= #bind($level) AND feature = 'schedule' AND target_type = 'fg' AND ((type = 'ug' and id IN (select group_id from turbine_user_group_role where user_id = #bind($user_id) and role_id = 1)) OR (type = 'u' and id = #bind($user_id))))");
        SQLTemplate query = Database.sql(VEipMUserGroupList.class, (String)sql.toString()).param("user_id", (Object)userId).param("level", (Object)level);
        List fetchCount = query.fetchListAsDataRow();
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (DataRow row : fetchCount) {
            results.add((Integer)row.get((Object)"uid"));
        }
        if (request != null) {
            request.setAttribute(key, results);
        }
        return results;
    }

    public static <M> List<M> getAclAcceptUserFilter(List<M> users, int userId, int level) {
        if (users == null) {
            return null;
        }
        List<Integer> aclAcceptUserList = ScheduleAclUtils.getAclAcceptUserList(userId, level);
        ArrayList<M> results = new ArrayList<M>(users.size());
        for (M user : users) {
            Integer id;
            if (user instanceof ALEipUser) {
                id = (int)((ALEipUser)user).getUserId().getValue();
                if (!aclAcceptUserList.contains(id) && userId != id) continue;
                results.add(user);
                continue;
            }
            if (user instanceof UserLiteBean) {
                id = Integer.valueOf(((UserLiteBean)user).getUserId());
                if (!aclAcceptUserList.contains(id) && userId != id) continue;
                results.add(user);
                continue;
            }
            if (user instanceof UserFacilityLiteBean) {
                id = Integer.valueOf(((UserFacilityLiteBean)user).getUserFacilityId());
                if (!aclAcceptUserList.contains(id) && userId != id) continue;
                results.add(user);
                continue;
            }
            if (!(user instanceof Integer) || !aclAcceptUserList.contains(user) && userId != (Integer)user) continue;
            results.add(user);
        }
        return results;
    }

    public static <M> List<M> getAclRejectUserFilter(List<M> users, int userId, int level) {
        if (users == null) {
            return null;
        }
        List<Integer> aclAcceptUserList = ScheduleAclUtils.getAclAcceptUserList(userId, level);
        ArrayList<M> results = new ArrayList<M>(users.size());
        for (M user : users) {
            Integer id;
            if (user instanceof ALEipUser) {
                id = (int)((ALEipUser)user).getUserId().getValue();
                if (aclAcceptUserList.contains(id) || userId == id) continue;
                results.add(user);
                continue;
            }
            if (user instanceof UserLiteBean) {
                id = Integer.valueOf(((UserLiteBean)user).getUserId());
                if (aclAcceptUserList.contains(id) || userId == id) continue;
                results.add(user);
                continue;
            }
            if (user instanceof UserFacilityLiteBean) {
                id = Integer.valueOf(((UserFacilityLiteBean)user).getUserFacilityId());
                if (aclAcceptUserList.contains(id) || userId == id) continue;
                results.add(user);
                continue;
            }
            if (!(user instanceof Integer) || aclAcceptUserList.contains(user) || userId == (Integer)user) continue;
            results.add(user);
        }
        return results;
    }

    public static <M> List<M> getAclAcceptFacilityFilter(List<M> facilities, int userId, int level) {
        if (facilities == null) {
            return null;
        }
        List<Integer> aclAcceptFacilityList = ScheduleAclUtils.getAclAcceptFacilityList(userId, level);
        ArrayList<M> results = new ArrayList<M>(facilities.size());
        for (M facility : facilities) {
            Integer id;
            if (facility instanceof FacilityResultData) {
                id = (int)((FacilityResultData)facility).getFacilityId().getValue();
                if (!aclAcceptFacilityList.contains(id)) continue;
                results.add(facility);
                continue;
            }
            if (facility instanceof FacilityLiteBean) {
                id = Integer.valueOf(((FacilityLiteBean)facility).getFacilityId());
                if (!aclAcceptFacilityList.contains(id)) continue;
                results.add(facility);
                continue;
            }
            if (facility instanceof UserFacilityLiteBean) {
                id = Integer.valueOf(((UserFacilityLiteBean)facility).getUserFacilityId());
                if (!aclAcceptFacilityList.contains(id)) continue;
                results.add(facility);
                continue;
            }
            if (!(facility instanceof Integer) || !aclAcceptFacilityList.contains(facility)) continue;
            results.add(facility);
        }
        return results;
    }

    public static <M> List<M> getAclRejectFacilityFilter(List<M> facilities, int userId, int level) {
        if (facilities == null) {
            return null;
        }
        List<Integer> aclAcceptFacilityList = ScheduleAclUtils.getAclAcceptFacilityList(userId, level);
        ArrayList<M> results = new ArrayList<M>(facilities.size());
        for (M facility : facilities) {
            Integer id;
            if (facility instanceof FacilityResultData) {
                id = (int)((FacilityResultData)facility).getFacilityId().getValue();
                if (aclAcceptFacilityList.contains(id)) continue;
                results.add(facility);
                continue;
            }
            if (facility instanceof FacilityLiteBean) {
                id = Integer.valueOf(((FacilityLiteBean)facility).getFacilityId());
                if (aclAcceptFacilityList.contains(id)) continue;
                results.add(facility);
                continue;
            }
            if (facility instanceof UserFacilityLiteBean) {
                id = Integer.valueOf(((UserFacilityLiteBean)facility).getUserFacilityId());
                if (!aclAcceptFacilityList.contains(id)) continue;
                results.add(facility);
                continue;
            }
            if (!(facility instanceof Integer) || aclAcceptFacilityList.contains(facility)) continue;
            results.add(facility);
        }
        return results;
    }

    public static boolean hasAclAcceptUserFromScheduleId(int userId, int scheduleId, int level, boolean isFacility) {
        List list = Database.query(EipTScheduleMap.class).where(Operations.eq((String)"scheduleId", (Object)scheduleId)).fetchList();
        ArrayList<Integer> users = new ArrayList<Integer>();
        ArrayList<Integer> facilities = new ArrayList<Integer>();
        for (EipTScheduleMap map : list) {
            if ("U".equals(map.getType())) {
                users.add(map.getUserId());
                continue;
            }
            facilities.add(map.getUserId());
        }
        List results = isFacility ? ScheduleAclUtils.getAclAcceptFacilityFilter(facilities, userId, level) : ScheduleAclUtils.getAclAcceptUserFilter(users, userId, level);
        return results != null && results.size() > 0;
    }
}

