/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardFormData.class.getName());
    private ALNumberField timecard_id;
    private ALNumberField user_id;
    private ALDateTimeField punch_date;
    private ALStringField type;
    private ALDateTimeField clock_in_time;
    private ALDateTimeField clock_out_time;
    private ALStringField reason;
    private ALDateTimeField outgoing_time1;
    private ALDateTimeField outgoing_time2;
    private ALDateTimeField outgoing_time3;
    private ALDateTimeField outgoing_time4;
    private ALDateTimeField outgoing_time5;
    private ALDateTimeField comeback_time1;
    private ALDateTimeField comeback_time2;
    private ALDateTimeField comeback_time3;
    private ALDateTimeField comeback_time4;
    private ALDateTimeField comeback_time5;
    private ALDateTimeField outgoing_comeback;
    private ALStringField remarks;
    private ALDateField create_date;
    private ALDateField update_date;
    private int entity_id;
    private int login_uid;
    private String selectedUserId;
    private String edit_mode;
    private String alt_mode;
    private String old_clock_in_time_hour;
    private String old_clock_in_time_minute;
    private String old_clock_out_time_hour;
    private String old_clock_out_time_minute;
    private ALStringField rest_num;
    private EipTExtTimecardSystem timecard_system;
    private int current_clock_out_time_hour;
    private int current_clock_out_time_minute;
    private final String aclPortletFeatureOther = "timecard_timecard_other";
    private ALAccessControlHandler aclHandler;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.login_uid = ALEipUtils.getUserId((RunData)rundata);
        this.selectedUserId = rundata.getParameters().getString("userid", "");
        this.old_clock_in_time_hour = rundata.getParameters().get("old_clock_in_time_hour");
        this.old_clock_in_time_minute = rundata.getParameters().get("old_clock_in_time_minute");
        this.old_clock_out_time_hour = rundata.getParameters().get("old_clock_out_time_hour");
        this.old_clock_out_time_minute = rundata.getParameters().get("old_clock_out_time_minute");
        this.timecard_system = ExtTimecardUtils.getEipTExtTimecardSystemCurrentUserId(rundata, context);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        this.aclHandler = aclservice.getAccessControlHandler();
    }

    public void initField() {
        this.timecard_id = new ALNumberField();
        this.user_id = new ALNumberField();
        this.type = new ALStringField();
        this.type.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_KINDS"));
        this.type.setValue("");
        this.punch_date = new ALDateTimeField();
        this.punch_date.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_DATE"));
        this.clock_in_time = new ALDateTimeField();
        this.clock_in_time.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_WORKTIME"));
        this.clock_out_time = new ALDateTimeField();
        this.outgoing_comeback = new ALDateTimeField();
        this.outgoing_comeback.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_OUTGOINGTIME"));
        this.reason = new ALStringField();
        this.reason.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_REASON"));
        this.reason.setValue("");
        this.remarks = new ALStringField();
        this.remarks.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_REMARKS"));
        this.remarks.setValue("");
        this.create_date = new ALDateField();
        this.create_date.setValue(new Date());
        this.update_date = new ALDateField();
        this.update_date.setValue(new Date());
        this.edit_mode = "";
        this.alt_mode = "";
        this.rest_num = new ALStringField();
        this.rest_num.setValue("0");
        try {
            for (int i = 1; i <= 5; ++i) {
                Field field = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                field.set((Object)this, new ALDateTimeField());
                field = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                field.set((Object)this, new ALDateTimeField());
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"[ExtTimecardFormData]", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.error((Object)"[ExtTimecardFormData]", (Throwable)e);
            return;
        }
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            boolean isedit = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid") != null;
            action.setMode(isedit ? "edit_form" : "new_form");
            this.setMode(action.getMode());
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = isedit ? this.loadFormData(rundata, context, msgList) : this.setFormData(rundata, context, msgList);
            int aclType = 4;
            if (isedit || this.getIsPast() || this.getIsToday()) {
                aclType = 8;
            }
            this.doCheckAclPermission(rundata, context, aclType);
            action.setResultData((Object)this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        try {
            if (this.type.getValue().equals("")) {
                msgList.add(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_ALERT_SELECT_KIND"));
            }
            if (!("punchin".equals(this.edit_mode) || "punchout".equals(this.edit_mode) || "outgoing".equals(this.edit_mode) || "comeback".equals(this.edit_mode) || !this.isModify() && !this.isNotAtWork() || !this.isNotFuture())) {
                this.reason.setNotNull(true);
                this.reason.validate(msgList);
            }
            if (this.getMode().equals("insert")) {
                SelectQuery workflg_query = Database.query(EipTExtTimecard.class);
                Expression workflg_exp = ExpressionFactory.matchExp((String)"userId", (Object)this.login_uid);
                workflg_query.setQualifier(workflg_exp);
                workflg_query.orderDesending("punchDate");
                List workflg_list = workflg_query.fetchList();
                if (workflg_list == null || workflg_list.size() > 0) {
                    // empty if block
                }
            }
            if (this.edit_mode.equals("") && "P".equals(this.type.getValue())) {
                if (this.ajustDate(this.clock_in_time, this.punch_date) && this.ajustDate(this.clock_out_time, this.punch_date) && this.clock_in_time.getValue().getTime() > this.clock_out_time.getValue().getTime()) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_ALERT_SELECT_PUNCH_OUT_TIME"));
                }
                boolean out_flag = false;
                out_flag = !this.old_clock_out_time_hour.isEmpty() || !this.old_clock_out_time_minute.isEmpty();
                if (this.getIsPast() && "P".equals(this.type.getValue())) {
                    int i;
                    Field field_come;
                    Field field_out;
                    if (!this.clock_in_time.isNotNullValue() || !this.clock_out_time.isNotNullValue() && out_flag || this.current_clock_out_time_hour == -1 && this.current_clock_out_time_minute != -1 || this.current_clock_out_time_hour != -1 && this.current_clock_out_time_minute == -1) {
                        msgList.add(ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_ALERT_TYPE_CLOCKINTIME", (Object[])new Object[]{this.clock_in_time.getFieldName()}));
                    }
                    for (int i2 = 1; i2 <= Integer.parseInt(this.rest_num.getValue()); ++i2) {
                        field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i2);
                        field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i2);
                        ALDateTimeField outgoing = (ALDateTimeField)field_out.get((Object)this);
                        ALDateTimeField comeback = (ALDateTimeField)field_come.get((Object)this);
                        if (outgoing.isNotNullValue() && comeback.isNotNullValue()) continue;
                        msgList.add(ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_ALERT_TYPE_OUTGOING_COMEBACK", (Object[])new Object[]{this.outgoing_comeback.getFieldName(), i2}));
                    }
                    ArrayList list_from_to = new ArrayList();
                    for (i = 1; i <= 5; ++i) {
                        field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                        field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                        ALDateTimeField outgoing = (ALDateTimeField)field_out.get((Object)this);
                        ALDateTimeField comeback = (ALDateTimeField)field_come.get((Object)this);
                        if (this.ajustDate(outgoing, this.punch_date) && this.ajustDate(comeback, this.punch_date)) {
                            long to;
                            long from = outgoing.getValue().getTime();
                            if (from <= (to = comeback.getValue().getTime())) {
                                if (this.clock_in_time.isNotNullValue() && from < this.clock_in_time.getValue().getTime()) {
                                    msgList.add(ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_ALERT_SELECT_OUTGOING_AFTER_PUNCH_IN", (Object[])new Object[]{i}));
                                }
                                if (this.clock_out_time.isNotNullValue() && to > this.clock_out_time.getValue().getTime()) {
                                    msgList.add(ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_ALERT_SELECT_COMEBACK_AFTER_PUNCH_OUT", (Object[])new Object[]{i}));
                                }
                                HashMap<String, Long> hashMap = new HashMap<String, Long>();
                                hashMap.put("from", outgoing.getValue().getTime());
                                hashMap.put("to", comeback.getValue().getTime());
                                list_from_to.add(hashMap);
                                continue;
                            }
                            msgList.add(ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_ALERT_SELECT_COMEBACK_AFTER_OUTGOING", (Object[])new Object[]{i}));
                            continue;
                        }
                        if (!this.ajustDate(outgoing, this.punch_date) || this.ajustDate(comeback, this.punch_date) || i != 1) continue;
                        HashMap<String, Long> from_to = new HashMap<String, Long>();
                        from_to.put("from", outgoing.getValue().getTime());
                        list_from_to.add(from_to);
                        return msgList.size() == 0;
                    }
                    i = 1;
                    if (list_from_to.size() > 0) {
                        long to;
                        ArrayList empty_from_to = new ArrayList();
                        long min_from = (Long)((Map)list_from_to.get(0)).get("from");
                        long max_to = (Long)((Map)list_from_to.get(0)).get("to");
                        list_from_to.remove(0);
                        for (Map map : list_from_to) {
                            long new_from = (Long)map.get("from");
                            long new_to = (Long)map.get("to");
                            if (new_to <= min_from) {
                                HashMap<String, Long> empty = new HashMap<String, Long>();
                                empty.put("from", new_to);
                                empty.put("to", min_from);
                                empty_from_to.add(empty);
                                min_from = new_from;
                                continue;
                            }
                            if (new_from >= max_to) {
                                HashMap<String, Long> empty = new HashMap<String, Long>();
                                empty.put("from", max_to);
                                empty.put("to", new_from);
                                empty_from_to.add(empty);
                                max_to = new_to;
                                continue;
                            }
                            boolean duplicate_flag = true;
                            for (Map map2 : empty_from_to) {
                                if ((Long)map2.get("from") > new_from || (Long)map2.get("to") < new_to) continue;
                                HashMap empty_left = new HashMap();
                                empty_left.put("from", map2.get("from"));
                                empty_left.put("to", new_from);
                                empty_from_to.add(empty_left);
                                HashMap<String, Long> empty_right = new HashMap<String, Long>();
                                empty_right.put("from", new_to);
                                empty_right.put("to", (Long)map2.get("to"));
                                empty_from_to.add(empty_right);
                                empty_from_to.remove(map2);
                                duplicate_flag = false;
                                break;
                            }
                            if (!duplicate_flag) continue;
                            msgList.add(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_ALERT_OUTGOINGTIME"));
                            return false;
                        }
                        Collections.sort(empty_from_to, new Comparator<Map<String, Long>>(){

                            @Override
                            public int compare(Map<String, Long> o1, Map<String, Long> o2) {
                                long from2;
                                Map<String, Long> hash1 = o1;
                                Map<String, Long> hash2 = o2;
                                long from1 = hash1.get("from");
                                if (from1 == (from2 = hash2.get("from").longValue())) {
                                    long to1 = hash1.get("to");
                                    long to2 = hash2.get("to");
                                    return (int)(to1 - to2);
                                }
                                return (int)(from1 - from2);
                            }

                            public int hashCode() {
                                return super.hashCode();
                            }

                            @Override
                            public boolean equals(Object obj) {
                                return super.equals(obj);
                            }
                        });
                        long from = min_from;
                        for (Map map : empty_from_to) {
                            to = (Long)map.get("from");
                            field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                            field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                            ALDateTimeField outgoing = (ALDateTimeField)field_out.get((Object)this);
                            ALDateTimeField comeback = (ALDateTimeField)field_come.get((Object)this);
                            outgoing.setValue(new Date(from));
                            comeback.setValue(new Date(to));
                            ++i;
                            from = (Long)map.get("to");
                        }
                        to = max_to;
                        field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                        field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                        ALDateTimeField outgoing = (ALDateTimeField)field_out.get((Object)this);
                        ALDateTimeField aLDateTimeField = (ALDateTimeField)field_come.get((Object)this);
                        outgoing.setValue(new Date(from));
                        aLDateTimeField.setValue(new Date(to));
                        ++i;
                    }
                    while (i <= 5) {
                        field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                        field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                        field_out.set((Object)this, new ALDateTimeField());
                        field_come.set((Object)this, new ALDateTimeField());
                        ++i;
                    }
                }
            }
            this.remarks.validate(msgList);
        }
        catch (RuntimeException ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return msgList.size() == 0;
    }

    private EipTExtTimecard getNearlyAboveRecord(List<EipTExtTimecard> list, int timecard_id) {
        EipTExtTimecard result = null;
        EipTExtTimecard record = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            record = list.get(i);
            if (record.getExtTimecardId() >= timecard_id) {
                return result;
            }
            result = record;
        }
        return null;
    }

    private EipTExtTimecard getNearlyBelowRecord(List<EipTExtTimecard> list, int timecard_id) {
        EipTExtTimecard record = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            record = list.get(i);
            if (record.getExtTimecardId() <= timecard_id) continue;
            return record;
        }
        return null;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        this.setClockOutTime(rundata);
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            if ("update".equals(this.getMode())) {
                try {
                    if (this.entity_id <= 0) {
                        String entity_idstr = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
                        if (entity_idstr == null || entity_idstr.equals("") || Integer.valueOf(entity_idstr) == null) {
                            logger.debug((Object)"[ExtTimecard] Empty entityID...");
                            return false;
                        }
                        this.entity_id = Integer.parseInt(entity_idstr);
                    }
                    if ("".equals(this.type.getValue())) {
                        String type = rundata.getParameters().get("type");
                        this.type.setValue(type);
                    }
                    String punch_date_year = rundata.getParameters().get("punch_date_year");
                    String punch_date_month = rundata.getParameters().get("punch_date_month");
                    String punch_date_day = rundata.getParameters().get("punch_date_day");
                    StringBuffer buffer = new StringBuffer(8);
                    buffer.append(punch_date_year).append('/').append(punch_date_month).append('/').append(punch_date_day);
                    this.punch_date.setValue(buffer.toString());
                }
                catch (Exception e) {
                    logger.error((Object)"exttimecard", (Throwable)e);
                    return false;
                }
            } else if ("new_form".equals(this.getMode())) {
                String session_date = rundata.getParameters().get("date");
                if (session_date != null && !"".equals(session_date)) {
                    this.punch_date.setValue(session_date);
                    this.type.setValue("P");
                }
            } else if ("alt_insert".equals(this.alt_mode)) {
                StringBuffer buffer = new StringBuffer(8);
                String type = rundata.getParameters().get("type");
                String punch_date_year = rundata.getParameters().get("punch_date_year");
                String punch_date_month = rundata.getParameters().get("punch_date_month");
                String punch_date_day = rundata.getParameters().get("punch_date_day");
                buffer.append(punch_date_year).append('/').append(punch_date_month).append('/').append(punch_date_day);
                String reason = rundata.getParameters().get("reason");
                String remarks = rundata.getParameters().get("remarks");
                this.type.setValue(type);
                this.punch_date.setValue(buffer.toString());
                this.reason.setValue(reason);
                this.remarks.setValue(remarks);
            } else {
                ALDateTimeField current_date = new ALDateTimeField();
                current_date.setValue(new Date());
                this.type.setValue("P");
                this.punch_date.setValue(current_date.toString());
            }
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"punch_date", (String)this.punch_date.toString());
        }
        return res;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTExtTimecard timecard = ExtTimecardUtils.getEipTExtTimecard(rundata, context);
            if (timecard == null) {
                return false;
            }
            this.timecard_id.setValue(timecard.getExtTimecardId().longValue());
            this.user_id.setValue((long)timecard.getUserId().intValue());
            this.punch_date.setValue(timecard.getPunchDate());
            this.type.setValue(timecard.getType());
            this.clock_in_time.setValue(timecard.getClockInTime());
            this.clock_out_time.setValue(timecard.getClockOutTime());
            this.outgoing_time1.setValue(timecard.getOutgoingTime1());
            this.outgoing_time2.setValue(timecard.getOutgoingTime2());
            this.outgoing_time3.setValue(timecard.getOutgoingTime3());
            this.outgoing_time4.setValue(timecard.getOutgoingTime4());
            this.outgoing_time5.setValue(timecard.getOutgoingTime5());
            this.comeback_time1.setValue(timecard.getComebackTime1());
            this.comeback_time2.setValue(timecard.getComebackTime2());
            this.comeback_time3.setValue(timecard.getComebackTime3());
            this.comeback_time4.setValue(timecard.getComebackTime4());
            this.comeback_time5.setValue(timecard.getComebackTime5());
            this.reason.setValue(timecard.getReason());
            this.remarks.setValue(timecard.getRemarks());
            this.create_date.setValue(timecard.getCreateDate());
            this.update_date.setValue(timecard.getUpdateDate());
            int rest_num_tmp = 0;
            for (int i = 1; i <= 5; ++i) {
                if (this.getOutgoingTime(i).isNotNullValue()) {
                    ++rest_num_tmp;
                    continue;
                }
                if (!this.getComebackTime(i).isNotNullValue()) continue;
                ++rest_num_tmp;
            }
            this.rest_num.setValue(Integer.toString(rest_num_tmp));
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"punch_date", (String)this.punch_date.getValue().toString());
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        boolean hasOthersInsertAcl = this.aclHandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 4);
        try {
            EipTExtTimecard timecard = (EipTExtTimecard)Database.create(EipTExtTimecard.class);
            if (!"".equals(this.selectedUserId)) {
                if (!hasOthersInsertAcl) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"COMMON_PERMISSION_DENIED"));
                    return false;
                }
                timecard.setUserId(Integer.valueOf(Integer.parseInt(this.selectedUserId)));
            } else {
                timecard.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            }
            Calendar cal = Calendar.getInstance();
            if (this.timecard_system.getChangeHour() > cal.get(11)) {
                cal.add(5, -1);
            }
            timecard.setPunchDate(cal.getTime());
            timecard.setType(this.type.getValue());
            if ("D".equals(this.type.getValue())) {
                timecard.setType("D");
            }
            if (this.edit_mode.equals("punchin")) {
                timecard.setClockInTime(cal.getTime());
            } else if (this.edit_mode.equals("punchout")) {
                timecard.setClockOutTime(cal.getTime());
            } else if (this.edit_mode.equals("outgoing")) {
                timecard.setOutgoingTime1(cal.getTime());
            } else if (this.edit_mode.equals("comeback")) {
                timecard.setComebackTime1(cal.getTime());
            } else {
                timecard.setPunchDate(this.punch_date.getValue());
                if (cal.getTime().after(this.punch_date.getValue())) {
                    if (!"P".equals(this.type.getValue())) {
                        timecard.setClockInTime(null);
                        timecard.setClockOutTime(null);
                        for (int i = 1; i <= 5; ++i) {
                            timecard.setOutgoingTime(null, i);
                            timecard.setComebackTime(null, i);
                        }
                    } else {
                        timecard.setClockInTime(this.clock_in_time.getValue());
                        if (!this.clock_out_time.getDay().isEmpty()) {
                            timecard.setClockOutTime(this.clock_out_time.getValue());
                        }
                        for (int i = 1; i <= 5; ++i) {
                            Field field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                            Field field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                            ALDateTimeField outgoing = (ALDateTimeField)field_out.get((Object)this);
                            ALDateTimeField comeback = (ALDateTimeField)field_come.get((Object)this);
                            if (!outgoing.isNullHour() && !outgoing.isNullMinute()) {
                                timecard.setOutgoingTime(outgoing.getValue(), i);
                            }
                            if (comeback.isNullHour() || comeback.isNullMinute()) continue;
                            timecard.setComebackTime(comeback.getValue(), i);
                        }
                    }
                    timecard.setReason(this.reason.getValue());
                }
                timecard.setRemarks(this.remarks.getValue());
            }
            timecard.setCreateDate(Calendar.getInstance().getTime());
            timecard.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(timecard.getExtTimecardId().intValue(), 310, null);
            return true;
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean hasOthersUpdateAcl = this.aclHandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 8);
        try {
            EipTExtTimecard timecard;
            if (!this.edit_mode.equals("")) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)String.valueOf(this.entity_id));
            }
            if ((timecard = ExtTimecardUtils.getEipTExtTimecard(rundata, context)) == null) {
                return false;
            }
            Integer userId = timecard.getUserId();
            if (this.login_uid != userId && !hasOthersUpdateAcl) {
                msgList.add(ALLocalizationUtils.getl10n((String)"COMMON_PERMISSION_DENIED"));
                return false;
            }
            Calendar cal = Calendar.getInstance();
            if (this.edit_mode.equals("punchin")) {
                timecard.setClockInTime(cal.getTime());
            } else if (this.edit_mode.equals("punchout")) {
                timecard.setClockOutTime(cal.getTime());
            } else if (this.edit_mode.equals("outgoing")) {
                timecard.setNewOutgoingTime(cal.getTime());
            } else if (this.edit_mode.equals("comeback")) {
                timecard.setNewComebackTime(cal.getTime());
            } else {
                timecard.setType(this.type.getValue());
                if ("D".equals(this.type.getValue())) {
                    timecard.setType("D");
                }
                timecard.setReason(this.reason.getValue());
                timecard.setRemarks(this.remarks.getValue());
                if (cal.getTime().after(this.punch_date.getValue())) {
                    if (!"P".equals(this.type.getValue())) {
                        timecard.setClockInTime(null);
                        timecard.setClockOutTime(null);
                        for (int i = 1; i <= 5; ++i) {
                            timecard.setOutgoingTime(null, i);
                            timecard.setComebackTime(null, i);
                        }
                    } else {
                        timecard.setClockInTime(this.clock_in_time.getValue());
                        if (!this.clock_out_time.getHour().equals("") && !this.clock_out_time.getMinute().equals("")) {
                            timecard.setClockOutTime(this.clock_out_time.getValue());
                        } else {
                            timecard.setClockOutTime(null);
                        }
                        for (int i = 1; i <= 5; ++i) {
                            Field field_out = ((Object)((Object)this)).getClass().getDeclaredField("outgoing_time" + i);
                            Field field_come = ((Object)((Object)this)).getClass().getDeclaredField("comeback_time" + i);
                            timecard.setOutgoingTime(null, i);
                            timecard.setComebackTime(null, i);
                            ALDateTimeField outgoing = (ALDateTimeField)field_out.get((Object)this);
                            ALDateTimeField comeback = (ALDateTimeField)field_come.get((Object)this);
                            if (!outgoing.isNullHour() && !outgoing.isNullMinute()) {
                                timecard.setOutgoingTime(outgoing.getValue(), i);
                            }
                            if (comeback.isNullHour() || comeback.isNullMinute()) continue;
                            timecard.setComebackTime(comeback.getValue(), i);
                        }
                    }
                }
            }
            timecard.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(timecard.getExtTimecardId().intValue(), 310, null);
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean doPunch(ALAction action, RunData rundata, Context context, String mode) {
        try {
            this.edit_mode = mode;
            EipTExtTimecard timecard = ExtTimecardUtils.getUpdateEipTExtTimecard(rundata, context);
            this.type.setValue("P");
            if (timecard != null) {
                this.entity_id = timecard.getExtTimecardId();
                super.doUpdate(action, rundata, context);
            } else {
                super.doInsert(action, rundata, context);
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 8 && ("punchin".equals(this.edit_mode) || "punchout".equals(this.edit_mode) || "outgoing".equals(this.edit_mode) || "comeback".equals(this.edit_mode))) {
            defineAclType = 4;
        }
        return super.doCheckAclPermission(rundata, context, defineAclType);
    }

    public ALDateTimeField getPunchDate() {
        return this.punch_date;
    }

    public String getDateStr() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_FORMAT"));
            return sdf.format(this.punch_date.getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean getIsPast() {
        Date now = Calendar.getInstance().getTime();
        Date date = this.punch_date.getValue();
        return date.before(now);
    }

    public boolean getIsToday() {
        int change_hour = ExtTimecardUtils.getEipTExtTimecardSystemByUserId(this.login_uid).getChangeHour();
        Calendar cal = Calendar.getInstance();
        Date date = this.punch_date.getValue();
        boolean is_today = false;
        if (Calendar.getInstance().get(11) < change_hour) {
            Calendar tmp_cal = Calendar.getInstance();
            tmp_cal.set(cal.get(1), cal.get(2), cal.get(5));
            is_today = ExtTimecardUtils.sameDay(date, tmp_cal.getTime());
        } else {
            is_today = ExtTimecardUtils.sameDay(date, cal.getTime());
        }
        return is_today;
    }

    public ALStringField getType() {
        return this.type;
    }

    public ALDateTimeField getClockInTime() {
        return this.clock_in_time;
    }

    public String getClockInTimeHourMinuteText() {
        return ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_HOUR_MINUTE_FORMAT", (Object[])new Object[]{this.clock_in_time.getHour().toString(), this.clock_in_time.getMinute().toString()});
    }

    public ALDateTimeField getClockOutTime() {
        return this.clock_out_time;
    }

    public String getClockOutTimeHourMinuteText() {
        return ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_HOUR_MINUTE_FORMAT", (Object[])new Object[]{this.clock_out_time.getHour().toString(), this.clock_out_time.getMinute().toString()});
    }

    public ALDateTimeField getOutgoingTime(int n) {
        if (n > 5) {
            return null;
        }
        switch (n) {
            case 1: {
                return this.outgoing_time1;
            }
            case 2: {
                return this.outgoing_time2;
            }
            case 3: {
                return this.outgoing_time3;
            }
            case 4: {
                return this.outgoing_time4;
            }
            case 5: {
                return this.outgoing_time5;
            }
        }
        return null;
    }

    public ALDateTimeField getComebackTime(int n) {
        if (n > 5) {
            return null;
        }
        switch (n) {
            case 1: {
                return this.comeback_time1;
            }
            case 2: {
                return this.comeback_time2;
            }
            case 3: {
                return this.comeback_time3;
            }
            case 4: {
                return this.comeback_time4;
            }
            case 5: {
                return this.comeback_time5;
            }
        }
        return null;
    }

    public ALDateTimeField getOutgoingTime2() {
        return this.outgoing_time2;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    public ALStringField getRemarks() {
        return this.remarks;
    }

    public EipTExtTimecardSystem getTimecardSystem() {
        return this.timecard_system;
    }

    private int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date1Hour = cal1.get(10);
        int date1Minute = cal1.get(12);
        int date1Second = cal1.get(13);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        int date2Hour = cal2.get(10);
        int date2Minute = cal2.get(12);
        int date2Second = cal2.get(13);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute && date1Second == date2Second) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    private boolean ajustDate(ALDateTimeField datetime, ALDateTimeField ajustto) {
        if (datetime != null && !datetime.isNullHour() && !datetime.isNullMinute()) {
            Date punch = ajustto.getValue();
            Calendar cal = Calendar.getInstance();
            cal.setTime(punch);
            cal.set(10, Integer.parseInt(datetime.getHour()));
            cal.set(12, Integer.parseInt(datetime.getMinute()));
            cal.set(13, 0);
            if (Integer.parseInt(datetime.getHour()) < this.timecard_system.getChangeHour()) {
                cal.add(5, 1);
            }
            datetime.setValue(cal.getTime());
            return true;
        }
        return false;
    }

    public String getAclPortletFeature() {
        return "timecard_timecard_self";
    }

    public void setAltMode(String alt_mode) {
        this.alt_mode = alt_mode;
    }

    public String getAltMode() {
        return this.alt_mode;
    }

    public int getRestNum() {
        return Integer.parseInt(this.rest_num.getValue());
    }

    public void setClockOutTime(RunData rundata) {
        try {
            Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
            int length = fields.length;
            for (int i = 0; i < length; ++i) {
                fields[i].setAccessible(true);
                String name = fields[i].getName();
                Object obj = fields[i].get((Object)this);
                if (!name.equals("clock_out_time") || !(obj instanceof ALDateTimeField)) continue;
                String hourString = new StringBuffer().append(name).append("_hour").toString();
                String minitusString = new StringBuffer().append(name).append("_minute").toString();
                this.current_clock_out_time_hour = rundata.getParameters().getInt(hourString);
                this.current_clock_out_time_minute = rundata.getParameters().getInt(minitusString);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
        }
    }

    public String getSelectedUserId() {
        return this.selectedUserId;
    }

    private boolean isModify() {
        return !this.old_clock_in_time_hour.equals(this.clock_in_time.getHour()) || !this.old_clock_in_time_minute.equals(this.clock_in_time.getMinute()) || !this.old_clock_out_time_hour.equals(this.clock_out_time.getHour()) || !this.old_clock_out_time_minute.equals(this.clock_out_time.getMinute());
    }

    private boolean isNotFuture() {
        return Calendar.getInstance().getTime().after(this.punch_date.getValue());
    }

    private boolean isNotAtWork() {
        return !"P".equals(this.type.getValue());
    }
}

