/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbKubunResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbItemFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbItemFormData.class.getName());
    private ALStringField gpdb_item_name;
    private ALStringField title_flg;
    private ALStringField required_flg;
    private ALStringField type;
    private ALNumberField gpdb_kubun_id;
    private ALStringField list_flg;
    private ALStringField detail_flg;
    private ALNumberField size_col;
    private ALNumberField size_row;
    private ALNumberField line;
    private ALStringField default_sort_flg;
    private ALStringField asc_desc;
    private String gpdbItemId;
    private String gpdbId;
    private EipTGpdb gpdb;
    private int userId;
    private List<GpdbKubunResultData> allGpdbKubun;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        this.allGpdbKubun = GpdbUtils.getGpdbKubunAllList();
        this.gpdbId = rundata.getParameters().getString("gpdb_id");
        this.gpdb = GpdbUtils.getEipTGpdb(this.gpdbId);
    }

    public void initField() {
        this.gpdb_item_name = new ALStringField();
        this.gpdb_item_name.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_ITEM_NAME"));
        this.gpdb_item_name.setTrim(true);
        this.title_flg = new ALStringField();
        this.title_flg.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_TITLE"));
        this.title_flg.setTrim(false);
        this.title_flg.setValue("f");
        this.required_flg = new ALStringField();
        this.required_flg.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_ESSENTIAL"));
        this.required_flg.setTrim(false);
        this.required_flg.setValue("f");
        this.type = new ALStringField();
        this.type.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_INPUT_FORM"));
        this.type.setTrim(false);
        this.type.setNotNull(true);
        this.gpdb_kubun_id = new ALNumberField();
        this.gpdb_kubun_id.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_SELECTION_ITEMS"));
        this.gpdb_kubun_id.setNotNull(true);
        this.list_flg = new ALStringField();
        this.list_flg.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_DISPLAY_LIST"));
        this.list_flg.setTrim(false);
        this.list_flg.setValue("f");
        this.detail_flg = new ALStringField();
        this.detail_flg.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_DISPLAY_DETAIL_SCREEN1"));
        this.detail_flg.setTrim(false);
        this.detail_flg.setValue("t");
        this.size_col = new ALNumberField();
        this.size_col.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_DISPLAY_SIZE_WIDTH"));
        this.size_col.setNotNull(true);
        this.size_col.limitValue(1L, 999L);
        this.size_row = new ALNumberField();
        this.size_row.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_DISPLAY_SIZE_HEIGHT"));
        this.size_row.setNotNull(true);
        this.size_row.limitValue(1L, 999L);
        this.line = new ALNumberField();
        this.line.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_NUMBER_OF_LINES"));
        this.line.setNotNull(true);
        this.line.limitValue(1L, 99L);
        this.default_sort_flg = new ALStringField();
        this.default_sort_flg.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_SORT"));
        this.default_sort_flg.setTrim(false);
        this.default_sort_flg.setValue("f");
        this.asc_desc = new ALStringField();
        this.asc_desc.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_SORT_ORDER"));
        this.asc_desc.setTrim(false);
    }

    protected void setValidator() {
        this.gpdb_item_name.setNotNull(true);
        this.gpdb_item_name.limitMaxLength(50);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if ("update".equals(this.getMode())) {
                this.gpdbItemId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            this.gpdb_item_name.validate(msgList);
            if (GpdbUtils.DISP_FIELD_SIZE_COL.contains(this.type.getValue())) {
                this.size_col.validate(msgList);
            }
            if (GpdbUtils.DISP_FIELD_SIZE_ROW.contains(this.type.getValue())) {
                this.size_row.validate(msgList);
            }
            if (GpdbUtils.DISP_FIELD_SELECT_ITEM.contains(this.type.getValue())) {
                this.gpdb_kubun_id.validate(msgList);
            }
            if (GpdbUtils.DISP_FIELD_LINE.contains(this.type.getValue())) {
                this.line.validate(msgList);
            }
            if ("t".equals(this.title_flg.getValue())) {
                if (GpdbUtils.DISP_FIELD_REQUIRED.contains(this.type.getValue()) && "f".equals(this.required_flg.getValue())) {
                    msgList.add("\u30bf\u30a4\u30c8\u30eb\u306b\u3059\u308b\u5834\u5408\u3001\u5fc5\u9808\u306b\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                if ("f".equals(this.list_flg.getValue())) {
                    msgList.add("\u30bf\u30a4\u30c8\u30eb\u306b\u3059\u308b\u5834\u5408\u3001\u4e00\u89a7\u753b\u9762\u8868\u793a\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                if ("f".equals(this.detail_flg.getValue())) {
                    msgList.add("\u30bf\u30a4\u30c8\u30eb\u306b\u3059\u308b\u5834\u5408\u3001\u8a73\u7d30\u753b\u9762\u8868\u793a\u3057\u3066\u304f\u3060\u3055\u3044");
                }
            }
            int recordCount = GpdbUtils.getRecordCount(this.gpdbId);
            if ("insert".equals(this.getMode())) {
                if (recordCount > 0 && "t".equals(this.title_flg.getValue())) {
                    msgList.add("\u65e2\u306b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u30bf\u30a4\u30c8\u30eb\u9805\u76ee\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
                }
            } else if ("update".equals(this.getMode())) {
                EipTGpdbItem gpdbItem = GpdbUtils.getEipTGpdbItem(this.gpdbItemId);
                if (gpdbItem == null) {
                    msgList.add("\u66f4\u65b0\u5bfe\u8c61\u306e\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093");
                    return false;
                }
                if ("t".equals(gpdbItem.getTitleFlg()) && "f".equals(this.title_flg.getValue())) {
                    msgList.add("\u30bf\u30a4\u30c8\u30eb\u306f\u89e3\u9664\u3067\u304d\u307e\u305b\u3093\u3002\u4ed6\u306e\u9805\u76ee\u3067\u30bf\u30a4\u30c8\u30eb\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                if (recordCount > 0) {
                    if (!gpdbItem.getTitleFlg().equals(this.title_flg.getValue())) {
                        msgList.add("\u65e2\u306b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u30bf\u30a4\u30c8\u30eb\u9805\u76ee\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                    if (!gpdbItem.getType().equals(this.type.getValue())) {
                        msgList.add("\u65e2\u306b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u5165\u529b\u5f62\u5f0f\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                    if (GpdbUtils.DISP_FIELD_SELECT_ITEM.contains(this.type.getValue()) && (long)gpdbItem.getGpdbKubunId().intValue() != this.gpdb_kubun_id.getValue()) {
                        msgList.add("\u65e2\u306b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u9078\u629e\u9805\u76ee\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTGpdbItem gpdbItem = GpdbUtils.getEipTGpdbItem(rundata, context);
            if (gpdbItem == null) {
                return false;
            }
            this.gpdb_item_name.setValue(gpdbItem.getGpdbItemName());
            this.title_flg.setValue(gpdbItem.getTitleFlg());
            this.type.setValue(gpdbItem.getType());
            this.gpdb_kubun_id.setValue((long)gpdbItem.getGpdb().getGpdbId().intValue());
            this.list_flg.setValue(gpdbItem.getListFlg());
            this.detail_flg.setValue(gpdbItem.getDetailFlg());
            this.default_sort_flg.setValue(gpdbItem.getDefaultSortFlg());
            this.asc_desc.setValue(gpdbItem.getAscDesc());
            if (GpdbUtils.DISP_FIELD_SIZE_COL.contains(this.type.getValue())) {
                this.size_col.setValue((long)gpdbItem.getSizeCol().intValue());
            }
            if (GpdbUtils.DISP_FIELD_SIZE_ROW.contains(this.type.getValue())) {
                this.size_row.setValue((long)gpdbItem.getSizeRow().intValue());
            }
            if (GpdbUtils.DISP_FIELD_SELECT_ITEM.contains(this.type.getValue())) {
                this.gpdb_kubun_id.setValue((long)gpdbItem.getGpdbKubunId().intValue());
            }
            if (GpdbUtils.DISP_FIELD_LINE.contains(this.type.getValue())) {
                this.line.setValue((long)gpdbItem.getLine().intValue());
            }
            if (GpdbUtils.DISP_FIELD_REQUIRED.contains(this.type.getValue())) {
                this.required_flg.setValue(gpdbItem.getRequiredFlg());
            }
            if ("edit_form".equals(this.getMode())) {
                this.gpdbId = rundata.getParameters().getString("gpdb_id");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.userId);
            SelectQuery query = Database.query(EipTGpdbItem.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"gpdb", (Object)this.gpdbId));
            query.orderDesending("orderNo");
            EipTGpdbItem maxOrderItem = (EipTGpdbItem)query.fetchSingle();
            int orderNo = 1;
            if (maxOrderItem != null) {
                orderNo = maxOrderItem.getOrderNo() + 1;
            }
            EipTGpdbItem gpdbItem = (EipTGpdbItem)Database.create(EipTGpdbItem.class);
            gpdbItem.setOrderNo(Integer.valueOf(orderNo));
            gpdbItem.setTurbineUser(tuser);
            gpdbItem.setCreateDate(Calendar.getInstance().getTime());
            gpdbItem.setUpdateDate(Calendar.getInstance().getTime());
            this.setInputForm(rundata, gpdbItem, this.gpdbId);
            List<EipTGpdbRecord> gpdbRecordList = GpdbUtils.getEipTGpdbRecordTitle(this.gpdbId);
            if (gpdbRecordList != null && !gpdbRecordList.isEmpty()) {
                HashSet<Integer> recordNoSet = new HashSet<Integer>();
                for (EipTGpdbRecord record : gpdbRecordList) {
                    ALDateTimeField t;
                    Integer no = record.getRecordNo();
                    if (recordNoSet.contains(no)) continue;
                    recordNoSet.add(no);
                    EipTGpdbRecord gpdbRecord = (EipTGpdbRecord)Database.create(EipTGpdbRecord.class);
                    gpdbRecord.setGpdb(this.gpdb);
                    gpdbRecord.setGpdbItem(gpdbItem);
                    gpdbRecord.setRecordNo(no);
                    gpdbRecord.setTurbineUser(tuser);
                    gpdbRecord.setUpdateUserId(record.getUpdateUserId());
                    gpdbRecord.setCreateDate(Calendar.getInstance().getTime());
                    gpdbRecord.setUpdateDate(Calendar.getInstance().getTime());
                    String type = gpdbItem.getType();
                    if ("08".equals(type)) {
                        gpdbRecord.setValue("" + no);
                        continue;
                    }
                    if ("13".equals(type)) {
                        gpdbRecord.setValue("" + record.getTurbineUser().getUserId());
                        continue;
                    }
                    if ("14".equals(type)) {
                        gpdbRecord.setValue("" + record.getUpdateUserId());
                        continue;
                    }
                    if ("11".equals(type)) {
                        t = new ALDateTimeField();
                        t.setValue(record.getCreateDate());
                        gpdbRecord.setValue(t.toStringDateTime());
                        continue;
                    }
                    if (!"12".equals(type)) continue;
                    t = new ALDateTimeField();
                    t.setValue(record.getUpdateDate());
                    gpdbRecord.setValue(t.toStringDateTime());
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdbItem.getGpdbItemId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + this.gpdb.getGpdbName() + "\u300d \u9805\u76ee\u5b9a\u7fa9 \u300c" + gpdbItem.getGpdbItemName() + "\u300d \u8ffd\u52a0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTGpdbItem gpdbItem = GpdbUtils.getEipTGpdbItem(rundata, context);
            if (gpdbItem == null) {
                return false;
            }
            gpdbItem.setUpdateDate(Calendar.getInstance().getTime());
            this.setInputForm(rundata, gpdbItem, this.gpdbId);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdbItem.getGpdbItemId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + this.gpdb.getGpdbName() + "\u300d \u9805\u76ee\u5b9a\u7fa9 \u300c" + gpdbItem.getGpdbItemName() + "\u300d \u66f4\u65b0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void setInputForm(RunData rundata, EipTGpdbItem gpdbItem, String gpdbId) {
        if ("t".equals(this.title_flg.getValue())) {
            GpdbUtils.gpdbItemTitleOff(this.gpdb);
        }
        gpdbItem.setGpdb(this.gpdb);
        if ("t".equals(this.title_flg.getValue())) {
            GpdbUtils.gpdbItemTitleOff(this.gpdb);
        }
        if ("t".equals(this.default_sort_flg.getValue())) {
            GpdbUtils.gpdbItemDefaultSortOff(this.gpdb);
        }
        gpdbItem.setGpdbItemName(this.gpdb_item_name.getValue());
        gpdbItem.setType(this.type.getValue());
        gpdbItem.setTitleFlg(this.title_flg.getValue());
        gpdbItem.setListFlg(this.list_flg.getValue());
        gpdbItem.setDetailFlg(this.detail_flg.getValue());
        gpdbItem.setDefaultSortFlg(this.default_sort_flg.getValue());
        Integer sizeCol = null;
        Integer sizeRow = null;
        Integer line = null;
        Integer kubunId = null;
        String requiredFlg = "f";
        String ascDesc = this.asc_desc.getValue();
        if (GpdbUtils.DISP_FIELD_SIZE_COL.contains(this.type.getValue())) {
            sizeCol = (int)this.size_col.getValue();
        }
        if (GpdbUtils.DISP_FIELD_SIZE_ROW.contains(this.type.getValue())) {
            sizeRow = (int)this.size_row.getValue();
        }
        if (GpdbUtils.DISP_FIELD_SELECT_ITEM.contains(this.type.getValue())) {
            kubunId = (int)this.gpdb_kubun_id.getValue();
        }
        if (GpdbUtils.DISP_FIELD_LINE.contains(this.type.getValue())) {
            line = (int)this.line.getValue();
        }
        if (GpdbUtils.DISP_FIELD_REQUIRED.contains(this.type.getValue())) {
            requiredFlg = this.required_flg.getValue();
        }
        if ("f".equals(this.default_sort_flg.getValue())) {
            ascDesc = "";
        }
        gpdbItem.setSizeCol(sizeCol);
        gpdbItem.setSizeRow(sizeRow);
        gpdbItem.setLine(line);
        gpdbItem.setGpdbKubunId(kubunId);
        gpdbItem.setRequiredFlg(requiredFlg);
        gpdbItem.setAscDesc(ascDesc);
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTGpdbItem gpdbItem = GpdbUtils.getEipTGpdbItem(rundata, context);
            if (gpdbItem == null) {
                return false;
            }
            if ("t".equals(gpdbItem.getTitleFlg())) {
                msgList.add("\u30bf\u30a4\u30c8\u30eb\u6307\u5b9a\u3055\u308c\u305f\u9805\u76ee\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            GpdbUtils.removeGpdbRecord(rundata, gpdbItem);
            Database.delete((Persistent)gpdbItem);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdbItem.getGpdbItemId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + this.gpdb.getGpdbName() + "\u300d \u9805\u76ee\u5b9a\u7fa9 \u300c" + gpdbItem.getGpdbItemName() + "\u300d \u524a\u9664");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getGpdbItemName() {
        return this.gpdb_item_name;
    }

    public ALStringField getTitleFlg() {
        return this.title_flg;
    }

    public ALStringField getRequiredFlg() {
        return this.required_flg;
    }

    public ALStringField getType() {
        return this.type;
    }

    public ALNumberField getGpdbKubunId() {
        return this.gpdb_kubun_id;
    }

    public ALStringField getListFlg() {
        return this.list_flg;
    }

    public ALStringField getDetailFlg() {
        return this.detail_flg;
    }

    public ALNumberField getSizeCol() {
        return this.size_col;
    }

    public ALNumberField getSizeRow() {
        return this.size_row;
    }

    public ALNumberField getLine() {
        return this.line;
    }

    public ALStringField getDefaultSortFlg() {
        return this.default_sort_flg;
    }

    public ALStringField getAscDesc() {
        return this.asc_desc;
    }

    public Map<String, String> getGpdbTypeMap() {
        return GpdbUtils.ITEM_TYPE;
    }

    public List<GpdbKubunResultData> getAllGpdbKubun() {
        return this.allGpdbKubun;
    }

    public String getGpdbId() {
        return this.gpdbId;
    }

    public boolean displayField(String field, String type) {
        return GpdbUtils.dipslayField(field, type);
    }

    public EipTGpdb getGpdb() {
        return this.gpdb;
    }
}

