/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.io.CharCodeConverter;
import com.sk_jp.io.UnicodeCorrector;
import com.sk_jp.mail.JISDataSource;
import com.sk_jp.mail.MapByMessage;
import com.sk_jp.text.EntityRefEncoder;
import com.sk_jp.text.TextFormatter;
import com.sk_jp.util.StringValues;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.QDecoderStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MailUtility {
    private static MailDateFormat mailDateFormat = new MailDateFormat();

    public static String getPersonal(InternetAddress internetAddress) {
        if (internetAddress.getPersonal() != null) {
            return internetAddress.getPersonal();
        }
        return internetAddress.toString();
    }

    public static String getMailAddresses(InternetAddress[] internetAddressArray) {
        if (internetAddressArray == null) {
            return null;
        }
        StringValues stringValues = new StringValues();
        for (int i = 0; i < internetAddressArray.length; ++i) {
            stringValues.add(internetAddressArray[i].getAddress());
        }
        return stringValues.getString();
    }

    public static String getPersonalNames(InternetAddress[] internetAddressArray) {
        if (internetAddressArray == null) {
            return null;
        }
        StringValues stringValues = new StringValues();
        for (int i = 0; i < internetAddressArray.length; ++i) {
            String string = MailUtility.decodeText(MailUtility.unfold(internetAddressArray[i].getPersonal()));
            if (string == null) {
                string = internetAddressArray[i].toString();
            }
            stringValues.add(string);
        }
        return stringValues.getString();
    }

    public static String getAddressesHTML(InternetAddress[] internetAddressArray) {
        if (internetAddressArray == null) {
            return null;
        }
        StringValues stringValues = new StringValues();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < internetAddressArray.length; ++i) {
            stringBuffer.append("<a href=\"mailto:");
            stringBuffer.append(internetAddressArray[i].getAddress());
            stringBuffer.append("\">");
            String string = internetAddressArray[i].getPersonal();
            if (string != null) {
                string = MailUtility.decodeText(string);
            }
            if (string == null) {
                string = internetAddressArray[i].toString();
            }
            stringBuffer.append(EntityRefEncoder.encode((String)string));
            stringBuffer.append("</a>");
            stringValues.add(new String(stringBuffer));
            stringBuffer.setLength(0);
        }
        return stringValues.getString();
    }

    public static String getTransferEncoding(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 0) continue;
            ++n;
        }
        if (n == 0) {
            return "7bit";
        }
        if (n < byArray.length - n) {
            return "quoted-printable";
        }
        return "base64";
    }

    public static Message getParentMessage(Part part) {
        Part part2 = part;
        while (!(part2 instanceof Message)) {
            Multipart multipart = ((BodyPart)part2).getParent();
            if (multipart == null) {
                return null;
            }
            part2 = multipart.getParent();
            if (part2 != null) continue;
            return null;
        }
        return (Message)part2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.indexOf(" JST") == -1 || string.indexOf(43) >= 0) {
                MailDateFormat mailDateFormat = MailUtility.mailDateFormat;
                synchronized (mailDateFormat) {
                    return MailUtility.mailDateFormat.parse(string);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, string.indexOf("JST")));
            stringBuffer.append("+0900");
            MailDateFormat mailDateFormat = MailUtility.mailDateFormat;
            synchronized (mailDateFormat) {
                return MailUtility.mailDateFormat.parse(new String(stringBuffer));
            }
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public static String createReplySubject(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "Re: (no subject)";
        }
        String string2 = string;
        if (string2.charAt(0) == '[' && string2.indexOf(93) > 0) {
            n = MailUtility.indexOfNonLWSP(string2, string2.indexOf(93) + 1, false);
            string2 = n < 0 ? "" : string2.substring(n);
        }
        if (string2.length() > 3 && "Re:".equalsIgnoreCase(string2.substring(0, 3))) {
            n = MailUtility.indexOfNonLWSP(string2, 3, false);
            string2 = n < 0 ? "" : string2.substring(n);
        }
        return "Re: " + string2;
    }

    public static String createReplyContent(MimeMessage mimeMessage) {
        return MailUtility.createReplyContent(mimeMessage, "In article @##message_id@\r\n@##fromname@ wrote:\r\n", ">", -1);
    }

    public static String createReplyContent(MimeMessage mimeMessage, String string, String string2, int n) {
        if (n == 0) {
            n = Integer.MAX_VALUE;
        } else if (n < 0) {
            n = 76;
        }
        MapByMessage mapByMessage = new MapByMessage(mimeMessage);
        StringBuffer stringBuffer = new StringBuffer();
        TextFormatter textFormatter = new TextFormatter();
        textFormatter.setSource(string);
        stringBuffer.append(textFormatter.format((Map)mapByMessage));
        String string3 = (String)mapByMessage.get("content");
        if (string3 == null) {
            return new String(stringBuffer);
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        n -= string2.length();
        try {
            String string4;
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                while (string4.length() > n) {
                    stringBuffer.append(string4.substring(0, n)).append("\r\n");
                    string4 = string4.substring(n);
                    stringBuffer.append(string2);
                }
                stringBuffer.append(string4).append("\r\n");
            }
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
        return new String(stringBuffer);
    }

    public static InternetAddress[] parseAddresses(String string) throws AddressException {
        return MailUtility.parseAddresses(string, true);
    }

    public static InternetAddress[] parseAddresses(String string, boolean bl) throws AddressException {
        if (string == null) {
            return null;
        }
        try {
            InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)bl);
            for (int i = 0; i < internetAddressArray.length; ++i) {
                internetAddressArray[i].setPersonal(internetAddressArray[i].getPersonal(), "ISO-2022-JP");
            }
            return internetAddressArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public static String unfold(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (MailUtility.isLWSP(c)) continue;
                bl = false;
            }
            if (c != '\r' && c != '\n') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
            bl = true;
        }
        return new String(stringBuffer);
    }

    public static String fold(String string, int n) {
        int n2;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string;
        while (string2.length() > 76 && (n2 = string2.lastIndexOf(32, 76)) != -1) {
            stringBuffer.append(string2.substring(0, n2));
            stringBuffer.append("\r\n");
            string2 = string2.substring(n2);
        }
        stringBuffer.append(string2);
        return new String(stringBuffer);
    }

    public static void setTextContent(Part part, String string) throws MessagingException {
        part.setDataHandler(new DataHandler((DataSource)new JISDataSource(string)));
        part.setHeader("Content-Transfer-Encoding", "7bit");
    }

    public static String encodeWordJIS(String string) {
        try {
            return "=?ISO-2022-JP?B?" + new String(BASE64EncoderStream.encode((byte[])CharCodeConverter.sjisToJis((byte[])UnicodeCorrector.getInstance((String)"Windows-31J").correct(string).getBytes("Windows-31J")))) + "?=";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static String decodeText(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(27) >= 0) {
            try {
                return new String(string.getBytes("ISO-8859-1"), "ISO-2022-JP");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError();
            }
        }
        String string2 = new RFC2047Decoder(string).get();
        if (string2.indexOf(27) >= 0) {
            try {
                return new String(string2.getBytes("ISO-8859-1"), "ISO-2022-JP");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError();
            }
        }
        return string2;
    }

    private static byte[] decodeByTES(String string, String string2) {
        int n;
        while ((n = MailUtility.indexOfLWSP(string, 0, false, '\u0000')) >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        if (string2.equalsIgnoreCase("B") && string.length() % 4 != 0) {
            switch (4 - string.length() % 4) {
                case 1: {
                    string = string + '=';
                    break;
                }
                case 2: {
                    string = string + "==";
                    break;
                }
                case 3: {
                    string = string.charAt(string.length() - 1) != '=' ? string + "===" : string.substring(0, string.length() - 1);
                }
            }
        }
        try {
            BASE64DecoderStream bASE64DecoderStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ASCIIUtility.getBytes((String)string));
            if (string2.equalsIgnoreCase("B")) {
                bASE64DecoderStream = new BASE64DecoderStream((InputStream)byteArrayInputStream);
            } else if (string2.equalsIgnoreCase("Q")) {
                bASE64DecoderStream = new QDecoderStream((InputStream)byteArrayInputStream);
            } else {
                throw new UnsupportedEncodingException(string2);
            }
            int n2 = byteArrayInputStream.available();
            byte[] byArray = new byte[n2];
            n2 = bASE64DecoderStream.read(byArray, 0, n2);
            if (n2 != byArray.length) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static String encodeText(String string, String string2, String string3) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            int n3;
            if ((n3 = MailUtility.indexOfNonAscii(string, n)) == -1) {
                stringBuffer.append(string.substring(n));
                return new String(stringBuffer);
            }
            int n4 = MailUtility.indexOfLWSP(string, n3, true, '(');
            int n5 = MailUtility.indexOfNonLWSP(string, n4, true) + 1;
            int n6 = n5 = n > n5 ? n : n5;
            if (n5 > n) {
                stringBuffer.append(string.substring(n, n5));
                if (MailUtility.isLWSP(string.charAt(n5))) {
                    stringBuffer.append("\r\n ");
                    ++n5;
                }
            }
            n = MailUtility.indexOfNonLWSP(string, n3, false);
            while ((n = MailUtility.indexOfLWSP(string, n, false, ')')) != -1) {
                n2 = MailUtility.indexOfLWSP(string, n = MailUtility.indexOfNonLWSP(string, n, false), false, '\u0000');
                if (n2 == -1) {
                    if (MailUtility.indexOfNonAscii(string, n) == -1) break;
                    n = -1;
                    break;
                }
                int n7 = MailUtility.indexOfNonAscii(string, n);
                if (n7 == -1 || n7 >= n2) break;
                n = n2;
            }
            n2 = 0;
            if (n < 0) {
                n = string.length();
            } else if (MailUtility.isLWSP(string.charAt(n - 1))) {
                --n;
                n2 = 1;
            }
            String string4 = string.substring(n5, n);
            stringBuffer.append(MimeUtility.encodeWord((String)string4, (String)string2, (String)string3));
            if (n2 == 0) continue;
            ++n;
            stringBuffer.append("\r\n ");
        }
    }

    public static int indexOfNonAscii(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNonLWSP(String string, int n, boolean bl) {
        int n2 = 1;
        if (bl) {
            n2 = -1;
        }
        for (int i = n; i >= 0 && i < string.length(); i += n2) {
            char c = string.charAt(i);
            if (MailUtility.isLWSP(c)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfLWSP(String string, int n, boolean bl, char c) {
        int n2 = 1;
        if (bl) {
            n2 = -1;
        }
        for (int i = n; i >= 0 && i < string.length(); i += n2) {
            char c2 = string.charAt(i);
            if (!MailUtility.isLWSP(c2) && c2 != c) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLWSP(char c) {
        return c == '\r' || c == '\n' || c == ' ' || c == '\t';
    }

    public static void setFileName(Part part, String string, String string2, String string3) throws MessagingException {
        ContentDisposition contentDisposition;
        String[] stringArray = part.getHeader("Content-Disposition");
        if (stringArray == null || stringArray.length < 1) {
            contentDisposition = new ContentDisposition("attachment");
        } else {
            contentDisposition = new ContentDisposition(stringArray[0]);
            contentDisposition.getParameterList().remove("filename");
        }
        part.setHeader("Content-Disposition", contentDisposition.toString() + MailUtility.encodeParameter("filename", string, string2, string3));
        stringArray = part.getHeader("Content-Type");
        ContentType contentType = stringArray == null || stringArray.length < 1 ? new ContentType(part.getDataHandler().getContentType()) : new ContentType(stringArray[0]);
        try {
            int n;
            String string4 = MimeUtility.encodeWord((String)string, (String)string2, (String)"B");
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = string4.indexOf(13)) != -1) {
                stringBuffer.append(string4.substring(0, n));
                string4 = string4.substring(n + 2);
            }
            stringBuffer.append(string4);
            contentType.setParameter("name", new String(stringBuffer));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", (Exception)unsupportedEncodingException);
        }
        part.setHeader("Content-Type", contentType.toString());
    }

    public static String encodeParameter(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = !MailUtility.isAllAscii(string2);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (string2.length() > 0) {
            boolean bl4;
            int n2;
            boolean bl5 = string2.charAt(0) < '\u0080';
            for (n2 = 1; n2 < string2.length() && !(string2.charAt(n2) < '\u0080' ? !bl5 : bl5); ++n2) {
            }
            if (n2 != string2.length()) {
                bl3 = true;
            }
            block4: while (true) {
                byte[] byArray;
                stringBuffer2.setLength(0);
                String string5 = string2.substring(0, n2);
                try {
                    byArray = bl5 ? string5.getBytes("us-ascii") : string5.getBytes(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string5.getBytes();
                    string3 = MimeUtility.mimeCharset((String)MimeUtility.getDefaultJavaCharset());
                }
                bl4 = false;
                int n3 = string.length() + 7;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] >= 48 && byArray[i] <= 57 || byArray[i] >= 65 && byArray[i] <= 90 || byArray[i] >= 97 && byArray[i] <= 122 || byArray[i] == 36 || byArray[i] == 46 || byArray[i] == 33) {
                        stringBuffer2.append((char)byArray[i]);
                        ++n3;
                    } else {
                        bl4 = true;
                        stringBuffer2.append('%');
                        String string6 = Integer.toString(byArray[i] & 0xFF, 16);
                        if (string6.length() == 1) {
                            stringBuffer2.append('0');
                        }
                        stringBuffer2.append(string6);
                        n3 += 3;
                    }
                    if (n3 <= 76) continue;
                    bl3 = true;
                    n2 /= 2;
                    continue block4;
                }
                break;
            }
            stringBuffer.append(";\r\n ").append(string);
            if (bl3) {
                stringBuffer.append('*').append(n);
                ++n;
            }
            if (!bl2 && bl) {
                stringBuffer.append("*=");
                bl2 = true;
                stringBuffer.append(string3).append('\'');
                if (string4 != null) {
                    stringBuffer.append(string4);
                }
                stringBuffer.append('\'');
            } else if (bl4) {
                stringBuffer.append("*=");
            } else {
                stringBuffer.append('=');
            }
            stringBuffer.append(new String(stringBuffer2));
            string2 = string2.substring(n2);
        }
        return new String(stringBuffer);
    }

    public static boolean isAllAscii(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static String getFileName(Part part) throws MessagingException {
        String string;
        String[] stringArray = part.getHeader("Content-Disposition");
        if (stringArray == null || stringArray.length < 1 || (string = MailUtility.getParameter(stringArray[0], "filename")) == null) {
            string = part.getFileName();
            if (string != null) {
                return MailUtility.decodeParameterSpciallyJapanese(string);
            }
            return null;
        }
        return string;
    }

    public static String getParameter(String string, String string2) throws ParseException {
        if (string == null) {
            return null;
        }
        string = MailUtility.decodeParameterSpciallyJapanese(string);
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, ";=\t ", true);
        StringBuffer stringBuffer = new StringBuffer();
        Encoding encoding = new Encoding();
        try {
            HeaderTokenizer.Token token;
            while ((token = headerTokenizer.next()).getType() != -4) {
                if (token.getType() != 59) continue;
                token = headerTokenizer.next();
                MailUtility.checkType(token);
                String string3 = token.getValue();
                token = headerTokenizer.next();
                if (token.getType() != 61) {
                    throw new ParseException("Illegal token : " + token.getValue());
                }
                token = headerTokenizer.next();
                MailUtility.checkType(token);
                String string4 = token.getValue();
                if (string3.equalsIgnoreCase(string2)) {
                    return string4;
                }
                int n = string2.length();
                if (!string3.startsWith(string2) || string3.charAt(n) != '*') continue;
                int n2 = string3.length() - 1;
                if (string3.charAt(n2) == '*') {
                    if (n == n2 || string3.charAt(n + 1) == '0') {
                        stringBuffer.append(MailUtility.decodeRFC2231(string4, encoding, true));
                    } else {
                        stringBuffer.append(MailUtility.decodeRFC2231(string4, encoding, false));
                    }
                } else {
                    stringBuffer.append(string4);
                }
                if (n != n2) continue;
            }
            if (stringBuffer.length() == 0) {
                return null;
            }
            return new String(stringBuffer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException(unsupportedEncodingException.toString());
        }
    }

    private static void checkType(HeaderTokenizer.Token token) throws ParseException {
        int n = token.getType();
        if (n != -1 && n != -2) {
            throw new ParseException("Illegal token : " + token.getValue());
        }
    }

    private static String decodeRFC2231(String string, Encoding encoding, boolean bl) throws ParseException, UnsupportedEncodingException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (bl && (n = string.indexOf(39)) > 0) {
            encoding.encoding = string.substring(0, n);
            if ((n2 = string.indexOf(39, ++n)) < 0) {
                throw new ParseException("lang tag area was missing.");
            }
            encoding.lang = string.substring(n, n2);
            ++n2;
        }
        try {
            while (n2 < string.length()) {
                if (string.charAt(n2) == '%') {
                    stringBuffer.append((char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16));
                    n2 += 2;
                } else {
                    stringBuffer.append(string.charAt(n2));
                }
                ++n2;
            }
            return new String(new String(stringBuffer).getBytes("ISO-8859-1"), encoding.encoding);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException(string + " :: this string were not decoded.");
        }
    }

    private static String decodeParameterSpciallyJapanese(String string) throws ParseException {
        try {
            string = new String(string.getBytes("ISO-8859-1"), "JISAutoDetect");
            return MailUtility.decodeText(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException("Unsupported Encoding");
        }
    }

    private MailUtility() {
    }

    static class Encoding {
        String encoding = "us-ascii";
        String lang = "";

        Encoding() {
        }
    }

    static class RFC2047Decoder {
        private String source;
        private String pooledCES;
        private byte[] pooledBytes;
        private StringBuffer buf;
        private int pos = 0;
        private int startIndex;
        private int endIndex;

        public RFC2047Decoder(String string) {
            this.source = string;
            this.buf = new StringBuffer(string.length());
            this.parse();
        }

        private void parse() {
            while (this.hasEncodedWord()) {
                String string = this.source.substring(this.pos, this.startIndex);
                if (MailUtility.indexOfNonLWSP(string, 0, false) > -1) {
                    this.sweepPooledBytes();
                    this.buf.append(string);
                }
                this.parseWord();
            }
            this.sweepPooledBytes();
            this.buf.append(this.source.substring(this.pos));
        }

        private boolean hasEncodedWord() {
            this.startIndex = this.source.indexOf("=?", this.pos);
            if (this.startIndex == -1) {
                return false;
            }
            this.endIndex = this.source.indexOf("?=", this.startIndex + 2);
            if (this.endIndex == -1) {
                return false;
            }
            this.endIndex += 2;
            return true;
        }

        private void parseWord() {
            try {
                int n = this.startIndex + 2;
                int n2 = this.source.indexOf(63, n);
                if (n2 == this.endIndex - 2) {
                    throw new RuntimeException();
                }
                String string = this.source.substring(n, n2);
                try {
                    "".getBytes(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = "JISAutoDetect";
                }
                n = n2 + 1;
                n2 = this.source.indexOf(63, n);
                if (n2 == this.endIndex - 2) {
                    throw new RuntimeException();
                }
                String string2 = this.source.substring(n, n2);
                byte[] byArray = MailUtility.decodeByTES(this.source.substring(n2 + 1, this.endIndex - 2), string2);
                if (string.equals(this.pooledCES)) {
                    byte[] byArray2 = new byte[this.pooledBytes.length + byArray.length];
                    System.arraycopy(this.pooledBytes, 0, byArray2, 0, this.pooledBytes.length);
                    System.arraycopy(byArray, 0, byArray2, this.pooledBytes.length, byArray.length);
                    this.pooledBytes = byArray2;
                } else {
                    this.sweepPooledBytes();
                    this.pooledCES = string;
                    this.pooledBytes = byArray;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.buf.append(this.source.substring(this.startIndex, this.endIndex));
            }
            this.pos = this.endIndex;
        }

        private void sweepPooledBytes() {
            if (this.pooledBytes == null) {
                return;
            }
            try {
                this.buf.append(new String(this.pooledBytes, this.pooledCES));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("CANT HAPPEN: Illegal encoding = " + this.pooledCES);
            }
            this.pooledCES = null;
            this.pooledBytes = null;
        }

        public String get() {
            return new String(this.buf);
        }
    }
}

