/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;

public class SimpleRetriever {
    private Store store;
    private Folder currentFolder = null;
    private boolean writable = false;

    public SimpleRetriever(String string) throws NoSuchProviderException {
        Session session = Session.getInstance((Properties)new Properties(), null);
        session.setDebug(Boolean.getBoolean("mail.debug"));
        this.store = session.getStore(string);
    }

    public void connect(String string, String string2, String string3) throws MessagingException {
        this.connect(string, -1, string2, string3);
    }

    public synchronized void connect(String string, int n, String string2, String string3) throws MessagingException {
        this.store.connect(string, n, string2, string3);
    }

    public synchronized void disconnect() {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            try {
                this.currentFolder.close(true);
            }
            catch (MessagingException messagingException) {
                messagingException.printStackTrace();
            }
            this.currentFolder = null;
        }
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
    }

    public synchronized void setWritable(boolean bl) {
        this.writable = bl;
    }

    public synchronized void setCurrentFolder(String string) throws MessagingException {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            this.currentFolder.close(true);
        }
        this.currentFolder = this.store.getFolder(string);
        if (this.currentFolder == null) {
            throw new FolderNotFoundException();
        }
        if (this.writable) {
            this.currentFolder.open(2);
        } else {
            this.currentFolder.open(1);
        }
    }

    public synchronized MimeMessage[] get() throws MessagingException {
        if (this.currentFolder == null) {
            this.setCurrentFolder("INBOX");
        }
        Message[] messageArray = this.currentFolder.getMessages();
        MimeMessage[] mimeMessageArray = new MimeMessage[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            mimeMessageArray[i] = (MimeMessage)messageArray[i];
        }
        return mimeMessageArray;
    }

    public synchronized MimeMessage get(int n) throws MessagingException {
        if (this.currentFolder == null) {
            this.setCurrentFolder("INBOX");
        }
        try {
            return (MimeMessage)this.currentFolder.getMessage(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new MessagingException("Message number out of bounds", (Exception)indexOutOfBoundsException);
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        SimpleRetriever simpleRetriever = new SimpleRetriever(string);
        simpleRetriever.setWritable(true);
        simpleRetriever.connect(string2, string3, string4);
        MimeMessage[] mimeMessageArray = simpleRetriever.get();
        System.out.println("******************* Recieved: " + mimeMessageArray.length);
        for (int i = 0; i < mimeMessageArray.length; ++i) {
            mimeMessageArray[i].setFlags(new Flags(Flags.Flag.DELETED), true);
            System.out.println("*******************" + mimeMessageArray[i].isSet(Flags.Flag.DELETED));
        }
        simpleRetriever.disconnect();
    }
}

