/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFileMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFileMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTCabinetFile.class);
            Expression exp = ExpressionFactory.inDbExp((String)"FILE_ID", values);
            query.setQualifier(exp);
            List filelist = query.fetchList();
            if (filelist == null || filelist.size() == 0) {
                return false;
            }
            for (int i = 0; i < filelist.size(); ++i) {
                if (!CabinetUtils.isEditableFolder(((EipTCabinetFile)filelist.get(i)).getFolderId(), rundata)) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"CABINET_DONOT_AUTHORITY_FILE"));
                    return false;
                }
                ArrayList<String> fpaths = new ArrayList<String>();
                for (i = 0; i < filelist.size(); ++i) {
                    EipTCabinetFile cabinetfile = (EipTCabinetFile)filelist.get(i);
                    fpaths.add(cabinetfile.getFilePath());
                }
                int filelistsize = filelist.size();
                for (i = 0; i < filelistsize; ++i) {
                    EipTCabinetFile file = (EipTCabinetFile)filelist.get(i);
                    Integer entityId = file.getFileId();
                    String fileName = file.getFileTitle();
                    Database.delete((Persistent)file);
                    Database.commit();
                    ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 220, fileName);
                }
                int fpathSize = fpaths.size();
                if (fpathSize <= 0) continue;
                String orgId = Database.getDomainName();
                for (i = 0; i < fpathSize; ++i) {
                    ALStorageService.deleteFile((String)(CabinetUtils.getSaveDirPath(orgId) + (String)fpaths.get(i)));
                }
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }
}

