/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om;

import java.util.HashMap;
import java.util.Map;
import org.apache.turbine.om.RetrieverFactory;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.pool.Recyclable;

public class OMTool
implements ApplicationTool,
Recyclable {
    private HashMap omMap = new HashMap();
    private static Map pullMap = new HashMap();
    private RetrieverFactory omFactory;
    private boolean disposed;

    public OMTool() throws Exception {
        String string = TurbineResources.getString("tool.om.factory");
    }

    public void init(Object runData) {
    }

    public void refresh() {
    }

    public Object get(String omName) throws Exception {
        if (!pullMap.containsKey(omName)) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                pullMap.put(omName, new PullHelper(omName));
            }
        }
        return pullMap.get(omName);
    }

    public Object get(String omName, String key) throws Exception {
        return ((PullHelper)this.get(omName)).setKey(key);
    }

    public String getName() {
        return "om";
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        this.omMap.clear();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private class PullHelper {
        String omName;

        private PullHelper(String omName) {
            this.omName = omName;
        }

        public Object setKey(String key) throws Exception {
            Object om = null;
            String inputKey = this.omName + key;
            if (OMTool.this.omMap.containsKey(inputKey)) {
                om = OMTool.this.omMap.get(inputKey);
            } else {
                om = OMTool.this.omFactory.getInstance(this.omName).retrieve(key);
                OMTool.this.omMap.put(inputKey, om);
            }
            return om;
        }
    }
}

