/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.castor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.castor.CastorService;
import org.apache.turbine.util.Log;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.JDO;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class TurbineCastorService
extends TurbineBaseService
implements CastorService {
    private String databasename = null;
    private String databasefile = null;
    private PrintWriter logger = null;
    private JDO jdo = null;

    public void init() throws InitializationException {
        try {
            this.initCastor();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineCastorService failed to initalize", e);
        }
    }

    private void initCastor() throws IOException, MappingException, Exception {
        Configuration conf = this.getConfiguration();
        String logprefix = conf.getString("logprefix", "TurbineCastor");
        String logfile = conf.getString("logfile");
        if (logfile == null) {
            Log.warn("CastorService no LogFile property specified");
        } else {
            this.logger = new Logger((Writer)new FileWriter(logfile)).setPrefix(logprefix);
        }
        this.databasename = conf.getString("databasename");
        if (this.databasename == null) {
            throw new Exception("TurbineCastor: missing databasename propertiy");
        }
        this.databasefile = conf.getString("databasefile");
        if (this.databasefile == null) {
            throw new Exception("TurbineCastor: missing databasefile propertiy");
        }
        JDO.loadConfiguration((InputSource)new InputSource(this.databasefile), (EntityResolver)new LocalResolver(this.databasefile, this.logger), (ClassLoader)this.getClass().getClassLoader());
    }

    public PrintWriter getCastorLogger() {
        return this.logger;
    }

    public JDO getJDO() {
        if (this.jdo == null) {
            this.jdo = new JDO(this.databasename);
            this.jdo.setLogWriter(this.logger);
        }
        return this.jdo;
    }

    public Database getDatabase() throws DatabaseNotFoundException, PersistenceException {
        return this.getJDO().getDatabase();
    }

    private class LocalResolver
    implements EntityResolver {
        private String prefix = "unknown";
        private PrintWriter logger = null;

        public LocalResolver(String databasefile, PrintWriter logger) {
            int i = databasefile.lastIndexOf(File.separator);
            this.prefix = databasefile.substring(0, i + 1);
            this.logger = logger;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws FileNotFoundException {
            return new InputSource(new FileReader(this.prefix + systemId));
        }
    }
}

