/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.turbine.om.OMTool;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.intake.IntakeService;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.transform.XmlToAppData;
import org.apache.turbine.services.intake.xmlmodel.AppData;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ServletUtils;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.pool.BoundedBuffer;
import org.apache.turbine.util.pool.Recyclable;

public class TurbineIntakeService
extends TurbineBaseService
implements IntakeService {
    private String[] groupNames;
    private Map groupNameMap;
    private Map groupKeyMap;
    private Map getterMap;
    private Map setterMap;
    private OMTool omTool;
    private AppData appData;
    private HashMap poolRepository = new HashMap();
    private static final int GETTER = 0;
    private static final int SETTER = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(ServletConfig config) throws InitializationException {
        Properties props = this.getProperties();
        String xmlPath = props.getProperty("xml.path");
        if (xmlPath == null) {
            String pathError = "Path to intake.xml was not specified.  Check that the property exists in TR.props and was loaded.";
            Log.error(pathError);
            throw new InitializationException(pathError);
        }
        String appDataPath = "/WEB-INF/appData.ser";
        try {
            block14: {
                xmlPath = ServletUtils.expandRelative(config, xmlPath);
                appDataPath = ServletUtils.expandRelative(config, appDataPath);
                File serialAppData = new File(appDataPath);
                File xmlFile = new File(xmlPath);
                if (serialAppData.exists() && serialAppData.lastModified() > xmlFile.lastModified()) {
                    FileInputStream in = null;
                    try {
                        Object var10_12;
                        try {
                            in = new FileInputStream(serialAppData);
                            ObjectInputStream p = new ObjectInputStream(in);
                            this.appData = (AppData)p.readObject();
                        }
                        catch (Exception e) {
                            this.writeAppData(xmlPath, appDataPath, serialAppData);
                            var10_12 = null;
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            break block14;
                        }
                        var10_12 = null;
                        if (in == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (in == null) throw throwable;
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    ((InputStream)in).close();
                } else {
                    this.writeAppData(xmlPath, appDataPath, serialAppData);
                }
            }
            this.groupNames = new String[this.appData.getGroups().size()];
            this.groupKeyMap = new HashMap();
            this.groupNameMap = new HashMap();
            this.getterMap = new HashMap();
            this.setterMap = new HashMap();
            String pkg = this.appData.getBasePackage();
            List glist = this.appData.getGroups();
            int i = glist.size() - 1;
            block6: while (true) {
                String groupName;
                if (i < 0) {
                    this.setInit(true);
                    return;
                }
                XmlGroup g = (XmlGroup)glist.get(i);
                this.groupNames[i] = groupName = g.getName();
                this.groupKeyMap.put(groupName, g.getKey());
                this.groupNameMap.put(g.getKey(), groupName);
                List classNames = g.getMapToObjects();
                Iterator iter2 = classNames.iterator();
                while (true) {
                    if (!iter2.hasNext()) {
                        --i;
                        continue block6;
                    }
                    String className = (String)iter2.next();
                    if (this.getterMap.containsKey(className)) continue;
                    this.getterMap.put(className, new HashMap());
                    this.setterMap.put(className, new HashMap());
                }
                break;
            }
        }
        catch (Exception e) {
            throw new InitializationException("TurbineIntakeService failed to initialize", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAppData(String xmlPath, String appDataPath, File serialAppData) throws Exception {
        InputStream in;
        block7: {
            XmlToAppData xmlApp = new XmlToAppData();
            this.appData = xmlApp.parseFile(xmlPath);
            FileOutputStream out = null;
            in = null;
            try {
                try {
                    out = new FileOutputStream(serialAppData);
                    ObjectOutputStream p = new ObjectOutputStream(out);
                    p.writeObject(this.appData);
                    p.flush();
                    in = new FileInputStream(serialAppData);
                    ObjectInputStream pin = new ObjectInputStream(in);
                    this.appData = (AppData)pin.readObject();
                }
                catch (Exception e) {
                    Log.info("Intake initialization could not be serialized because writing to " + appDataPath + " was not " + "allowed.  This will require that the xml file be " + "parsed when restarting the application.");
                    Object var10_11 = null;
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (in == null) return;
                    in.close();
                    return;
                }
                Object var10_10 = null;
                if (out == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            ((OutputStream)out).close();
        }
        if (in == null) return;
        in.close();
    }

    public Group getGroup(String groupName) throws TurbineException {
        Group instance = (Group)this.pollInstance(groupName);
        if (instance == null) {
            try {
                instance = new Group(this.appData.getGroup(groupName));
            }
            catch (Exception e) {
                throw new TurbineException(e);
            }
        }
        return instance;
    }

    public boolean releaseGroup(Group instance) {
        if (instance != null) {
            HashMap repository = this.poolRepository;
            String name = instance.getIntakeGroupName();
            PoolBuffer pool = (PoolBuffer)repository.get(name);
            if (pool == null) {
                pool = new PoolBuffer(instance.getPoolCapacity());
                repository = (HashMap)repository.clone();
                repository.put(name, pool);
                this.poolRepository = repository;
            }
            return pool.offer(instance);
        }
        return false;
    }

    public int getCapacity(String name) {
        int capacity = 1024;
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(name);
        if (pool == null) {
            try {
                capacity = Integer.parseInt(this.appData.getGroup(name).getPoolCapacity());
            }
            catch (NumberFormatException nfe) {}
        } else {
            capacity = pool.capacity();
        }
        return capacity;
    }

    public void setCapacity(String name, int capacity) {
        HashMap<String, PoolBuffer> repository = this.poolRepository;
        repository = repository != null ? (HashMap)repository.clone() : new HashMap<String, PoolBuffer>();
        repository.put(name, new PoolBuffer(capacity));
        this.poolRepository = repository;
    }

    public int getSize(String name) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(name);
        return pool != null ? pool.size() : 0;
    }

    public void clearPool(String name) {
        throw new Error("Not implemented");
    }

    public void clearPool() {
        throw new Error("Not implemented");
    }

    private Object pollInstance(String groupName) throws TurbineException {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(groupName);
        return pool != null ? pool.poll() : null;
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public String getGroupKey(String groupName) {
        return (String)this.groupKeyMap.get(groupName);
    }

    public String getGroupName(String groupKey) {
        return (String)this.groupNameMap.get(groupKey);
    }

    public Method getFieldSetter(String className, String propName) {
        Map settersForClassName = (Map)this.setterMap.get(className);
        Method setter = (Method)settersForClassName.get(propName);
        if (setter == null) {
            PropertyDescriptor pd = null;
            Map map = this.setterMap;
            synchronized (map) {
                try {
                    pd = new PropertyDescriptor(propName, Class.forName(className));
                    setter = pd.getWriteMethod();
                    ((Map)this.setterMap.get(className)).put(propName, setter);
                    if (setter == null) {
                        Log.error("Intake: setter for '" + propName + "' in class '" + className + "' could not be found.");
                    }
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
            Map map2 = this.getterMap;
            synchronized (map2) {
                try {
                    Method getter = pd.getReadMethod();
                    ((Map)this.getterMap.get(className)).put(propName, getter);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
        }
        return setter;
    }

    public Method getFieldGetter(String className, String propName) {
        Map gettersForClassName = (Map)this.getterMap.get(className);
        Method getter = (Method)gettersForClassName.get(propName);
        if (getter == null) {
            PropertyDescriptor pd = null;
            Map map = this.getterMap;
            synchronized (map) {
                try {
                    pd = new PropertyDescriptor(propName, Class.forName(className));
                    getter = pd.getReadMethod();
                    ((Map)this.getterMap.get(className)).put(propName, getter);
                    if (getter == null) {
                        Log.error("Intake: getter for '" + propName + "' in class '" + className + "' could not be found.");
                    }
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
            Map map2 = this.setterMap;
            synchronized (map2) {
                try {
                    Method setter = pd.getWriteMethod();
                    ((Map)this.setterMap.get(className)).put(propName, setter);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
        }
        return getter;
    }

    private class PoolBuffer {
        private BoundedBuffer pool;
        private HashMap recyclers;

        public PoolBuffer(int capacity) {
            this.pool = new BoundedBuffer(capacity);
        }

        public Group poll() throws TurbineException {
            Group instance = (Group)this.pool.poll();
            if (instance != null && instance instanceof Recyclable) {
                try {
                    instance.recycle();
                }
                catch (Exception x) {
                    throw new TurbineException("Recycling failed for " + instance.getClass().getName(), x);
                }
            }
            return instance;
        }

        public boolean offer(Group instance) {
            try {
                instance.dispose();
            }
            catch (Exception x) {
                return false;
            }
            return this.pool.offer(instance);
        }

        public int capacity() {
            return this.pool.capacity();
        }

        public int size() {
            return this.pool.size();
        }
    }
}

