/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import org.apache.turbine.util.SequencedHashtable;

public class BufferCache
extends SequencedHashtable {
    private static final int DEFAULT_MAX_SIZE = 35;
    private int maxSize;

    public BufferCache() {
        this(35);
    }

    public BufferCache(int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
    }

    public synchronized Object put(Object key, Object value) {
        int size = this.size();
        if (size > 0 && size + 1 >= this.maxSize) {
            this.remove(0);
        }
        return super.put(key, value);
    }

    public synchronized Object get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            this.freshenSequence(key, value);
        }
        return value;
    }
}

