/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.mail;

import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Body;
import org.apache.ecs.html.Html;
import org.apache.ecs.html.PRE;
import org.apache.turbine.util.GenerateUniqueId;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.mail.Email;
import org.apache.turbine.util.mail.MultiPartEmail;

public class HtmlEmail
extends MultiPartEmail {
    protected MimeMultipart htmlContent;
    protected String text;
    protected String html;

    public HtmlEmail() throws MessagingException {
        this.init();
    }

    public MimeMultipart getHtmlContent() {
        if (this.htmlContent == null) {
            this.htmlContent = new MimeMultipart();
        }
        return this.htmlContent;
    }

    public HtmlEmail setTextMsg(String text) throws MessagingException {
        this.text = text;
        return this;
    }

    public HtmlEmail setHtmlMsg(String html) throws MessagingException {
        this.html = html;
        return this;
    }

    public HtmlEmail setHtmlMsg(Document doc) throws MessagingException {
        return this.setHtmlMsg(doc.toString());
    }

    public Email setMsg(String msg) throws MessagingException {
        this.setTextMsg(msg);
        this.setHtmlMsg(new ElementContainer((Element)new Html((Element)new Body().addElement((Element)new PRE(msg)))).toString());
        return this;
    }

    public String embed(URL url, String name) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler((DataSource)new URLDataSource(url)));
        mbp.setFileName(name);
        mbp.setDisposition("inline");
        String cid = GenerateUniqueId.getIdentifier();
        mbp.addHeader("Content-ID", cid);
        this.getHtmlContent().addBodyPart((BodyPart)mbp);
        return mbp.getContentID();
    }

    public void send() throws MessagingException {
        MimeBodyPart msgText = null;
        MimeBodyPart msgHtml = null;
        if (StringUtils.isValid(this.text) && StringUtils.isValid(this.html)) {
            MimeMultipart msg = this.getHtmlContent();
            msg.setSubType("alternative");
            this.main.setContent((Multipart)msg);
            msgText = new MimeBodyPart();
            msgHtml = new MimeBodyPart();
            msg.addBodyPart((BodyPart)msgText);
            msg.addBodyPart((BodyPart)msgHtml);
        } else if (StringUtils.isValid(this.text)) {
            msgText = this.main;
        } else if (StringUtils.isValid(this.html)) {
            msgHtml = this.main;
        } else {
            msgText = this.main;
            this.text = "NO BODY";
        }
        if (msgText != null) {
            if (this.charset != null) {
                msgText.setText(this.text, this.charset);
            } else {
                msgText.setText(this.text);
            }
        }
        if (msgHtml != null) {
            if (this.charset != null) {
                msgHtml.setContent((Object)this.html, "text/html;charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
        }
        super.send();
    }
}

