/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.account.AccountResultData;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.orm.query.Where;
import com.aimluck.eip.util.ALEipUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountUserSelectData
extends ALAbstractSelectData<TurbineUser, ALBaseUser> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountUserSelectData.class.getName());
    protected String currentPost = "";
    protected String currentRole = "";
    protected int registeredUserNum = 0;
    protected static final String LIST_FILTER_ROLE = "filter_role";
    protected final String LIST_FILTER_ROLE_STR = new StringBuffer().append(((Object)((Object)this)).getClass().getName()).append("filter_role").toString();
    private boolean adminFilter;
    protected ALStringField target_keyword;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"userposition");
        }
        if (rundata.getParameters().containsKey((Object)LIST_FILTER_ROLE)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_ROLE_STR, (String)rundata.getParameters().getString(LIST_FILTER_ROLE));
        }
        this.target_keyword = new ALStringField();
        super.init(action, rundata, context);
    }

    protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {
        try {
            this.target_keyword.setValue(AccountUtils.getTargetKeyword(rundata, context));
            SelectQuery<TurbineUser> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.registeredUserNum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUserSelectData.selectList", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<TurbineUser> getSelectQuery(RunData rundata, Context context) {
        ObjectId oid = new ObjectId("TurbineUser", "USER_ID", 3);
        Expression exp_base = ExpressionFactory.matchAllDbExp((Map)oid.getIdSnapshot(), (int)6);
        SelectQuery query = Database.query(TurbineUser.class, (Expression)exp_base).where(new Where[]{Operations.eq((String)"companyId", (Object)1), Operations.ne((String)"disabled", (Object)"T")});
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_role = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_ROLE_STR);
        this.currentPost = filter;
        this.currentRole = filter_role;
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.target_keyword.getValue()));
            transWord = transWord.replace("\u3000", "").replace(" ", "");
            String[] transWords = transWord.split("");
            for (int i = 0; i < transWords.length; ++i) {
                Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp16 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp17 = ExpressionFactory.likeExp((String)"loginName", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp21 = ExpressionFactory.likeExp((String)"outTelephone", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp22 = ExpressionFactory.likeExp((String)"inTelephone", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp23 = ExpressionFactory.likeExp((String)"cellularPhone", (Object)("%" + this.target_keyword.getValue() + "%"));
                Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWords[i] + "%"));
                Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWords[i] + "%"));
                Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWords[i] + "%"));
                Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWords[i] + "%"));
                Expression exp35 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + transWords[i] + "%"));
                query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp17).orExp(exp21).orExp(exp22).orExp(exp23).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35));
            }
        }
        if (filter_role != null && !filter_role.equals("")) {
            if (filter_role.equals(AccountUtils.ROLE_ADMIN.toString())) {
                try {
                    Group group = JetspeedSecurity.getGroup((String)"LoginUser");
                    Role adminrole = JetspeedSecurity.getRole((String)"admin");
                    List admins = Database.query(TurbineUserGroupRole.class).where(new Where[]{Operations.eq((String)"turbineRole", (Object)adminrole.getId()), Operations.eq((String)"turbineGroup", (Object)group.getId()), Operations.ne((String)"turbineUser", (Object)1)}).distinct(true).fetchList();
                    ArrayList<Integer> admin_ids = new ArrayList<Integer>();
                    admin_ids.add(1);
                    for (TurbineUserGroupRole tugr : admins) {
                        admin_ids.add(tugr.getTurbineUser().getUserId());
                    }
                    query.andQualifier(ExpressionFactory.inDbExp((String)"USER_ID", admin_ids));
                }
                catch (Exception ex) {
                    logger.error((Object)"AccountUserSelectData.getSelectQuery", (Throwable)ex);
                }
            }
            if (filter_role.equals(AccountUtils.ROLE_ACTIVE.toString())) {
                query.andQualifier(ExpressionFactory.matchExp((String)"disabled", (Object)"F"));
            }
            if (filter_role.equals(AccountUtils.ROLE_IN_ACTIVE.toString())) {
                query.andQualifier(ExpressionFactory.matchExp((String)"disabled", (Object)"N"));
            }
        }
        if (filter != null && !filter.equals("")) {
            String groupName = ((ALEipPost)ALEipManager.getInstance().getPostMap().get(Integer.valueOf(filter))).getGroupName().getValue();
            query.where(Operations.eq((String)"turbineUserGroupRole.turbineGroup.groupName", (Object)groupName));
        }
        query.distinct();
        return query;
    }

    protected SelectQuery<TurbineUser> buildSelectQueryForFilter(SelectQuery<TurbineUser> query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_role = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_ROLE_STR);
        Map gMap = ALEipManager.getInstance().getPostMap();
        if (filter != null && filter.trim().length() != 0 && !gMap.containsKey(Integer.valueOf(filter))) {
            filter = null;
        }
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchDbExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.currentPost = filter;
        this.currentRole = filter_role;
        return query;
    }

    private String getPostName(int id) {
        if (ALEipManager.getInstance().getPostMap().containsKey(id)) {
            return ((ALEipPost)ALEipManager.getInstance().getPostMap().get(id)).getPostName().getValue();
        }
        return null;
    }

    private String getPositionName(int id) {
        if (ALEipManager.getInstance().getPositionMap().containsKey(id)) {
            return ((ALEipPosition)ALEipManager.getInstance().getPositionMap().get(id)).getPositionName().getValue();
        }
        return null;
    }

    protected ALBaseUser selectDetail(RunData rundata, Context context) {
        return AccountUtils.getBaseUser(rundata, context);
    }

    protected Object getResultData(TurbineUser record) {
        try {
            AccountResultData rd = new AccountResultData();
            rd.initField();
            rd.setUserId(record.getUserId());
            rd.setUserName(record.getLoginName());
            rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
            rd.setPostNameList(ALEipUtils.getPostNameList((int)record.getUserId()));
            rd.setPositionName(ALEipUtils.getPositionName((int)record.getPositionId()));
            rd.setDisabled(record.getDisabled());
            rd.setHasPhoto("T".equals(record.getHasPhoto()));
            rd.setPhotoModified(record.getPhotoModified().getTime());
            rd.setEmail(record.getEmail());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUserSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(ALBaseUser record) {
        try {
            Integer id = Integer.valueOf(record.getUserId());
            AccountResultData rd = new AccountResultData();
            rd.initField();
            rd.setUserId(Integer.valueOf(record.getUserId()));
            rd.setUserName(record.getUserName());
            rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
            rd.setNameKana(new StringBuffer().append(record.getLastNameKana()).append(" ").append(record.getFirstNameKana()).toString());
            rd.setEmail(record.getEmail());
            rd.setOutTelephone(record.getOutTelephone());
            rd.setInTelephone(record.getInTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPostNameList(ALEipUtils.getPostNameList((int)id));
            rd.setPositionName(ALEipUtils.getPositionName((int)record.getPositionId()));
            rd.setDisabled(record.getDisabled());
            rd.setIsAdmin(ALEipUtils.isAdmin((int)Integer.valueOf(record.getUserId())));
            rd.setHasPhoto(record.hasPhoto());
            rd.setPhotoModified(record.getPhotoModified().getTime());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AccountUserSelectData.getResultDataDetail", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("post", "POST_ID");
        map.putValue("login_name", "loginName");
        map.putValue("name_kana", "lastNameKana");
        map.putValue("userposition", "eipMUserPosition.position");
        return map;
    }

    public String getCurrentPost() {
        return this.currentPost;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public Map<Integer, AccountUtils.FilterRole> getRoleMap() {
        return AccountUtils.getRoleMap();
    }

    public int getRegisteredUserNum() {
        return this.registeredUserNum;
    }

    public int getRandomNum() {
        SecureRandom random = new SecureRandom();
        return random.nextInt() * 100;
    }

    public boolean isAdminFiltered() {
        return this.adminFilter;
    }

    public String getCurrentRole() {
        return this.currentRole;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }
}

