/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.fileio.FileIOAccountPostCsvData;
import com.aimluck.eip.fileio.FileIOAccountPostCsvFormData;
import com.aimluck.eip.fileio.util.FileIOAccountCsvUtils;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAccountPostCsvSelectData
extends ALCsvAbstractSelectData<FileIOAccountPostCsvData, FileIOAccountPostCsvData> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountPostCsvSelectData.class.getName());

    protected ResultList<FileIOAccountPostCsvData> selectList(RunData rundata, Context context) {
        try {
            if (this.stats == 0) {
                return new ResultList(this.readAccountInfoFromCsv(rundata));
            }
            if (this.stats == 1) {
                String filepath = FileIOAccountCsvUtils.getAccountPostCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account_post.csv";
                return new ResultList(this.readAccountInfoFromCsvPage(rundata, filepath, rundata.getParameters().getInteger("csvpage") - 1, 1000));
            }
            if (this.stats == 2) {
                if (this.error_count <= 0) {
                    return null;
                }
                String filepath = FileIOAccountCsvUtils.getAccountPostCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account_post_err.csv";
                return new ResultList(this.readAccountInfoFromCsvPage(rundata, filepath, 0, 100));
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"fileio", (Throwable)ex);
            return null;
        }
    }

    private List<FileIOAccountPostCsvData> readAccountInfoFromCsv(RunData rundata) throws Exception {
        String filepath = FileIOAccountCsvUtils.getAccountPostCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account_post.csv";
        String filepath_err = FileIOAccountCsvUtils.getAccountPostCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account_post_err.csv";
        ALCsvTokenizer reader = new ALCsvTokenizer();
        if (!reader.init(filepath)) {
            return null;
        }
        ArrayList<FileIOAccountPostCsvData> list = new ArrayList<FileIOAccountPostCsvData>();
        int ErrCount = 0;
        int line = 0;
        String ErrorCode = "";
        ArrayList<FileIOAccountPostCsvData> collectList = new ArrayList<FileIOAccountPostCsvData>();
        while (reader.eof != -1) {
            int i;
            int j;
            ++line;
            StringBuffer e_line = new StringBuffer();
            boolean b_err = false;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOAccountPostCsvFormData formData = new FileIOAccountPostCsvFormData();
            formData.initField();
            e_line.append("");
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                if (j > 0) {
                    e_line.append(",");
                }
                e_line.append("\"");
                e_line.append(this.makeOutputItem(token));
                e_line.append("\"");
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (reader.eof == -1 && j == 0) break;
            ++j;
            while (j < this.sequency.size()) {
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken("", i);
                e_line.append(",\"\"");
                ++j;
            }
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                b_err = true;
            }
            if (reader.eof == -1) break;
            try {
                FileIOAccountPostCsvData data = new FileIOAccountPostCsvData();
                data.initField();
                data.setLineCount(line);
                data.setPostName(formData.getPostName().getValue());
                data.setSamePost(formData.getSamePost());
                data.setZipcode(formData.getZipcode().getValue());
                data.setAddress(formData.getAddress().getValue());
                data.setOutTelephone(formData.getOutTelephone().getValue());
                data.setInTelephone(formData.getInTelephone().getValue());
                data.setFaxNumber(formData.getFaxNumber().getValue());
                for (int k = 0; k < collectList.size(); ++k) {
                    FileIOAccountPostCsvData pdata = (FileIOAccountPostCsvData)((Object)collectList.get(k));
                    if (!data.getPostName().getValue().equals(pdata.getPostName().getValue())) continue;
                    data.setSamePost(true);
                    b_err = true;
                }
                if (data.getPostName().toString().equals("")) {
                    b_err = true;
                }
                data.setIsError(b_err);
                if (b_err) {
                    ErrorCode = ErrorCode + e_line.toString();
                    ErrorCode = ErrorCode + "," + Integer.toString(line);
                    ErrorCode = ErrorCode + "\n";
                } else {
                    collectList.add(data);
                }
                if (!formData.getPostName().toString().equals(ALLocalizationUtils.getl10n((String)"FILIIO_UNIT_NAME"))) {
                    if (ErrCount == 0) {
                        if (!b_err) {
                            if (list.size() < 1000) {
                                list.add(data);
                            }
                        } else {
                            list.add(data);
                            ++ErrCount;
                        }
                    } else {
                        if (b_err) {
                            ++ErrCount;
                        }
                        list.add(data);
                    }
                } else {
                    if (ErrCount > 0) {
                        --ErrCount;
                    }
                    int lc = this.getLineCount();
                    this.setLineCount(lc - 1);
                }
                if (ErrCount >= 100) {
                    break;
                }
            }
            catch (RuntimeException e) {
                logger.error((Object)"readError");
            }
            catch (Exception e) {
                logger.error((Object)"readError");
            }
            if (reader.eof != -1) continue;
            break;
        }
        collectList.clear();
        collectList = null;
        this.setErrorCount(ErrCount);
        if (ErrCount > 0) {
            this.outputErrorData(rundata, ErrorCode, filepath_err);
        }
        return list;
    }

    private List<FileIOAccountPostCsvData> readAccountInfoFromCsvPage(RunData rundata, String filepath, int StartLine, int LineLimit) throws Exception {
        ALCsvTokenizer reader = new ALCsvTokenizer();
        int line_index = StartLine * 1000;
        if (!reader.setStartLine(filepath, line_index)) {
            return null;
        }
        ArrayList<FileIOAccountPostCsvData> list = new ArrayList<FileIOAccountPostCsvData>();
        int line = 0;
        while (reader.eof != -1 && ++line <= LineLimit) {
            boolean iserror;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOAccountPostCsvFormData formData = new FileIOAccountPostCsvFormData();
            formData.initField();
            for (int j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
                if (j != this.sequency.size() - 1 || this.stats != 2) continue;
                token = reader.nextToken();
                line = Integer.parseInt(token);
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            formData.setValidator();
            boolean bl = iserror = !formData.validate(errmsg);
            if (reader.eof == -1) break;
            try {
                FileIOAccountPostCsvData data = new FileIOAccountPostCsvData();
                data.initField();
                data.setLineCount(line + line_index);
                data.setPostName(formData.getPostName().getValue());
                data.setSamePost(formData.getSamePost());
                data.setZipcode(formData.getZipcode().getValue());
                data.setAddress(formData.getAddress().getValue());
                data.setOutTelephone(formData.getOutTelephone().getValue());
                data.setInTelephone(formData.getInTelephone().getValue());
                data.setFaxNumber(formData.getFaxNumber().getValue());
                data.setIsError(iserror);
                if (!formData.getPostName().toString().equals(ALLocalizationUtils.getl10n((String)"FILIIO_UNIT_NAME"))) {
                    list.add(data);
                }
            }
            catch (Exception e) {
                logger.error((Object)"readError");
            }
            if (reader.eof != -1) continue;
            break;
        }
        return list;
    }

    public String getLineCount2() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_ERROR_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getErrorCount()});
    }

    public String getLineCount3() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_REGISTER_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getNotErrorCount()});
    }
}

