/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.fileio.FileIOAddressBookCsvData;
import com.aimluck.eip.fileio.FileIOAddressBookCsvFormData;
import com.aimluck.eip.fileio.util.FileIOAddressBookCsvUtils;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAddressBookCsvSelectData
extends ALCsvAbstractSelectData<FileIOAddressBookCsvData, FileIOAddressBookCsvData> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAddressBookCsvSelectData.class.getName());
    private boolean is_company_only;

    public void initField() {
        super.initField();
        this.setIsCompanyOnly(false);
    }

    protected ResultList<FileIOAddressBookCsvData> selectList(RunData rundata, Context context) {
        try {
            if (this.stats == 0) {
                return new ResultList(this.readAddressBookInfoFromCsv(rundata));
            }
            if (this.stats == 1) {
                String filepath = FileIOAddressBookCsvUtils.getAddressBookCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "address_book.csv";
                return new ResultList(this.readAddressBookInfoFromCsvPage(rundata, filepath, rundata.getParameters().getInteger("csvpage") - 1, 1000));
            }
            if (this.stats == 2) {
                if (this.error_count <= 0) {
                    return null;
                }
                String filepath = FileIOAddressBookCsvUtils.getAddressBookCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "address_book_err.csv";
                return new ResultList(this.readAddressBookInfoFromCsvPage(rundata, filepath, 0, 100));
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"fileio", (Throwable)ex);
            return null;
        }
    }

    private List<FileIOAddressBookCsvData> readAddressBookInfoFromCsv(RunData rundata) throws Exception {
        String filepath = FileIOAddressBookCsvUtils.getAddressBookCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "address_book.csv";
        String filepath_err = FileIOAddressBookCsvUtils.getAddressBookCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "address_book_err.csv";
        ALCsvTokenizer reader = new ALCsvTokenizer();
        if (!reader.init(filepath)) {
            return null;
        }
        ArrayList<FileIOAddressBookCsvData> list = new ArrayList<FileIOAddressBookCsvData>();
        int ErrCount = 0;
        int line = 0;
        String ErrorCode = "";
        ArrayList<FileIOAddressBookCsvData> collectList = new ArrayList<FileIOAddressBookCsvData>();
        while (reader.eof != -1) {
            int i;
            int j;
            ++line;
            StringBuffer e_line = new StringBuffer();
            boolean b_err = false;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOAddressBookCsvFormData formData = new FileIOAddressBookCsvFormData();
            formData.initField();
            formData.setIsCompanyOnly(this.is_company_only);
            e_line.append("");
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                if (j > 0) {
                    e_line.append(",");
                }
                e_line.append("\"");
                e_line.append(this.makeOutputItem(token));
                e_line.append("\"");
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (reader.eof == -1 && j == 0) break;
            ++j;
            while (j < this.sequency.size()) {
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken("", i);
                e_line.append(",\"\"");
                ++j;
            }
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                b_err = true;
            }
            try {
                FileIOAddressBookCsvData data = new FileIOAddressBookCsvData();
                data.initField();
                data.setLineCount(line);
                StringBuffer sb = new StringBuffer();
                sb.append(formData.getLastName().toString() + " " + formData.getFirstName().toString());
                data.setName(formData.getLastName().toString() + " " + formData.getFirstName().toString());
                data.setNameKana(formData.getLastNameKana().toString() + " " + formData.getFirstNameKana().toString());
                data.setCreatedUser(formData.getUserName().toString());
                data.setTelephone(formData.getTelephone());
                data.setCellularPhone(formData.getCellularPhone());
                data.setEmail(formData.getEmail());
                data.setCellularMail(formData.getCellularMail());
                data.setCompanyName(formData.getCompanyName().getValue());
                data.setCompanyNameKana(formData.getCompanyNameKana().getValue());
                data.setZipcode(formData.getCompZipcode());
                data.setCompanyAddress(formData.getCompAddress());
                data.setCompanyTelephone(formData.getCompTelephone());
                data.setCompanyFaxNumber(formData.getCompFaxNumber());
                data.setPostName(formData.getPostName().getValue());
                data.setPositionName(formData.getPositionName().getValue());
                data.setCompanyUrl(formData.getCompUrl());
                data.setNote(formData.getNote().getValue());
                for (int k = 0; k < collectList.size(); ++k) {
                    FileIOAddressBookCsvData pdata = (FileIOAddressBookCsvData)((Object)collectList.get(k));
                    if (!data.getCompanyName().toString().equals(pdata.getCompanyName().toString()) || !data.getPostName().toString().equals(pdata.getPostName().toString()) || !this.is_company_only) continue;
                    data.setSameCompany(true);
                    b_err = true;
                }
                if (formData.getSameCompany()) {
                    if (this.is_company_only) {
                        b_err = true;
                    }
                    data.setSameCompany(true);
                }
                if (data.getName().toString().equals("") && data.getCompanyNameKana().toString().equals("")) {
                    b_err = true;
                }
                if (!data.getName().toString().equals("") && data.getNameKana().toString().equals("")) {
                    b_err = true;
                }
                if (!data.getCompanyName().toString().equals("") && data.getCompanyNameKana().toString().equals("")) {
                    b_err = true;
                }
                data.setIsError(b_err);
                if (b_err) {
                    ErrorCode = ErrorCode + e_line.toString();
                    ErrorCode = ErrorCode + "," + Integer.toString(line);
                    ErrorCode = ErrorCode + "\n";
                } else {
                    collectList.add(data);
                }
                if (!formData.getFirstName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_LAST_NAME")) && !formData.getCompanyName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_COMPANY_NAME"))) {
                    if (ErrCount == 0) {
                        if (!b_err) {
                            if (list.size() < 1000) {
                                list.add(data);
                            }
                        } else {
                            list.add(data);
                            ++ErrCount;
                        }
                    } else {
                        if (b_err) {
                            ++ErrCount;
                        }
                        list.add(data);
                    }
                } else {
                    if (ErrCount > 0) {
                        --ErrCount;
                    }
                    int lc = this.getLineCount();
                    this.setLineCount(lc - 1);
                }
                if (ErrCount >= 100) {
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)"readError", (Throwable)e);
            }
            if (reader.eof != -1) continue;
            break;
        }
        collectList.clear();
        collectList = null;
        this.setErrorCount(ErrCount);
        if (ErrCount > 0) {
            this.outputErrorData(rundata, ErrorCode, filepath_err);
        }
        return list;
    }

    private List<FileIOAddressBookCsvData> readAddressBookInfoFromCsvPage(RunData rundata, String filepath, int StartLine, int LineLimit) throws Exception {
        ALCsvTokenizer reader = new ALCsvTokenizer();
        int line_index = StartLine * 1000;
        if (!reader.setStartLine(filepath, line_index)) {
            return null;
        }
        ArrayList<FileIOAddressBookCsvData> list = new ArrayList<FileIOAddressBookCsvData>();
        int line = 0;
        while (reader.eof != -1 && ++line <= LineLimit) {
            boolean iserror;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOAddressBookCsvFormData formData = new FileIOAddressBookCsvFormData();
            formData.initField();
            formData.setIsCompanyOnly(this.is_company_only);
            for (int j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
                if (j != this.sequency.size() - 1 || this.stats != 2) continue;
                token = reader.nextToken();
                line = Integer.parseInt(token);
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            formData.setValidator();
            boolean bl = iserror = !formData.validate(errmsg);
            if (reader.eof == -1) break;
            try {
                FileIOAddressBookCsvData data = new FileIOAddressBookCsvData();
                data.initField();
                data.setLineCount(line + line_index);
                data.setName(formData.getLastName().toString() + " " + formData.getFirstName().toString());
                data.setNameKana(formData.getLastNameKana().toString() + " " + formData.getFirstNameKana().toString());
                data.setCreatedUser(formData.getUserName().toString());
                data.setTelephone(formData.getTelephone());
                data.setCellularPhone(formData.getCellularPhone());
                data.setEmail(formData.getEmail());
                data.setCellularMail(formData.getCellularMail());
                data.setCompanyName(formData.getCompanyName().getValue());
                data.setCompanyNameKana(formData.getCompanyNameKana().getValue());
                data.setZipcode(formData.getCompZipcode());
                data.setCompanyAddress(formData.getCompAddress());
                data.setCompanyTelephone(formData.getCompTelephone());
                data.setCompanyFaxNumber(formData.getCompFaxNumber());
                data.setPostName(formData.getPostName().getValue());
                data.setPositionName(formData.getPositionName().getValue());
                data.setCompanyUrl(formData.getCompUrl());
                data.setSameCompany(formData.getSameCompany());
                data.setNote(formData.getNote().getValue());
                if (this.is_company_only && formData.getSameCompany()) {
                    data.setIsError(true);
                } else {
                    data.setIsError(iserror);
                }
                if (!formData.getFirstName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_LAST_NAME")) && !formData.getCompanyName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_COMPANY_NAME"))) {
                    list.add(data);
                }
            }
            catch (Exception e) {
                logger.error((Object)"readError", (Throwable)e);
            }
            if (reader.eof != -1) continue;
            break;
        }
        return list;
    }

    public void setIsCompanyOnly(boolean flag) {
        this.is_company_only = flag;
    }

    public String getLineCount2() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_ERROR_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getErrorCount()});
    }

    public String getLineCount3() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_REGISTER_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getNotErrorCount()});
    }
}

