/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileio.FileIOScheduleCsvData;
import com.aimluck.eip.fileio.FileIOScheduleCsvFormData;
import com.aimluck.eip.fileio.util.FileIOScheduleCsvUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOScheduleCsvSelectData
extends ALCsvAbstractSelectData<FileIOScheduleCsvData, FileIOScheduleCsvData> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOScheduleCsvSelectData.class.getName());
    private String autotime_flg;
    private Date now;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.now = new Date();
    }

    public void initField() {
        this.autotime_flg = "";
        super.initField();
    }

    protected ResultList<FileIOScheduleCsvData> selectList(RunData rundata, Context context) {
        try {
            if (this.stats == 0) {
                return new ResultList(this.readScheduleInfoFromCsv(rundata));
            }
            if (this.stats == 1) {
                String filepath = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "schedule_info.csv";
                return new ResultList(this.readScheduleInfoFromCsvPage(rundata, filepath, rundata.getParameters().getInteger("csvpage") - 1, 1000));
            }
            if (this.stats == 2) {
                String filepath = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "schedule_info_error.csv";
                return new ResultList(this.readScheduleInfoFromCsvPage(rundata, filepath, 0, 100));
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"fileio", (Throwable)ex);
            return null;
        }
    }

    protected FileIOScheduleCsvData selectDetail(RunData rundata, Context context) {
        return null;
    }

    private List<FileIOScheduleCsvData> readScheduleInfoFromCsv(RunData rundata) throws Exception {
        String filepath = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "schedule_info.csv";
        String filepath_err = FileIOScheduleCsvUtils.getScheduleCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "schedule_info_error.csv";
        ALCsvTokenizer reader = new ALCsvTokenizer();
        if (!reader.init(filepath)) {
            return null;
        }
        ArrayList<FileIOScheduleCsvData> list = new ArrayList<FileIOScheduleCsvData>();
        int ErrCount = 0;
        int line = 0;
        String ErrorCode = "";
        while (reader.eof != -1) {
            int i;
            int j;
            ++line;
            StringBuffer e_line = new StringBuffer();
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOScheduleCsvFormData formData = new FileIOScheduleCsvFormData();
            formData.initField();
            formData.setIsAutoTime(this.autotime_flg);
            e_line.append("");
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                if (j > 0) {
                    e_line.append(",");
                }
                e_line.append("\"");
                e_line.append(this.makeOutputItem(token));
                e_line.append("\"");
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (reader.eof == -1 && j == 0) break;
            ++j;
            while (j < this.sequency.size()) {
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken("", i);
                e_line.append(",\"\"");
                ++j;
            }
            formData.adjust();
            formData.adjustUser(errmsg);
            formData.setValidator();
            formData.validate(errmsg);
            try {
                FileIOScheduleCsvData data = this.setupData(formData, errmsg, line);
                if (errmsg.size() > 0) {
                    ErrorCode = ErrorCode + e_line.toString();
                    ErrorCode = ErrorCode + "," + Integer.toString(line) + ",false";
                    ErrorCode = ErrorCode + "\n";
                    data.setIsError(true);
                }
                if (!formData.getUserFullName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_NAME"))) {
                    if (ErrCount == 0) {
                        if (errmsg.size() == 0) {
                            if (list.size() < 1000) {
                                list.add(data);
                            }
                        } else {
                            list.add(data);
                            ++ErrCount;
                        }
                    } else {
                        if (errmsg.size() > 0) {
                            ++ErrCount;
                        }
                        list.add(data);
                    }
                } else {
                    if (ErrCount > 0) {
                        --ErrCount;
                    }
                    int lc = this.getLineCount();
                    this.setLineCount(lc - 1);
                }
                if (ErrCount >= 100) {
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)"readError", (Throwable)e);
            }
            if (reader.eof != -1) continue;
            break;
        }
        this.setErrorCount(ErrCount);
        if (ErrCount > 0) {
            this.outputErrorData(rundata, ErrorCode, filepath_err);
        }
        return list;
    }

    private FileIOScheduleCsvData setupData(FileIOScheduleCsvFormData formData, List<String> errmsg, int line) throws Exception {
        FileIOScheduleCsvData data = new FileIOScheduleCsvData();
        data.initField();
        ALDateTimeField date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        data.setUserNameString(formData.getUserNameString());
        data.setLoginNameString(formData.getLoginNameString());
        data.setLineCount(line);
        data.setName(formData.getScheduleName().getValue());
        if (data.getName().toString().equals("")) {
            errmsg.add("schedule title have no content");
        }
        data.setPlace(formData.getPlace().getValue());
        data.setNote(formData.getNote().getValue());
        try {
            date.setValue(formData.getCreateDate().toString());
            data.setUpdateDate(date.getValue());
        }
        catch (Exception e) {
            data.setUpdateDate(this.now);
        }
        try {
            date.setValue(formData.getStartDateTime().toString());
            data.setStartDate(date.getValue());
        }
        catch (Exception e) {
            errmsg.add("start date is null");
        }
        try {
            date.setValue(formData.getEndDateTime().toString());
            data.setEndDate(date.getValue());
        }
        catch (Exception e) {
            errmsg.add("end date is null");
        }
        data.setIsError(errmsg.size() > 0);
        return data;
    }

    private List<FileIOScheduleCsvData> readScheduleInfoFromCsvPage(RunData rundata, String filepath, int StartLine, int LineLimit) throws Exception {
        ALCsvTokenizer reader = new ALCsvTokenizer();
        int line_index = StartLine * 1000;
        if (!reader.setStartLine(filepath, line_index)) {
            return null;
        }
        ArrayList<FileIOScheduleCsvData> list = new ArrayList<FileIOScheduleCsvData>();
        int line = 0;
        while (reader.eof != -1) {
            int j;
            boolean iserror = false;
            ++line;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOScheduleCsvFormData formData = new FileIOScheduleCsvFormData();
            formData.initField();
            formData.setIsAutoTime(this.autotime_flg);
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
                if (j != this.sequency.size() - 1 || this.stats != 2) continue;
                token = reader.nextToken();
                line = Integer.parseInt(token);
            }
            if (this.stats == 2) {
                String string = reader.nextToken();
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (formData.getUserFullName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_NAME"))) continue;
            if (reader.eof == -1 && j == 0) break;
            formData.adjust();
            formData.adjustUser(errmsg);
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                iserror = true;
            }
            if (this.stats == 2) {
                iserror = true;
            }
            try {
                FileIOScheduleCsvData data = this.setupData(formData, errmsg, line);
                data.setIsError(iserror);
                list.add(data);
            }
            catch (Exception e) {
                logger.error((Object)"readError", (Throwable)e);
            }
            if (reader.eof != -1) continue;
            break;
        }
        return list;
    }

    public void setIsAutoTime(String flag) {
        this.autotime_flg = flag;
    }

    public String getLineCount2() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_ERROR_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getErrorCount()});
    }

    public String getLineCount3() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_REGISTER_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getNotErrorCount()});
    }
}

