/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.disk;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.jetspeed.cache.disk.DiskCache;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.URIEncoder;
import org.apache.turbine.services.servlet.TurbineServlet;

public class DiskCacheUtils {
    public static final String[] VALID_PROTOCOLS = new String[]{"http", "ftp"};
    private static Vector localprotocols = JetspeedResources.getVector((String)"diskcache.localprotocols");
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DiskCacheUtils.class.getName());
    private static String hostName = "localhost";

    public static String getVirtual(String url) {
        int begin = 0;
        if (url.indexOf(":/") != -1) {
            begin = url.indexOf(":/") + 2;
        }
        if (begin > 0) {
            url = url.substring(begin, url.length());
        }
        url = url.substring(url.indexOf("/"), url.length());
        return url;
    }

    public static String getLocalURL(String virtual) {
        if (virtual != null && DiskCacheUtils.isLocal(virtual) && virtual.indexOf("/") != 0) {
            return virtual;
        }
        if (!DiskCacheUtils.isVirtual(virtual)) {
            throw new IllegalArgumentException("The URL specifies is not a virtual URL: " + virtual);
        }
        String url = TurbineServlet.getResource((String)virtual).toString();
        return url;
    }

    public static boolean isVirtual(String url) {
        return url.indexOf("/") == 0;
    }

    public static boolean isLocal(String url) {
        if (url != null && url.length() > 1) {
            if (url.indexOf(":/") == -1) {
                return true;
            }
            if (url.indexOf("http://localhost") == 0 || url.indexOf("http://127.0.0.1") == 0 || url.indexOf("http://" + hostName) == 0) {
                return true;
            }
            if (localprotocols != null) {
                Enumeration en = localprotocols.elements();
                while (en.hasMoreElements()) {
                    String protocol = (String)en.nextElement() + ":";
                    if (url.indexOf(protocol) == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isRemote(String url) {
        return !DiskCacheUtils.isLocal(url);
    }

    public static boolean isCached(DiskCache instance, String url) {
        return instance.isCached(url);
    }

    public static boolean isCached(String url) {
        return DiskCacheUtils.isCached(JetspeedDiskCache.getInstance(), url);
    }

    public static boolean isCacheable(String url) {
        for (int i = 0; i < VALID_PROTOCOLS.length; ++i) {
            String uri = VALID_PROTOCOLS[i] + ":/";
            if (url.length() < uri.length() || !url.substring(0, uri.length()).equals(uri)) continue;
            return DiskCacheUtils.isRemote(url);
        }
        return false;
    }

    public static File getFile(DiskCache instance, String url) {
        String file = URIEncoder.encode(url);
        file = instance.getRoot() + "/" + file;
        return new File(file);
    }

    public static String getFileURL(DiskCache instance, String url) {
        URL fileURL = null;
        try {
            fileURL = DiskCacheUtils.getFile(instance, url).toURL();
        }
        catch (MalformedURLException e) {
            logger.error("Exception getting URL", e);
            return null;
        }
        return fileURL.toString();
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (localprotocols.size() == 0) {
            localprotocols.add("file");
        }
    }
}

