/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.jetspeed.modules.parameters.ParameterPresentationStyle;
import org.apache.jetspeed.modules.parameters.ParameterPresentationStyleFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.util.RunData;

public class ParameterLoader
extends GenericLoader {
    private static ParameterLoader instance = new ParameterLoader(JetspeedResources.getInt("parameter.cache.size", 50));
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ParameterLoader.class.getName());

    private ParameterLoader() {
    }

    private ParameterLoader(int i) {
        super(i);
    }

    private void addInstance(String name, ParameterPresentationStyle param) {
        if (this.cache()) {
            this.put(name, (Object)param);
        }
    }

    public String eval(RunData data, String provider, String name, String value, Map parms) throws Exception {
        ParameterPresentationStyle prm = this.getInstance(provider);
        Map styleparms = ParameterLoader.extractStyleParameters(parms, name);
        prm.setParms(styleparms);
        return prm.getContent(data, name, value, styleparms);
    }

    public void exec(RunData data, String name) throws Exception {
    }

    public ParameterPresentationStyle getInstance(String provider) throws Exception {
        ParameterPresentationStyle prm = null;
        if (this.cache() && this.containsKey(provider)) {
            prm = (ParameterPresentationStyle)((Object)this.get(provider));
            if (logger.isDebugEnabled()) {
                logger.debug("ParameterLoader: Serving parameter: " + provider + ", prm=" + (Object)((Object)prm) + " from cache");
            }
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                prm = (ParameterPresentationStyle)ab.getAssembler("parameter", provider);
                if (prm == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("ParameterLoader: Registering the factory");
                    }
                    ab.registerFactory("parameter", (AssemblerFactory)new ParameterPresentationStyleFactory());
                    prm = (ParameterPresentationStyle)ab.getAssembler("parameter", provider);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("ParameterLoader: Loaded parameter: " + provider + ", prm=" + (Object)((Object)prm));
                }
            }
            catch (ClassCastException cce) {
                prm = null;
                logger.error("Error loading presentation style", cce);
            }
            if (prm == null) {
                Vector packages = JetspeedResources.getVector((String)"module.packages");
                throw new ClassNotFoundException("\n\n\tRequested Parameter not found: " + provider + "\n" + "\tTurbine looked in the following modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(provider, prm);
            }
        }
        return prm;
    }

    public static ParameterLoader getInstance() {
        return instance;
    }

    public static Map extractStyleParameters(Map parms, String parmName) {
        Hashtable result = new Hashtable();
        if (parms != null) {
            String key = parmName.concat(".style.");
            for (String parmkey : parms.keySet()) {
                if (!parmkey.startsWith(key)) continue;
                try {
                    String stylekey = parmkey.substring(parmkey.lastIndexOf(".") + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("ParameterLoader: parm name [" + parmName + "] - storing option [" + stylekey + "] with value [" + parms.get(parmkey) + "]");
                    }
                    result.put(stylekey, parms.get(parmkey));
                }
                catch (Exception e) {
                    logger.error("Error extracting params", e);
                }
            }
        }
        return result;
    }
}

