/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.controllers;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.modules.actions.controllers.MultiColumnControllerAction;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.StringUtils;
import org.apache.jetspeed.util.template.JspTemplate;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class XMultiColumnControllerAction
extends MultiColumnControllerAction {
    protected void buildCustomizeContext(PortletController controller, Context context, RunData rundata) {
        super.buildCustomizeContext(controller, context, rundata);
        context.put("template", (Object)"x-multicolumn-customize.vm");
        context.put("action", (Object)"controllers.XMultiColumnControllerAction");
        context.put("includedContent", (Object)new JspTemplate(rundata, "/controllers/html/x-multicolumn-customize.jsp"));
        HttpServletRequest request = rundata.getRequest();
        request.setAttribute("jspContext", (Object)context);
    }

    public void doSave(RunData data, Context context) {
        this.applyModelChanges(data, context);
        super.doSave(data, context);
    }

    public void doDelete(RunData data, Context context) {
        this.applyModelChanges(data, context);
        super.doDelete(data, context);
    }

    public void doControl(RunData data, Context context) {
        this.applyModelChanges(data, context);
        super.doControl(data, context);
    }

    protected void applyModelChanges(RunData data, Context context) {
        HttpServletRequest request = data.getRequest();
        String[] modelChangeList = request.getParameterValues("modelChangeList");
        try {
            if (modelChangeList != null && modelChangeList.length > 0 && !modelChangeList[0].equals("")) {
                String[] moves = StringUtils.stringToArray(modelChangeList[0], ";");
                SessionState customizationState = ((JetspeedRunData)data).getPageSessionState();
                List[] columns = (List[])customizationState.getAttribute("customize-columns");
                for (int i = 0; i < moves.length; ++i) {
                    String[] values = StringUtils.stringToArray(moves[i], ",");
                    int originCol = Integer.parseInt(values[0]);
                    int originRow = Integer.parseInt(values[1]);
                    int destCol = Integer.parseInt(values[2]);
                    int destRow = Integer.parseInt(values[3]);
                    if (columns[originCol].size() <= originRow) {
                        throw new IndexOutOfBoundsException();
                    }
                    Object portletEntry = columns[originCol].get(originRow);
                    if (columns[originCol].contains(portletEntry)) {
                        columns[originCol].remove(originRow);
                    }
                    columns[destCol].add(destRow, portletEntry);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }
}

