/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseCategory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public abstract class PortletFilter {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletFilter.class.getName());

    public static List filterPortlets(List portlets, String field, String value) {
        String[] fields = new String[]{field};
        String[] values = new String[]{value};
        return PortletFilter.filterPortlets(portlets, fields, values);
    }

    public static List filterPortlets(List portlets, String[] fields, String[] values) {
        ArrayList<PortletEntry> filteredPortlets = new ArrayList<PortletEntry>();
        for (PortletEntry entry : portlets) {
            if (!PortletFilter.isFilteredIn(entry, fields, values)) continue;
            filteredPortlets.add(entry);
        }
        return filteredPortlets;
    }

    private static boolean isFilteredIn(PortletEntry entry, String[] fields, String[] values) {
        boolean result = true;
        if (fields != null && values != null && fields.length == values.length) {
            for (int i = 0; i < fields.length && result; ++i) {
                String field = fields[i];
                String value = values[i];
                if (field == null || value == null || field.length() == 0 || value.length() == 0) continue;
                if (field.equals("category")) {
                    result = result && entry.hasCategory(value);
                    continue;
                }
                if (field.equals("media_type")) {
                    result = result && entry.hasMediaType(value);
                    continue;
                }
                if (field.equals("parent")) {
                    if (entry.getParent() != null) {
                        result = result && entry.getParent().equals(value);
                        continue;
                    }
                    result = false;
                    continue;
                }
                if (field.equals("type")) {
                    if (entry.getType() != null) {
                        result = result && entry.getType().equals(value);
                        continue;
                    }
                    result = false;
                    continue;
                }
                logger.warn("Invalid filter " + field + " attempted");
            }
        }
        return result;
    }

    public static List buildCategoryList(List portlets) {
        TreeMap<String, BaseCategory> catMap = new TreeMap<String, BaseCategory>();
        for (PortletEntry entry : portlets) {
            Iterator cItr = entry.listCategories();
            while (cItr.hasNext()) {
                BaseCategory cat = (BaseCategory)cItr.next();
                catMap.put(cat.getName(), cat);
            }
        }
        return new ArrayList(catMap.values());
    }

    public static List getAllPortlets() {
        ArrayList<RegistryEntry> regEntries = new ArrayList<RegistryEntry>();
        Iterator iter = Registry.get(Registry.PORTLET).listEntryNames();
        while (iter.hasNext()) {
            String entryName = (String)iter.next();
            regEntries.add(Registry.getEntry(Registry.PORTLET, entryName));
        }
        return regEntries;
    }

    public static List buildParentList(List portlets) {
        HashSet<PortletEntry> parentSet = new HashSet<PortletEntry>();
        for (PortletEntry regEntry : portlets) {
            String regType = regEntry.getType();
            if (!regType.equalsIgnoreCase("abstract")) continue;
            parentSet.add(regEntry);
        }
        return new ArrayList(parentSet);
    }
}

