/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.registry.CapabilityMap;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.PortletInfoEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseCachedParameter;
import org.apache.jetspeed.om.registry.base.BaseParameter;
import org.apache.jetspeed.om.registry.base.BaseSecurity;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.velocity.context.Context;

public abstract class RegistryUpdateAction
extends SecureVelocityPortletAction {
    protected String registryEntryName = "";
    protected String registry = "";
    protected String pane = "";
    private static final String REASON = "reason";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(RegistryUpdateAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        int id;
        String msgid = rundata.getParameters().getString("msgid");
        if (msgid != null && (id = Integer.parseInt(msgid)) < SecurityConstants.MESSAGES.length) {
            context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
        }
        String mode = rundata.getParameters().getString("mode");
        context.put("mode", (Object)mode);
        String reason = rundata.getParameters().getString(REASON);
        context.put(REASON, (Object)reason);
    }

    public void doInsert(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            if (entryName == null || entryName.length() == 0) {
                DynamicURI duri = this.redirect(rundata, "insert", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
            } else {
                RegistryEntry existingEntry = Registry.getEntry(this.registry, entryName);
                if (existingEntry != null) {
                    throw new EntityExistsException("RegistryEntry: " + entryName + " Already Exists!");
                }
                RegistryEntry registryEntry = Registry.createEntry(this.registry);
                registryEntry.setName(entryName);
                this.updateRegistryEntry(rundata, registryEntry);
                Registry.addEntry(this.registry, registryEntry);
                this.clearUserData(rundata);
                rundata.getUser().setTemp("RegistryBrowseAction:" + this.registry + ":" + "refresh", (Object)Boolean.TRUE);
            }
        }
        catch (EntityExistsException e) {
            DynamicURI duri = this.redirect(rundata, "insert", 3);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error(((Object)((Object)this)).getClass().getName() + ": Trying to create duplicate entry");
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "insert", 0);
            duri = duri.addQueryData(REASON, e.getMessage());
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doUpdate(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            RegistryEntry registryEntry = Registry.getEntry(this.registry, entryName);
            if (registryEntry != null) {
                this.updateRegistryEntry(rundata, registryEntry);
                Registry.addEntry(this.registry, registryEntry);
                this.clearUserData(rundata);
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry for updating");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            duri = duri.addQueryData(REASON, e.getMessage());
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doDelete(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            if (entryName == null || entryName.length() == 0) {
                DynamicURI duri = this.redirect(rundata, "delete", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry for deleting");
            } else {
                Registry.removeEntry(this.registry, entryName);
                this.clearUserData(rundata);
                rundata.getUser().setTemp("RegistryBrowseAction:" + this.registry + ":" + "refresh", (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "delete", 1);
            duri = duri.addQueryData(REASON, e.getMessage());
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doCancel(RunData rundata, Context context) throws Exception {
        this.clearUserData(rundata);
    }

    protected void updateRegistryEntry(RunData rundata, RegistryEntry registryEntry) throws Exception {
        String description = rundata.getParameters().getString("description");
        String title = rundata.getParameters().getString("title");
        Boolean hidden = rundata.getParameters().getBool("hidden");
        String securityRef = rundata.getParameters().getString("security_ref");
        SecurityReference security = registryEntry.getSecurityRef();
        String securityParent = null;
        if (security != null) {
            securityParent = security.getParent();
        }
        if (this.hasChanged(securityParent, securityRef)) {
            if (security == null) {
                security = new BaseSecurityReference();
            }
            security.setParent(securityRef);
            registryEntry.setSecurityRef(security);
        }
        if (this.hasChanged(registryEntry.getDescription(), description)) {
            registryEntry.setDescription(description);
        }
        if (this.hasChanged(String.valueOf(registryEntry.isHidden()), String.valueOf(hidden))) {
            registryEntry.setHidden(hidden);
        }
        if (this.hasChanged(registryEntry.getTitle(), title)) {
            registryEntry.setTitle(title);
        }
    }

    protected boolean hasChanged(String oldValue, String newValue) {
        boolean result = false;
        if (oldValue == null && newValue == null) {
            result = false;
        } else if (oldValue == null && newValue != null && newValue.length() == 0) {
            result = false;
        } else if (oldValue == null && newValue != null) {
            result = true;
        } else if (oldValue != null && newValue == null) {
            result = true;
        } else if (!oldValue.equals(newValue)) {
            result = true;
        }
        return result;
    }

    public void doAddparameter(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            PortletInfoEntry regEntry = (PortletInfoEntry)Registry.getEntry(this.registry, entryName);
            if (regEntry != null) {
                String parameterName = rundata.getParameters().getString("parameter_name");
                if (parameterName != null && parameterName.length() > 0) {
                    BaseParameter parameter = null;
                    if (regEntry instanceof PortletEntry) {
                        parameter = new BaseCachedParameter();
                        boolean isCachedOnName = rundata.getParameters().getBoolean("cached_on_name", false);
                        boolean isCachedOnValue = rundata.getParameters().getBoolean("cached_on_value", false);
                        ((BaseCachedParameter)parameter).setCachedOnName(isCachedOnName);
                        ((BaseCachedParameter)parameter).setCachedOnValue(isCachedOnValue);
                    } else {
                        parameter = new BaseParameter();
                    }
                    String parameterValue = rundata.getParameters().getString("parameter_value");
                    boolean isHidden = rundata.getParameters().getBoolean("is_hidden", false);
                    String description = rundata.getParameters().getString("description");
                    String title = rundata.getParameters().getString("title");
                    String type = rundata.getParameters().getString("type");
                    parameter.setName(parameterName);
                    parameter.setValue(parameterValue);
                    parameter.setHidden(isHidden);
                    parameter.setDescription(description);
                    parameter.setTitle(title);
                    parameter.setType(type);
                    String securityRole = rundata.getParameters().getString("security_role");
                    String securityRef = rundata.getParameters().getString("security_ref");
                    if (securityRole != null && securityRole.length() > 0) {
                        BaseSecurity paramSecurity = new BaseSecurity();
                        paramSecurity.setRole(securityRole);
                        parameter.setSecurity(paramSecurity);
                    }
                    if (securityRef != null && securityRef.length() > 0) {
                        BaseSecurityReference paramSecurityRef = new BaseSecurityReference();
                        paramSecurityRef.setParent(securityRef);
                        parameter.setSecurityRef(paramSecurityRef);
                    }
                    regEntry.addParameter(parameter);
                    Registry.addEntry(this.registry, regEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to add a parameter");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 2);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doUpdateparameters(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            PortletInfoEntry regEntry = (PortletInfoEntry)Registry.getEntry(this.registry, entryName);
            if (regEntry != null) {
                String[] parameters = rundata.getParameters().getStrings("update_parameter_name");
                if (parameters != null && parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String parameterName = parameters[i];
                        Parameter parameter = regEntry.getParameter(parameterName);
                        if (regEntry instanceof PortletEntry) {
                            if (parameter == null) {
                                parameter = new BaseCachedParameter();
                                regEntry.addParameter(parameter);
                            }
                            boolean isCachedOnName = rundata.getParameters().getBoolean(parameterName + ".cached_on_name", false);
                            boolean isCachedOnValue = rundata.getParameters().getBoolean(parameterName + ".cached_on_value", false);
                            ((BaseCachedParameter)parameter).setCachedOnName(isCachedOnName);
                            ((BaseCachedParameter)parameter).setCachedOnValue(isCachedOnValue);
                        } else if (parameter == null) {
                            parameter = new BaseParameter();
                            regEntry.addParameter(parameter);
                        }
                        String parameterValue = rundata.getParameters().getString(parameterName + ".parameter_value");
                        String description = rundata.getParameters().getString(parameterName + ".description");
                        String title = rundata.getParameters().getString(parameterName + ".title");
                        String securityRole = rundata.getParameters().getString(parameterName + ".security_role");
                        String securityRef = rundata.getParameters().getString(parameterName + ".security_ref");
                        String type = rundata.getParameters().getString(parameterName + ".type");
                        boolean isHidden = rundata.getParameters().getBoolean(parameterName + ".is_hidden", false);
                        parameter.setName(parameterName);
                        parameter.setValue(parameterValue);
                        parameter.setHidden(isHidden);
                        parameter.setDescription(description);
                        parameter.setTitle(title);
                        parameter.setType(type);
                        if (securityRef == null || securityRef.length() <= 0) continue;
                        BaseSecurityReference paramSecurityRef = new BaseSecurityReference();
                        paramSecurityRef.setParent(securityRef);
                        parameter.setSecurityRef(paramSecurityRef);
                    }
                    Registry.addEntry(this.registry, regEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to update parameters");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doUpdateparametervalues(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            PortletInfoEntry regEntry = (PortletInfoEntry)Registry.getEntry(this.registry, entryName);
            if (regEntry != null) {
                String[] parameters = rundata.getParameters().getStrings("update_parameter_name");
                if (parameters != null && parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String parameterName = parameters[i];
                        String parameterValue = rundata.getParameters().getString(parameterName + ".parameter_value");
                        Parameter parameter = regEntry.getParameter(parameterName);
                        if (parameter == null) {
                            parameter = regEntry instanceof PortletEntry ? new BaseCachedParameter() : new BaseParameter();
                            parameter.setName(parameterName);
                            regEntry.addParameter(parameter);
                        }
                        if (parameter == null) continue;
                        parameter.setValue(parameterValue);
                    }
                    Registry.addEntry(this.registry, regEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to update parameters");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doRemoveparameters(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            PortletInfoEntry portletEntry = (PortletInfoEntry)Registry.getEntry(this.registry, entryName);
            if (portletEntry != null) {
                String[] parameters = rundata.getParameters().getStrings("parameter_name");
                if (parameters != null && parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        String parameterName = parameters[i];
                        portletEntry.removeParameter(parameterName);
                    }
                    Registry.addEntry(this.registry, portletEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to remove parameters");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doAddmediatype(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            PortletInfoEntry portletEntry = (PortletInfoEntry)Registry.getEntry(this.registry, entryName);
            if (portletEntry != null) {
                String mediaType = rundata.getParameters().getString("media_type");
                if (mediaType != null && mediaType.length() > 0) {
                    portletEntry.addMediaType(mediaType);
                    Registry.addEntry(this.registry, portletEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to add media type");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doRemovemediatypes(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            PortletInfoEntry portletEntry = (PortletInfoEntry)Registry.getEntry(this.registry, entryName);
            if (portletEntry != null) {
                String[] mediaTypes = rundata.getParameters().getStrings("media_type");
                if (mediaTypes != null && mediaTypes.length > 0) {
                    for (int i = 0; i < mediaTypes.length; ++i) {
                        String mediaType = mediaTypes[i];
                        portletEntry.removeMediaType(mediaType);
                    }
                    Registry.addEntry(this.registry, portletEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to remove media types");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doAddcapability(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            RegistryEntry regEntry = Registry.getEntry(this.registry, entryName);
            if (regEntry != null) {
                CapabilityMap cm = null;
                if (regEntry instanceof MediaTypeEntry) {
                    MediaTypeEntry mediaTypeEntry = (MediaTypeEntry)regEntry;
                    cm = mediaTypeEntry.getCapabilityMap();
                } else if (regEntry instanceof ClientEntry) {
                    ClientEntry clientEntry = (ClientEntry)regEntry;
                    cm = clientEntry.getCapabilityMap();
                }
                if (cm != null) {
                    String[] capabilities = rundata.getParameters().getStrings("capability");
                    if (capabilities != null && capabilities.length > 0) {
                        for (int i = 0; i < capabilities.length; ++i) {
                            String capability = capabilities[i];
                            if (cm.contains(capability) || capability == null || capability.length() <= 0) continue;
                            cm.addCapability(capability);
                        }
                    }
                    Registry.addEntry(this.registry, regEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 0);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to add capabilities");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doRemovecapability(RunData rundata, Context context) throws Exception {
        try {
            String entryName = rundata.getParameters().getString(this.registryEntryName);
            RegistryEntry regEntry = Registry.getEntry(this.registry, entryName);
            if (regEntry != null) {
                CapabilityMap cm = null;
                if (regEntry instanceof MediaTypeEntry) {
                    MediaTypeEntry mediaTypeEntry = (MediaTypeEntry)regEntry;
                    cm = mediaTypeEntry.getCapabilityMap();
                } else if (regEntry instanceof ClientEntry) {
                    ClientEntry clientEntry = (ClientEntry)regEntry;
                    cm = clientEntry.getCapabilityMap();
                }
                if (cm != null) {
                    String[] capabilities = rundata.getParameters().getStrings("capability");
                    if (capabilities != null && capabilities.length > 0) {
                        for (int i = 0; i < capabilities.length; ++i) {
                            String capability = capabilities[i];
                            cm.removeCapability(capability);
                        }
                        Registry.addEntry(this.registry, regEntry);
                        this.clearUserData(rundata);
                    }
                    Registry.addEntry(this.registry, regEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 0);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error(((Object)((Object)this)).getClass().getName() + ": Failed to find registry entry while trying to remove capabilities");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    protected DynamicURI redirect(RunData rundata, String mode, int reason) throws TurbineException {
        JetspeedLink link = JetspeedLinkFactory.getInstance(rundata);
        DynamicURI duri = link.getPaneByName(this.pane).addPathInfo("mode", mode).addPathInfo("msgid", reason);
        String entryName = rundata.getParameters().getString(this.registryEntryName);
        if (entryName != null && entryName.length() > 0) {
            duri.addQueryData(this.registryEntryName, entryName);
        }
        JetspeedLinkFactory.putInstance(link);
        return duri;
    }

    protected void clearUserData(RunData rundata) {
        rundata.getUser().removeTemp(this.registryEntryName);
        rundata.getUser().removeTemp("title");
        rundata.getUser().removeTemp("description");
    }

    protected void resetForm(RunData rundata) {
        String entryName = rundata.getParameters().getString(this.registryEntryName);
        String title = rundata.getParameters().getString("title");
        String description = rundata.getParameters().getString("description");
        rundata.getUser().setTemp(this.registryEntryName, (Object)entryName);
        rundata.getUser().setTemp("title", (Object)title);
        rundata.getUser().setTemp("description", (Object)description);
    }

    protected Collection iteratorToCollection(Iterator iter) {
        ArrayList collection = new ArrayList();
        while (iter.hasNext()) {
            collection.add(iter.next());
        }
        return collection;
    }
}

