/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets.security;

import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.portlets.SecureVelocityPortletAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.modules.actions.portlets.security.UserRoleUpdateAction;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.GroupRole;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class UserGroupRoleUpdateAction
extends SecureVelocityPortletAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(UserRoleUpdateAction.class.getName());

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            int id;
            String entityid = rundata.getParameters().getString("entityid");
            if (entityid == null || entityid.trim().length() == 0) {
                return;
            }
            this.buildUserGroupRoleContext(portlet, context, rundata, entityid);
            String msgid = rundata.getParameters().getString("msgid");
            if (msgid != null && (id = Integer.parseInt(msgid)) < SecurityConstants.MESSAGES.length) {
                context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
            }
        }
        catch (Exception e) {
            logger.error("Error in Jetspeed User Group Role Security", e);
            rundata.setMessage("Error in Jetspeed User Group Role Security: " + e.toString());
            rundata.setStackTrace(StringUtils.stackTrace((Throwable)e), (Throwable)e);
            rundata.setScreenTemplate(JetspeedResources.getString("template.error", "Error"));
        }
    }

    private void appendNewRoleProfile(JetspeedRunData jdata, JetspeedUser user, Role role) throws Exception {
        ProfileLocator roleLocator = Profiler.createLocator();
        roleLocator.setRole(role);
        roleLocator.setMediaType(jdata.getCapability().getPreferredMediaType());
        roleLocator.setName("default.psml");
        Profile roleProfile = Profiler.getProfile(roleLocator);
        if (roleProfile != null && logger.isDebugEnabled()) {
            logger.debug("UserGroupRoleUpdateAction: retrieved profile for role: " + roleProfile.getPath());
        }
        ProfileLocator userLocator = Profiler.createLocator();
        userLocator.setUser(user);
        userLocator.setMediaType(jdata.getCapability().getPreferredMediaType());
        userLocator.setName("default.psml");
        Profile userProfile = Profiler.getProfile(userLocator);
        if (userProfile != null && logger.isDebugEnabled()) {
            logger.debug("UserGroupRoleUpdateAction: retrieved profile for user: " + userProfile.getPath());
        }
        if (roleProfile != null && roleProfile.getDocument() != null && userProfile != null && userProfile.getDocument() != null) {
            Profile tmpProfile = (Profile)roleProfile.clone();
            Portlets rolePortlets = tmpProfile.getDocument().getPortlets();
            Portlets userPortlets = userProfile.getDocument().getPortlets();
            if (rolePortlets.getPortletsCount() > 0) {
                for (int i = 0; i < rolePortlets.getPortletsCount(); ++i) {
                    Portlets pane = rolePortlets.getPortlets(i);
                    pane.setLayout(null);
                    userPortlets.addPortlets(pane);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("UserRoleUpdateAction: appended pane: " + pane.getId() + " to user: " + user.getUserName());
                }
            } else {
                if (rolePortlets.getTitle() == null) {
                    String title = StringUtils.firstLetterCaps((String)roleProfile.getRoleName());
                    rolePortlets.setTitle(title + " Home");
                }
                rolePortlets.setLayout(null);
                userPortlets.addPortlets(rolePortlets);
            }
            PortletUtils.regenerateIds(userPortlets);
            PsmlManager.store(userProfile);
        }
    }

    private void buildUserGroupRoleContext(VelocityPortlet portlet, Context context, RunData rundata, String userid) throws Exception {
        JetspeedUser user = JetspeedSecurity.getUser(userid);
        if (null == user) {
            logger.error("UserGroupRoleBrowser: Failed to get user: " + userid);
            return;
        }
        Iterator roles = JetspeedSecurity.getRoles();
        Vector<Role> masterRoles = new Vector<Role>();
        while (roles.hasNext()) {
            Role role = (Role)roles.next();
            masterRoles.add(role);
        }
        Iterator groups = JetspeedSecurity.getGroups();
        Vector<Group> masterGroups = new Vector<Group>();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            masterGroups.add(group);
        }
        Vector<String> selected = new Vector<String>();
        Iterator groupRoles = JetspeedSecurity.getRoles(userid);
        while (groupRoles.hasNext()) {
            GroupRole gr = (GroupRole)groupRoles.next();
            selected.add(gr.getGroup().getName() + gr.getRole().getName());
        }
        rundata.getUser().setTemp("roles", masterRoles);
        rundata.getUser().setTemp("groups", masterGroups);
        rundata.getUser().setTemp("selected", selected);
        context.put("user", (Object)user);
        context.put("roles", masterRoles);
        context.put("groups", masterGroups);
        context.put("selected", selected);
    }

    public void doRoles(RunData data, Context context) throws Exception {
        String username = data.getParameters().getString("username");
        JetspeedUser user = JetspeedSecurity.getUser(username);
        Iterator groups = JetspeedSecurity.getGroups();
        while (groups.hasNext()) {
            String groupName = ((Group)groups.next()).getName();
            Iterator roles = JetspeedSecurity.getRoles();
            while (roles.hasNext()) {
                Role role = (Role)roles.next();
                String roleName = role.getName();
                String groupRole = groupName + roleName;
                String formGroupRole = data.getParameters().getString(groupRole);
                if (formGroupRole != null && !JetspeedSecurity.hasRole(username, roleName, groupName)) {
                    JetspeedSecurity.grantRole(username, roleName, groupName);
                    if (!Profiler.useRoleProfileMerging()) continue;
                    this.appendNewRoleProfile((JetspeedRunData)data, user, role);
                    continue;
                }
                if (formGroupRole != null || !JetspeedSecurity.hasRole(username, roleName, groupName)) continue;
                JetspeedSecurity.revokeRole(username, roleName, groupName);
            }
        }
    }
}

