/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.layouts;

import java.io.IOException;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Doctype;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.wml.Do;
import org.apache.ecs.wml.DoType;
import org.apache.ecs.wml.Prev;
import org.apache.ecs.wml.Template;
import org.apache.ecs.wml.WML;
import org.apache.ecs.xml.PI;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.util.RunData;

public class JetspeedLayout
extends Layout {
    public static final String TOP = JetspeedResources.getString("navigations.top");
    public static final String BOTTOM = JetspeedResources.getString("navigations.bottom");
    public static final Doctype WML_DOCTYPE = new Doctype("wml", "PUBLIC", "\"-//WAPFORUM//DTD WML 1.1//EN\"", "\"http://www.wapforum.org/DTD/wml_1.1.xml\"");
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedLayout.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBuild(RunData data) throws Exception {
        CapabilityMap cm = ((JetspeedRunData)data).getCapability();
        MimeType mt = cm.getPreferredType();
        data.setContentType(mt.getContentType());
        data.setCharSet(mt.getCharSet());
        if (logger.isDebugEnabled()) {
            logger.debug("Layout: Setting type to: " + mt);
        }
        if (mt.equals(MimeType.WML)) {
            ElementContainer ec = new ElementContainer();
            WML wml = new WML();
            ec.addElement((Element)new PI().setVersion(1.0));
            ec.addElement((Element)WML_DOCTYPE);
            ec.addElement((Element)wml);
            wml.addElement((Element)new Template().addElement((Element)new Do(DoType.ACCEPT, "Back").addElement((Element)new Prev())));
            ConcreteElement screen = ScreenLoader.getInstance().eval(data, data.getScreen());
            if (screen != null) {
                wml.addElement((Element)screen);
            }
            try {
                ec.output(data.getOut());
            }
            catch (IOException e) {
                logger.error("Exception", e);
            }
            finally {
                ec = null;
            }
        } else {
            ConcreteElement screen;
            ConcreteElement topNav = NavigationLoader.getInstance().eval(data, TOP);
            if (topNav != null) {
                data.getPage().getBody().addElement((Element)topNav);
            }
            if ((screen = ScreenLoader.getInstance().eval(data, data.getScreen())) != null) {
                data.getPage().getBody().addElement((Element)screen);
            }
            data.getPage().getTitle().addElement(data.getTitle());
            data.getPage().getBody().setBgColor("#FFFFFF");
            ConcreteElement bottomNav = NavigationLoader.getInstance().eval(data, BOTTOM);
            if (bottomNav != null) {
                data.getPage().getBody().addElement((Element)bottomNav);
            }
        }
    }
}

