/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.dbpsml;

import java.sql.Connection;
import java.util.List;
import org.apache.jetspeed.om.dbpsml.BaseJetspeedRoleProfilePeer;
import org.apache.jetspeed.om.dbpsml.JetspeedRoleProfile;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.psmlmanager.db.DBOperations;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.services.psmlmanager.db.DatabasePsmlManager;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class JetspeedRoleProfilePeer
extends BaseJetspeedRoleProfilePeer
implements DBOperations {
    public void insert(Profile profile, Connection connection) throws Exception {
        this.doInsertOrUpdate(profile, 1, connection);
    }

    public void update(Profile profile, Connection connection) throws Exception {
        this.doInsertOrUpdate(profile, 2, connection);
    }

    private void doInsertOrUpdate(Profile profile, int operation, Connection connection) throws Exception {
        JetspeedRoleProfile roleProfile = new JetspeedRoleProfile();
        DatabasePsmlManager service = (DatabasePsmlManager)PsmlManager.getService();
        roleProfile.setRoleName(profile.getRole().getName());
        roleProfile.setMediaType(profile.getMediaType());
        String language = profile.getLanguage();
        if (language != null && !language.equals("-1")) {
            roleProfile.setLanguage(language);
        } else {
            roleProfile.setLanguage(null);
        }
        String country = profile.getCountry();
        if (country != null && !country.equals("-1")) {
            roleProfile.setCountry(country);
        } else {
            roleProfile.setCountry(null);
        }
        String name = profile.getName();
        if (name == null || name.equals("")) {
            profile.setName("default.psml");
        } else if (!name.endsWith(".psml")) {
            profile.setName(name + ".psml");
        }
        roleProfile.setPage(profile.getName());
        roleProfile.setProfile(DBUtils.portletsToBytes(profile.getDocument().getPortlets(), service.getMapping()));
        if (operation == 1) {
            BaseJetspeedRoleProfilePeer.doInsert(roleProfile, connection);
        } else if (operation == 2) {
            Criteria values = JetspeedRoleProfilePeer.buildCriteria(roleProfile);
            Criteria select = JetspeedRoleProfilePeer.buildCriteria(roleProfile);
            select.remove(PROFILE);
            BasePeer.doUpdate((Criteria)select, (Criteria)values, (Connection)connection);
        }
    }

    public void delete(ProfileLocator locator, Connection connection) throws Exception {
        BaseJetspeedRoleProfilePeer.doDelete(this.buildCriteria(locator), connection);
    }

    public List select(ProfileLocator locator, Connection connection) throws Exception {
        return BaseJetspeedRoleProfilePeer.doSelect(this.buildCriteria(locator), connection);
    }

    public List selectOrdered(ProfileLocator locator, Connection connection) throws Exception {
        Criteria criteria = this.buildCriteria(locator);
        criteria.addAscendingOrderByColumn(ROLE_NAME);
        criteria.addAscendingOrderByColumn(MEDIA_TYPE);
        criteria.addAscendingOrderByColumn(LANGUAGE);
        criteria.addAscendingOrderByColumn(COUNTRY);
        criteria.addAscendingOrderByColumn(PAGE);
        return BaseJetspeedRoleProfilePeer.doSelect(criteria, connection);
    }

    public void delete(Role role, Connection connection) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(ROLE_NAME, (Object)role.getName());
        BaseJetspeedRoleProfilePeer.doDelete(criteria, connection);
    }

    protected Criteria buildCriteria(ProfileLocator locator) {
        Criteria criteria = new Criteria();
        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String roleName = null;
        Role role = locator.getRole();
        if (role != null) {
            roleName = role.getName();
        }
        if (roleName != null && roleName.length() > 0) {
            criteria.add(ROLE_NAME, (Object)roleName);
        }
        if (pageName != null && pageName.length() > 0) {
            criteria.add(PAGE, (Object)pageName);
        }
        if (mediaType != null && mediaType.length() > 0) {
            criteria.add(MEDIA_TYPE, (Object)locator.getMediaType());
        }
        if (language != null && language.length() > 0 && !language.equals("-1")) {
            criteria.add(LANGUAGE, (Object)language);
        } else if (language != null && language.equals("-1")) {
            criteria.add(LANGUAGE, null);
        }
        if (country != null && country.length() > 0 && !country.equals("-1")) {
            criteria.add(COUNTRY, (Object)country);
        } else if (country != null && country.equals("-1")) {
            criteria.add(COUNTRY, null);
        }
        return criteria;
    }
}

