/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.turbine.util.RunData;

public class AggregatePortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(AggregatePortlet.class.getName());

    public ConcreteElement getContent(RunData rundata) {
        String key = ((JetspeedRunData)rundata).getProfile().getId() + "." + this.getID();
        String path = (String)rundata.getUser().getTemp(key);
        if (path == null) {
            path = this.getPortletConfig().getInitParameter("path");
        }
        if (null == path) {
            return new JetspeedClearElement("Path parameter not set");
        }
        ProfileLocator locator = Profiler.createLocator();
        locator.createFromPath(path);
        String id = locator.getId();
        try {
            Profile profile = Profiler.getProfile(locator);
            PSMLDocument doc = profile.getDocument();
            if (doc == null) {
                return null;
            }
            Portlets portlets = doc.getPortlets();
            PortletSet ps = PortalToolkit.getSet(portlets);
            return ps.getContent(rundata);
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return new JetspeedClearElement("Error in aggregation portlet: " + e.toString());
        }
    }
}

