/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.portlets;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.B;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.RunData;

public class PortletInfoPortlet
extends AbstractPortlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletInfoPortlet.class.getName());
    public static final String THIRDPARTY_PORTLETRENDERER_URL_KEY = "thirdparty.portletrenderer.url";
    public static final String THIRDPARTY_PORTLETRENDERER_CAPTION_KEY = "thirdparty.portletrenderer.caption";

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }

    public ConcreteElement getContent(RunData rundata) {
        String portletName = ((JetspeedRunData)rundata).getPortlet();
        DateFormat df = DateFormat.getDateTimeInstance();
        if (portletName == null) {
            String message = "Could not find given entry ";
            logger.error(message);
            return new StringElement(message);
        }
        Portlet portlet = null;
        try {
            portlet = PortletFactory.getPortlet(portletName, "0");
        }
        catch (PortletException e) {
            logger.error("Exception", e);
            return new StringElement(e.getMessage());
        }
        Table t = new Table();
        t.addElement((Element)this.getRow("Portlet name: " + portlet.getName()));
        String url = portlet.getPortletConfig().getURL();
        if (url != null) {
            t.addElement((Element)this.getRow("From URL: " + url));
            try {
                long urlUpdated = JetspeedDiskCache.getInstance().getEntry(url).getLastModified();
                t.addElement((Element)this.getRow("URL last updated:  " + df.format(new Date(urlUpdated))));
                long urlExpires = JetspeedDiskCache.getInstance().getEntry(url).getExpirationTime();
                t.addElement((Element)this.getRow("URL expires:  " + df.format(new Date(urlExpires))));
            }
            catch (IOException e) {
                logger.error("Exception", e);
            }
        }
        t.addElement((Element)this.getRow("Portlet last updated:  " + df.format(new Date(portlet.getCreationTime()))));
        t.addElement((Element)new TR().addElement((Element)new TD().addElement((Element)new B().addElement("Actions:"))));
        String internal = null;
        JetspeedLink jsLink = null;
        try {
            jsLink = JetspeedLinkFactory.getInstance(rundata);
            String mtype = rundata.getParameters().getString("mtype");
            if (mtype != null) {
                jsLink.setMediaType(mtype);
                jsLink.addQueryData("mtype", mtype);
            }
            String js_peid = rundata.getParameters().getString("js_peid");
            internal = jsLink.addPathInfo("js_peid", js_peid).setAction("controls.Maximize").toString();
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        JetspeedLinkFactory.putInstance(jsLink);
        StringBuffer external = new StringBuffer(this.getPortletConfig().getInitParameter(THIRDPARTY_PORTLETRENDERER_URL_KEY));
        external.append("&title=" + URLEncoder.encode(portlet.getTitle()));
        external.append("&url=" + URLEncoder.encode(internal));
        String message = this.getPortletConfig().getInitParameter(THIRDPARTY_PORTLETRENDERER_CAPTION_KEY);
        t.addElement((Element)new TR().addElement((Element)new TD().addElement((Element)new A(external.toString()).setTarget("_blank").addElement(message))));
        Iterator names = portlet.getPortletConfig().getInitParameterNames();
        if (names.hasNext()) {
            t.addElement((Element)new TR().addElement((Element)new TD().addElement((Element)new B().addElement("Properties:"))));
        }
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = portlet.getPortletConfig().getInitParameter(name);
            t.addElement((Element)new TR().addElement((Element)new TD(name + ":  " + value)));
        }
        return t;
    }

    private ConcreteElement getRow(String message) {
        return new TR().addElement((Element)new TD().setNoWrap(true).addElement(message));
    }
}

