/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.jetspeed.modules.ParameterLoader;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.turbine.util.RunData;

public class JetspeedParameterStyleTag
extends BodyTagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedParameterStyleTag.class.getName());
    private String name = null;
    private String style = null;
    private String value = null;
    private String portlet = null;

    public void setName(String value) {
        this.name = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setStyle(String value) {
        this.style = value;
    }

    public void setPortlet(String value) {
        this.portlet = value;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        String result = null;
        try {
            String body = this.getBodyContent() == null ? null : this.getBodyContent().getString();
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (body != null && !body.trim().equalsIgnoreCase("")) {
                StringTokenizer st = new StringTokenizer(body, ";");
                String prefix = this.name + ".style.";
                while (st.hasMoreTokens()) {
                    StringTokenizer pair = new StringTokenizer(st.nextToken(), "=");
                    if (pair.countTokens() != 2) continue;
                    options.put(prefix + pair.nextToken().trim(), pair.nextToken().trim());
                }
            }
            boolean canAccess = true;
            if (this.portlet != null) {
                PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, this.portlet);
                Parameter param = entry.getParameter(this.name);
                canAccess = JetspeedSecurity.checkPermission((JetspeedUser)data.getUser(), new PortalResource(entry, param), "customize");
            }
            if (canAccess) {
                result = ParameterLoader.getInstance().eval(data, this.style, this.name, this.value, options);
            }
            this.pageContext.getOut().print(result);
        }
        catch (Exception e) {
            result = "<input type=\"text\" name=\"" + this.name + "\" value=\"" + this.value + "\"";
            String message = "Error processing portlet (PortletTag): [" + this.name + "]";
            logger.error(message, e);
            try {
                this.pageContext.getOut().print(result);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 6;
    }
}

