/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

public class JetspeedPortletLinkTag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortletLinkTag.class.getName());
    private String name = null;
    private String jspeid = null;
    private String psml = null;
    private String action = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPsml(String psml) {
        this.psml = psml;
    }

    public String getPsml() {
        return this.psml;
    }

    public void setJspeid(String value) {
        this.jspeid = value;
    }

    public String getJspeid() {
        return this.jspeid;
    }

    public void setAction(String value) {
        this.action = value;
    }

    public String getAction() {
        return this.action;
    }

    public int doStartTag() throws JspException {
        JetspeedRunData data = (JetspeedRunData)this.pageContext.getAttribute("rundata", 2);
        try {
            StringElement result = null;
            Profile baseProfile = null;
            ProfileLocator baseLocator = Profiler.createLocator();
            int rootType = 102;
            String rootValue = null;
            int elementType = 102;
            String elementValue = null;
            if (this.psml != null) {
                baseLocator.createFromPath(this.psml);
                if (baseLocator.getUser() != null) {
                    rootType = 203;
                    rootValue = baseLocator.getUserName();
                } else if (baseLocator.getRole() != null) {
                    rootType = 202;
                    rootValue = baseLocator.getRoleName();
                } else if (baseLocator.getGroup() != null) {
                    rootType = 201;
                    rootValue = baseLocator.getGroupName();
                }
            } else {
                rootType = 101;
                rootValue = "";
                baseProfile = data.getProfile();
                baseLocator.createFromPath(baseProfile.getPath());
            }
            if (baseLocator != null) {
                if (this.name != null) {
                    elementType = 305;
                    elementValue = this.name;
                } else if (this.jspeid != null) {
                    elementType = 303;
                    elementValue = this.jspeid;
                }
                JetspeedLink link = JetspeedLinkFactory.getInstance((RunData)data);
                DynamicURI uri = link.getLink(rootType, rootValue, baseLocator.getName(), elementType, elementValue, this.action == null ? "controls.Maximize" : this.action, null, baseLocator.getMediaType(), baseLocator.getLanguage(), baseLocator.getCountry());
                result = new StringElement(uri.toString());
                JetspeedLinkFactory.putInstance(link);
            }
            if (result != null) {
                this.pageContext.getOut().print(result);
            }
        }
        catch (Exception e) {
            String message = "Error processing name '" + this.name + "'.";
            logger.error(message, e);
            try {
                data.getOut().print("Error processing portlet '" + this.name + "'. See log for more information.");
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 1;
    }
}

