/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;

public class NavigationTag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(NavigationTag.class.getName());
    private String defaultTemplate;
    private String loggedInTemplate;

    public void setDefaultTemplate(String defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public void setLoggedInTemplate(String loggedInTemplate) {
        this.loggedInTemplate = loggedInTemplate;
    }

    public int doStartTag() throws JspException {
        String template = this.defaultTemplate;
        String module = null;
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        try {
            if (data != null && data.getUser() != null && data.getUser().hasLoggedIn() && this.loggedInTemplate != null) {
                template = this.loggedInTemplate;
            }
            data.getTemplateInfo().setNavigationTemplate(TemplateLocator.locateNavigationTemplate(data, template));
            this.pageContext.getOut().flush();
            module = ((TemplateService)TurbineServices.getInstance().getService("TemplateService")).getNavigationName(template);
            NavigationLoader.getInstance().exec(data, module);
        }
        catch (Exception e) {
            String message = "Error processing navigation template:" + template + " using module: " + module;
            logger.error(message, e);
            try {
                data.getOut().print("Error processing navigation template: " + template + " using module: " + module);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 0;
    }
}

