/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.services.upload.TurbineUploadService;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.upload.FileItem;

public class JetspeedUploadService
extends TurbineUploadService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRequest(HttpServletRequest req, ParameterParser params, String path) throws TurbineException {
        MediaTypeEntry media;
        String contentType = req.getHeader("Content-type");
        if (!contentType.startsWith("multipart/form-data")) {
            throw new TurbineException("the request doesn't contain a multipart/form-data stream");
        }
        int requestSize = req.getContentLength();
        if (requestSize == -1) {
            throw new TurbineException("the request was rejected because it's size is unknown");
        }
        if (requestSize > TurbineUpload.getSizeMax()) {
            throw new TurbineException("the request was rejected because it's size exceeds allowed range");
        }
        String encoding = JetspeedResources.getString("content.defaultencoding", "US-ASCII");
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(req.getHeader("User-Agent"));
        String mimeCode = cm.getPreferredType().getCode();
        if (mimeCode != null && (media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, mimeCode)) != null && media.getCharacterSet() != null) {
            encoding = media.getCharacterSet();
        }
        try {
            byte[] boundary = contentType.substring(contentType.indexOf("boundary=") + 9).getBytes();
            ServletInputStream input = req.getInputStream();
            MultipartStream multi = new MultipartStream((InputStream)input, boundary);
            multi.setHeaderEncoding(encoding);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    FileItem item;
                    String subContentType = this.getHeader(headers, "Content-type");
                    if (subContentType != null && subContentType.startsWith("multipart/mixed")) {
                        byte[] subBoundary = subContentType.substring(subContentType.indexOf("boundary=") + 9).getBytes();
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                FileItem item2 = this.createItem(path, headers, requestSize);
                                OutputStream os = item2.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                }
                                finally {
                                    os.close();
                                }
                                params.append(this.getFieldName(headers), item2);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else if (this.getFileName(headers) != null) {
                        item = this.createItem(path, headers, requestSize);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        params.append(this.getFieldName(headers), item);
                    } else {
                        item = this.createItem(path, headers, requestSize);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        params.append(this.getFieldName(headers), new String(item.get()));
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            throw new TurbineException("Processing of multipart/form-data request failed", (Throwable)e);
        }
    }
}

